# IRAF script -- cmkmsnflat.cl
#
#   function: to make a normalized flat frame (moving skyflat or twilight flat)
#
#	
# programmer: sjchan (january 1997, oct1997, nov1997)
#     history: jan97 -- created
#              oct97 and nov97 -- modified
#              may98  -- rename: ccmknflat (cqlv102 version) --> cmkmsnflat)
#              11aug98 -- add an option to let user have a chance to choose
#                          one's values of IMCOMBINE parameters
#

procedure cmkmsnflat(frame_in, frame_out, n_fold, useropt)

string	frame_in  {"", prompt="(@List of / *.fits) input images for making nflat",mode="ql"}
string  frame_out {"", prompt="Output Normalized Flat frame",mode="ql"}
int     n_fold    {1,  prompt="The starting fold number", mode="ql"}
bool    useropt   {no, prompt="User option to input IMCOMBINE parameters", mode="ql"}
pset mkskypar {prompt="Imcombine parameters to make sky flat images"}


begin
        string  ftmpi          # List of input images for making nflats
        string  frameout       # output nflat frame
        string  cflat          # dummy flats
        string  flatlog        # logfile
        int     nfold          # the starting fold number
        string  snfold         # the staring fold number in string 
        bool    useropt1   # User option to input IMCOMBINE parameters        

        flatlog="cmkmsnflat.log"

    #Get the rest of the parameter
        ftmpi = frame_in
        frameout=frame_out
        nfold = n_fold
        useropt1 = useropt
        cflat = "cflat.fits"
		
     #Check the existence of the logfile and flat frames
       if (access(flatlog))
             delete(flatlog, ver-, >& "dev$null")
       if (access(cflat))
             imdelete(cflat, ver-, >& "dev$null")  
       if (access(frameout))
             imdelete(frameout, ver-, >& "dev$null") 
     
     # make a combined Flat

            cmksky(ftmpi, cflat, nfold,  useropt1)
            rename("cmksky.log", flatlog)

     # Normalizing flat

          imsurfit(cflat, frameout, xorder=3, yorder=3, 
            type_output="response", function="legendre", cross_terms=no,
            xmedian=1, ymedian=1, median_perce=50., lower=3., upper=3., 
            ngrow=2, niter=1, regions="all", rows="*", columns="*", 
            border="10", sections="", circle="  ", div_min=INDEF)

          print("Input file of imsurfit is:", cflat, >> flatlog)
          print("Output file of imsurfit is:", frameout, >> flatlog) 
          print("    <<===== cmkmsnflat DONE =====>>", >> flatlog)

          print("    <<===== cmkmsnflat DONE =====>>")
          beep;beep; beep; beep; beep
      
end


