# IRAF script -- cmkdnflat.cl
#
#   function: to make a normalized flat frame (domeflat, twilight flat)
#
#	
# programmer: sjchan 
#            created: jan97
#            modified: oct97, nov97
#            modified: two input lists: bflats, dflats 
#                          output: one normalized flat
#            modified: rename: ccmknflat to cmkdnflat
#            11aug98 -- modified: add an option to use pset
#                       users have an chance to input their IMCOMBINE 
#                       parameters
#

procedure cmkdnflat(frame_inb, frame_ind, frame_out, n_fold, useropt)

string	frame_inb  {"@bflat.in", prompt="(@List of) Bflat frames (DomeOn/B-twilightflat/skyflat",mode="ql"}
string  frame_ind  {"@dflat.in",prompt="(@List of) Dflat frames (DomeOff/D-twilightflat/dark",mode="ql"}
string  frame_out {"", prompt="Output Normalized Flat frame",mode="ql"}
int     n_fold   {1,  prompt="The starting fold number", mode="ql"}
bool    useropt    {no, prompt="User option to input IMCOMBINE parameters", mode="ql"}
pset    mkflatpar {prompt="Imcombine parameters to make sky images"}



begin
        string  ftmpi[2]       # List of input flat string (bflats and dflats)
        string  ftmpo[2]       # combined bflat and dflat
                               # ([1]-- bflat, [2] -- dflat
        string  sflat          # temporary subtracted flat (bflat - dflat)
        string  frameout       # output nflat frame
        string  templog        # temporary logfile
        string  cmkflatlog        # logfile
        int     nfold          # the starting fold number
        bool    useropt1   # User option to input IMCOMBINE parameters
        int     i
        cmkflatlog="cmkdnflat.log"


    #Get the rest of the parameter

        ftmpi[1]=frame_inb
        ftmpi[2]=frame_ind
        frameout=frame_out
        nfold = n_fold
        useropt1 = useropt

        ftmpo[1]="bflatc.fits"
        ftmpo[2]="dflatc.fits"
        sflat="subflat.fits"

     #Check the existence of the logfile and flat frames
       if (access(cmkflatlog))
             delete(cmkflatlog, ver-, >& "dev$null")
       if (access(sflat))
             imdelete(sflat, ver-, >& "dev$null")  
       if (access(frameout))
             imdelete(frameout, ver-, >& "dev$null") 
       if (access(frameout//".fits"))
             imdelete(frameout//".fits", ver-, >& "dev$null")


      #(A) make a combined B/D Flat
           
        for (i=1; i <= 2; i += 1)
        {

          if (i == 1)
           {
             print("")
             print("", >> cmkflatlog)
             print("Making a Bright Flat Frame!", >> cmkflatlog)
             print("Making a Bright Flat Frame!")
             print("", >> cmkflatlog)
 
             if (access(ftmpo[1]))
                 delete(ftmpo[1], ver-, >& "dev$null")

           } # this brace is from if-block (i == 1))

          if (i == 2)
           {
             print("")
             print("", >> cmkflatlog)
             print("Making a Dark Flat Frame!", >> cmkflatlog)
             print("Making a Dark Flat Frame!")
             print("", >> cmkflatlog)

             if (access(ftmpo[2]))
                 delete(ftmpo[2], ver-, >& "dev$null")
           } #this brace is from if-else block (i>=2)

          templog="_mkcflat.log"
          _mkcflat(ftmpi[i],ftmpo[i],nfold,useropt1)

          unlearn type
          type (templog, >> cmkflatlog)

        } # this brace is from for loop (i=1;i<=2)

     #(B) Flat = BFlat - Dflat
     
          print("", >> cmkflatlog)
          print("BFlat - DFlat: ", >> cmkflatlog)
          imarith(operand1=ftmpo[1], op="-", operand2=ftmpo[2],
            result=sflat, title="", divzero=0., hparams="", 
            pixtype="real", calctype="real", verbose=yes, 
            noact=no, >> cmkflatlog) 
          print("", >> cmkflatlog)


     # Normalizing flat

          imsurfit(sflat, frameout, xorder=3, yorder=3, 
            type_output="response", function="legendre", cross_terms=no,
            xmedian=1, ymedian=1, median_perce=50., lower=3., upper=3., 
            ngrow=2, niter=1, regions="all", rows="*", columns="*", 
            border="10", sections="", circle="  ", div_min=INDEF)

          print("", >> cmkflatlog)
          print("Normalizing flat", >> cmkflatlog)
          print("Input file of imsurfit is:", sflat, >> cmkflatlog)
          print("Output file of imsurfit is:", frameout, >> cmkflatlog)

   # cleaning up

          delete(ftmpo[1], ver-, >& "dev$null")
          delete(ftmpo[2], ver-, >& "dev$null")
          delete(sflat, ver-, >& "dev$null")

          print("    <<===== cmkdnflat DONE =====>>", >> cmkflatlog)

          print("    <<===== cmkdnflat DONE =====>>")

      
end


