# IRAF script -- cmkchip.cl
#	
#   function:  to make the chip-images (1024x1024) from individual quads)
#               input: from the output of cmkimg
#    stage: NEED change
#
# programmer: sjchan (nov 97)
#	    26mar99  --	 mhoenig: added doass option (to allow for pre-assembled
#			  images)
#

procedure cmkchip(file_in, telescope, doscale)

string	file_in	  {"",prompt="@List of lists of input quadrant images",mode="ql"}
string  telescope {"WHT",prompt="Telescope to be used",mode="ql"}
bool    doscale   {yes, prompt="Scale the quadrants?", mode="ql"}
bool	doass	  {yes, prompt="Do we need to assemble quadrants?"}

struct  *filist

begin
        string  filein      # input file list of list of quad-images
        string  telescope2   # telescope to be used
        bool    doscale1     # scaling the quadrants
        string  ifile       # the final version of input file 
        string  foldin      # the input list individual quad-images
        string  fileout    # the output list of list individual chip-images
        string  cmkchiplog   # logfile
        string  templog     # dummy variable (temporary logfile)
        int     ic, icdet   # counters
        int     leni        # the length of the input file name 
        string  fout        # dummy variable
        string  foldout     # the output of individual chip-images
	bool 	doass1

   

      #  Get the rest of the parameters

        filein = file_in
        telescope2 = telescope
        doscale1   = doscale
        cmkchip = "cmkchip.log"
        templog = "cassquad.log"
	doass1 = doass

        #  Find out the suitable input option

        leni=strlen(filein)

        if (stridx(filein, "@") == 1)
           ifile = substr(filein, 2, leni)
        else
         {
           ifile = mktemp("fin")
           sections(ftmpi, option="fullname", > ifile)
         }

        if (telescope2 == "none")
           fileout = "a"//ifile  
        else
           fileout = "ta"//ifile

     # Check existence of output files

        if (access(cmkchiplog))
           delete(cmkchiplog, ver-, >& "dev$null")
        if (access(templog))
           delete(templog, ver-, >& "dev$null")
        if (access(fileout))
           delete(fileout, ver-, >& "dev$null")

     # Read the list of input list filename of quads
        ic = 0
        filist = ""
        filist = ifile   # open the file
        while (fscan(filist, foldin) != EOF)
         {
            ic += 1
            print("Fold ", ic, >> cmkchiplog)
            unlearn cassquad
	    
	    if (doass1)
	    {
            	cassquad("@"//foldin, telescope2, doscale1, doass=yes) # assemble the quads 
	    }	
	    else if (doass1==0)
	    {
            	cassquad("@"//foldin, telescope2, doscale1, doass=no) 
	    }	
            
	    if (telescope2 == "none")
               print("a"//foldin, >> fileout)
             else
               print("ta"//foldin, >> fileout)
   
            print("", >> templog)
            print("=========================================", >> templog)
            unlearn type
            type(templog, >> cmkchiplog)
          }    # this brace is from while (filist, filein)

         # close the files and cleaning up
           filist = ""   


	  print ("CMKCHIP done.")

end

