# IRAF script -- cirmos.cl
# 
# function: to mosaic a list of images in a given pattern (dithering pattern
#            or adjacent mosacing pattern) during the run.
#
#	
# programmers: sjchan 
#        history: may97   --  created(irmos.cl)
#                 july97  --  renamed to cirmos.cl for cirsi project
#                               -- add dithering pattern option
#                 oct27   --  add mosaic_display option
#                 april97 --  change the multiiplative image scaling to be
#                               applied in IMCOMBINE into an option 
#                               (default: none) -- this parameter will be used
#                 13aug98 -- add an option to let user have a chance to 
#                                 use the value (m_zero, m_scale in pset)
#		  23april99 - mhoenig: added condition to avoid crash if mosaic
#			       display fo images was not selected

procedure cirmos (listimage)

string  listimage  {"",prompt="@list of images in the dither sequence",mode="ql"}
string  disp_img   {"",prompt="@list of images to display before beginning", mode="ql"}
string  shift_fl   {"",prompt="Name of offset file",mode="ql"}
string frame_out   {"none",prompt="Name of output image", mode="ql"}
bool pattern1      {no, prompt="Big pattern (ie. mosaic rather than dither)?", mode="ql"}
bool answer        {no, prompt="Do you already have the offset file?", mode="ql"}
bool    useropt    {no, prompt="Change default IMCOMBINE parameters?"}
pset    mkmospar   {prompt="User-edited IMCOMBINE parameters"}


struct *filist
struct *clist1, *clist2

begin
        # Local variable declarations
        string  l_images     # list of image images 
        string  shiftfile    # offset file (offset w.r.t. the 1st image
        string  dispimg      # @list of image images for mosaic_display 
        string frameout      # output mosaic image
        string  framein      # input images 
        string shiftlog      # logfile
        string ind           # indicator
        string ifile, ofile  # final version of input and output list
        string cenout        # file containing center of objects
        string cen1,cen2     # dummy variables for 2 given pair frames
        string cenfile       # final output file containing the center 
                             # values of objects   
        string coordfl       # parameter for  task circenter ( Input
                             #  coordinates of objects)
        string nonint        # a jump indicator (jump to non-interactive)
        int     leni         # dummy variable
        int     icount, ic, ncount, icount2   # dummy variables (counters)
        int     isum         # dummy variables (shift counter)
        real x1, x2, y1, y2  # dummy variables (object location)
        real  xshift, yshift # the shift of objects in each pair
        real  axshi, ayshi   # average shift of objects in the frame
        real  tot_xshi,tot_yshi  # total shift of objects w.r.t. the 1st image
        real  sumxs,sumys    # dummy variables (sum shift of selected objects)
        bool  pattern        # yes (adjacent mosaic), no (dither mosaic)
        string mscale1       # Multiplicative image scaling to be applied 
                                # in IMCOMBINE (useropt == no case)
        string mzero1        # zero level scaling to be applied in IMCOMBINE
                              # (useropt == no case)
        bool    useropt1   # User option to input IMCOMBINE parameters
        string  s1, s2

       # IMCOMINBE parameters (user choose)
         string p_sigma, p_plfile, p_combine, p_reject, p_offsets, p_masktyp
         string p_scale, p_weight, p_statsec, p_expname, p_zero
         string p_rdnoise, p_gain
         real p_maskval, p_blank, p_lthresh, p_hthresh
         real p_lsigma, p_hsigma, p_pclip, p_sigscale
	 int  p_nlow, p_nhigh, p_nkeep, p_grow

        #  Get the rest of the positional parameters

        l_images=listimage
        shiftfile=shift_fl
        dispimg  = disp_img
        frameout=frame_out
        pattern = pattern1
        useropt1 = useropt

        shiftlog="cirmos.log"
        cenfile="cirmos.cen" # output file containing the center values 
                             # of objects
        ind="O"      # dummy definition
        ifile="dummy1"   # only need ifile
        ofile="dummy2"   # dummy definition
        cenout="dummy_cen" # the file containing center of objects
        cen1="dummy_cen1"
        cen2="dummy_cen2"
        coordfl="none"   # parameter for task circenter

        #IMCOMBINE parameters

        p_sigma  = mkmospar.m_sigma
        p_plfile = mkmospar.m_plfile
        p_combine = mkmospar.m_combine
        p_reject = mkmospar.m_reject
        p_masktyp = mkmospar.m_masktyp
        p_maskval = mkmospar.m_maskval
        p_blank = mkmospar.m_blank
        p_scale = mkmospar.m_scale
        p_zero = mkmospar.m_zero
        mscale1 = mkmospar.m_scale
        mzero1  = mkmospar.m_zero
        p_weight = mkmospar.m_weight
        p_statsec = mkmospar.m_statsec
        p_expname = mkmospar.m_expname
        p_lthresh = mkmospar.m_lthresh
        p_hthresh = mkmospar.m_hthresh
        p_nlow = mkmospar.m_nlow
        p_nhigh = mkmospar.m_nhigh
        p_nkeep = mkmospar.m_nkeep
        p_lsigma = mkmospar.m_lsigma
        p_hsigma = mkmospar.m_hsigma
        p_rdnoise = mkmospar.m_rdnoise
        p_gain = mkmospar.m_gain
        p_sigscale = mkmospar.m_sigscale
        p_pclip = mkmospar.m_pclip
        p_grow = mkmospar.m_grow

        # Check the existence of the files

        if (access(shiftlog))
            delete (shiftlog, ver-, >& "dev$null")
        if (access(ifile))
            delete (ifile, ver-, >& "dev$null")
        if (access(ofile))
            delete (ofile, ver-, >& "dev$null")
        if (access(cen1))
            delete (cen1, ver-, >& "dev$null")
        if (access(cen2))
            delete (cen2, ver-, >& "dev$null")
        if (access(cenfile))
            delete (cenfile, ver-, >& "dev$null")
        if (access(frameout))
            imdelete (frameout, ver-, >& "dev$null")



        #  Find out the suitable input option

	   _finout(l_images, ind, ifile, ofile)

        # Make a jump to non-interactive mode (providing an offset file)

          if (answer) 
             goto nonint

          # For interactive mode
          # read the file 'ifile' containing the names of files

          ncount=0
          icount=0; ic=0
          icount2=0
          tot_xshi=0.0
          tot_yshi=0.0

        if (access(shiftfile))   # output offset file for interactive mode
            delete (shiftfile, ver-, >& "dev$null")

         # Display a list of images in a single frame buffer and marks the 
         #    objects (just for display purpose)
          if (dispimg!="") mosaic_display(dispimg)

         # Find out how many images in the pattern
          filist = ""; filist = ifile 
          while (fscan(filist, framein) !=EOF)
            ncount += 1
      
          filist = ""  # close the file
          print("The total images in the pattern: ",ncount, >> shiftlog)
          print("==========================================", >> shiftlog)

          filist = ""; filist = ifile  
          while (fscan(filist, framein) != EOF)
          {
           icount += 1
           ic = icount -1

              if (icount == 1)
               {
                  print("")
                  print ("Please press 'q' to continue.")
		  # print("")

                  unlearn tvmark
                  tvmark (1, "", mark="circle", radii="3.0", color= 204,
                      interactive=yes)
                  print("")
                  # print("=========================================")
                  print("Pair: 1 & 2")
                  print("")
                  print("Make sure you mark the objects in the same order!")
                  print("")
                  print("Image 1: ", framein)
                  # print("")
               }
              else
                  print("Image "//str(icount)//": "//framein)

                circenter(framein,cenout,coordfl)

              if (icount == 1)
              {
                  rename(cenout, cen1, field="all")        
                  print("ic,icount: ",ic,icount, >> shiftlog)
                  print("tot_xshi,tot_yshi :",tot_xshi,tot_yshi, >> shiftlog)
                  print("", >> shiftlog)
                  print(tot_xshi,tot_yshi, >> shiftfile) #put them into outfile

                  print(framein, >> cenfile) #make a file containing centers
              }
              else  
              {
               if (access(cen2))
                  delete(cen2, ver-, >& "dev$null")

                rename(cenout, cen2, field="all")

             #  Now calculate the average shift of each pair frames     
                sumxs=0.0
                sumys=0.0
                isum=0

               print("============================================", >> shiftlog)
               print("ic,icount: ", ic,icount, >> shiftlog)
               print(framein, >> cenfile) #make a file containing centers

                clist1=cen1; clist2=cen2   
                while((fscan(clist1,x1,y1) !=EOF) && (fscan(clist2,x2,y2) !=EOF))
                 {
                   xshift= x1 - x2
                   yshift= y1 - y2
                   sumxs += xshift
                   sumys += yshift
                   isum += 1


              # put the shift information into the logfile and centefile
                   print("(x1,y1),(x2,y2),(xs,ys):",x1,y1,x2,y2,xshift,yshift,
                          >> shiftlog)
                   print(x1,y1,x2,y2,xshift,yshift, >> cenfile) 

                 } # this bracket is for while loop (read cen1, cen2)

                print("====================================", >> cenfile) 
                axshi= sumxs/isum
                ayshi= sumys/isum
           
                print("(axshi,ayshi)", axshi,ayshi, >> shiftlog)
                print("", >> shiftlog)

                clist1="" # close the files
                clist2=""

            #  total shifts w.r.t. the first image
               tot_xshi += axshi
               tot_yshi += ayshi     
      
               print("(tot_xshi,tot_yshi)",tot_xshi,tot_yshi, >> shiftlog)
               print("", >> shiftlog)
               print(tot_xshi,tot_yshi, >> shiftfile)
                   
            #  prepare the status for next pairs (1-2,2-3,3-4,...)
               if (access(cenout))
                  delete(cenout, ver-, >& "dev$null")
               if (access(cen1))
                  delete(cen1,ver-, >& "dev$null")

            # this action is for using the current frame one more time
            #    if the pattern is "BIG" (ie: the mark objects are only in
            #                               the given pair frames)

               if (icount != ncount)
               {
                ic -= 1
                icount2=icount+1
                 # print("==============================================")
                 print("Pair: "//icount//" & "//icount2)
                 print("Image "//str(icount)//": "//framein)

                if (pattern)
                  {   # big pattern option
                    print("Make sure to mark the same objects and same order in the given frames")
                    print("")
                    circenter(framein,cenout,coordfl)
                    rename(cenout,cen1,field="all")
                  }
                 else
                  {
                 # for small pattern, the selected objects are in all the 
                 #   given frames
                    print("")
                    copy(cen2, cen1, ver-) 
                  }
                print(framein, >> cenfile) # make a file containing centers
               }
           }  # this bracket is for if loop (icount > 1)

         }  # this bracket is for while loop (read the frame)
         filist = "" #close the file

         nonint:    # from the jump goto nonint (for non-interactively case)
               
         if (frameout != "none") 
         {
           if (!useropt1)
              {
                unlearn imcombine
                filist = ""; filist = ifile
                while( fscan(filist, s1) != EOF)
                  {
                    imgets(s1, param= "BPM", >& 'dev$null')
                     s2 = imgets.value
                       goto lab
                   }

                lab:
                filist = ""

                if (s2 != "0") #keyword BPM in the header
                    imcombine.masktype = "goodvalue"
                 else
                    imcombine.masktype = "none"

                imcombine("@"//ifile, frameout, plfile="",sigma="", 
                  logfile=shiftlog,
                  combine="median", reject="none", project=no, outtype="real", 
                  offsets=shiftfile, maskvalue=0., blank=0., 
                  scale=mscale1, zero=mzero1, weight="none", statsec="", 
                  expname="", lthreshold=INDEF, hthreshold=INDEF,
                  nlow=1, nhigh=1, nkeep=1, mclip=yes, lsigma=3., hsigma=3., 
                  rdnoise="0.",gain="1.", snoise="0.", sigscale=0.1, 
                  pclip=-0.5, grow=0)
            }#this brace is from if-block (useropt1 == no)
          else
           { #pset option
              imcombine("@"//ifile, frameout, sigma=p_sigma, plfile=p_plfile, 
              combine=p_combine,reject=p_reject, project=no, outtype = "real",
              offsets=shiftfile, masktype=p_masktyp, maskvalue=p_maskval, 
              blank=p_blank, scale=p_scale, zero=p_zero, weight=p_weight, 
              statsec=p_statsec, expname=p_expname, lthresh=p_lthresh, 
              hthresh=p_hthresh, nlow=p_nlow, nhigh=p_nhigh, nkeep=p_nkeep, 
              mclip+, lsigma=p_lsigma, hsigma=p_hsigma, rdnoise=p_rdnoise, 
              gain=p_gain, sigscale=p_sigscale, pclip=p_pclip, grow=p_grow, 
              logfile=shiftlog)

           }#this brace if from if-else-block (useropt1 == yes)

         }#this brace is from if-blocak (framout != "none")


         # Clearing up
         # close the files

         delete(ifile//","//ofile, ver-, >& "dev$null")
         # print("")
         print("Remember to rename cirmos.cen ...")
         print("")
         print("CIRMOS done.")

end


