# IRAF script -- circenter.cl
#
#   function: to find the center of objects in the given frame
#
# progrmmer : sjchan 
#
#  history:  may 97:  orginal verion of ircenter.cl
#            july 97: ccenter.cl
#            jan 98:  rename to circenter.cl
#

procedure circenter(frame_in,cen_file,coord_fl)

string frame_in   {"",prompt="Input the image", mode="ql"}
string cen_file   {"",prompt="Output file containing the center of objects",mode="ql"}
string coord_fl {"none",prompt="Input coordinates of objects (non-inteactively)", mode="ql"}
struct *fclist

begin
      # Local variable declarations
        string framein,cenfile,coordfl
        string tempcntr,tcoo
        string pdout1
        real xint, yint

      # Get the reset of the parameters
        framein = frame_in
        cenfile = cen_file
        coordfl = coord_fl
        tempcntr = "cntr_out"

        if (access(tempcntr))
          delete(tempcntr, ver-, >& "dev$null") 
        if (access(cenfile))
          delete(cenfile, ver-, >& "dev$null")

      #  Find the accuate centers of objects in the given frame interactively
        if (coordfl == "none")
         {
          display (framein, 2, bpmask="BPM", bpdisplay="none", 
             bpcolors="red", overlay="", ocolors="green", erase=yes, 
             border_erase=no, select_frame=yes, repeat=no,
             fill=yes, zscale=yes, contrast=0.25, zrange=yes, zmask="", 
             nsample=1000, xcenter=0.5, ycenter=0.5, xsize=1., ysize=1., 
             xmag=1., ymag=1., order=0, ztrans="linear", lutfile="")

           pdout1=mktemp("tdma")
  
           # Make a coords file
            print("")
	    print("TVMARK is now running in interactive mode.")
	    print("Type 'c' to mark the reference objects,") 
	    print("then type 'q' when done.")
            print("")

            tvmark (2, "", logfile=pdout1, autolog=yes, outimage="", 
                    deletions="", commands="", mark="circle", radii="3.0",
                    lengths="0", font="raster", color=204, label=no,
                    number=no, nxoffset=0, nyoffset=0, pointsize=3, 
                    txsize=1, tolerance=1.5, interactive=yes)

            tcoo=pdout1
         }
        else
         {  # For non-interactive mode
           
            tcoo=coordfl
         }

       # Estimate the center of the object in the given frame
         fclist=tcoo
         while (fscan(fclist, xint, yint) != EOF)
           imcntr (framein, xint, yint, cboxsize=20, >> tempcntr)

         fclist=""   # close the file
         fields (tempcntr,"3,5", lines="1-9999", quit_if_miss=no, 
               print_file_n=no, >> cenfile)
         
       # Clearing up         
         delete(tempcntr,ver-, >& "dev$null")
          if (coordfl == "none")
              delete(pdout1,ver-, >& "dev$null")

end

