# IRAF script -- cflatcor
#   function:  Flat fielding correction (to divide the program objects
#                   by normflat (nflat*) 
#	
# programmers: sjchan 
#     history: (january 1997, Oct1997) - created
#                 17june98 - modified (renamed from ccflatcor to cflatcor)
#                            comment all the variables
#

procedure cflatcor(frame_in,file_flat)

string	frame_in    {"",prompt="(@List of / *.fits) Input image(s)",mode="ql"}
string  file_flat   {"",prompt="Name of normflat ", mode="ql"}
struct  *filist

begin
        # Local variable declarations
        string  ftmpi      #i string of filename of list of input images
        string   ifile     #i final version of input file
        string   ofile     #o final version of output file
        string  fflat      #i filename of normalized flat
        string  flatcorlog #o o logfile
        string  ind        # indicator

        #  Get the rest of the positional parameters

        ftmpi=frame_in
        fflat=file_flat
        flatcorlog="cflatcor.log"
        ifile=mktemp("cfcorifl")
        ofile=mktemp("cfcorofl")
        ind="F"    # dummy definition

     #Check the existence of the logfile and flat frames
        if (!access(fflat))
          {
            print(fflat, " not found!")
            print("cflatcor is going to be terminated!")
            bye
           }
        if (access(flatcorlog))
             delete(flatcorlog, ver-, >& "dev$null")
        if (access(ifile))
             delete(ifile, ver-, >& "dev$null")
        if (access(ofile))
             delete(ofile, ver-, >& "dev$null")
 
     
     #  Find out the suitable input option

        _finout(ftmpi, ind, ifile, ofile)

     #  flat fielding correction

        imarith(operand1="@"//ifile, op="/", operand2=fflat,
            result="@"//ofile, title="", divzero=1., hparams="", 
            pixtype="real", calctype="real", verbose=yes, 
            noact=no, >> flatcorlog) 

        # updated the titlte in the image header and the noise-cor flag
        #  to the header
 
        _irheadup("@"//ofile,ind)

        # Clearing up

        delete(ofile, ver-, >& "dev$null")
        delete(ifile, ver-, >& "dev$null")

         
        print("CFLATCOR done.")


end

