# IRAF script -- cstripe
#                
#    function: to correct the "strip" noise
#	
#    stage: 
# programmer: sjchan 
#             26jan98: created  -- option (B/C/R)
#             9june98: modified -- add options to use Mike Irwin's drift
#                                   directly (MB/MR/M)
#                                   driver of drift.e is _cdrift.cl
#                                   dfault action: MB (if wrong input)
#              6aug98: modified -- using modified "drift" called "fdrift" 
#                                   rgm
#                                  driver of fdrift is _cfdrift.cl
#                                    dfault action: MB (if wrong input)
#           
##

procedure cdestripe(frame_in, index)

string frame_in   {"", prompt="(@List of or *.fits) input frame", mode="ql"}
string index {"MB", prompt="Destriping option (MB or B/C/R)", mode="ql"}

struct *filist, *folist

begin

     string ftmpi          #ir  input list string
     string framein        #ir  input image in the input list
     string frameout       #ir  output corrected frame
     string dripindex      #ir  Destriping index
     int    naxis1        # the diminsion of the axis of the image
     string tmedtxr        # the temporary text file to store Row median
     string tmedimgr       # the temporary image row median 
     string tmedimgr2      # dummpy variable
     string tmedimgr3
     string tmedimgr4
     string tmedtxc        # the temporary text file to store column median
     string tmedimgc       # the temporary image column median
     string tframe2c       # the temporary transpose image of framein
     string tcorrimg        # the image of R-median x C-median
     string cstripelog      # logfile
     string  ss2
     string ind              # indicator for destriping
     string ifile           # final version of input list
     string ofile           # final version of output list
     int    ncc             # dummy counter


     # Get the rest of the parameter
     ftmpi      = frame_in
     dripindex  = index
     tmedtxr = "tmedtxr.txt"
     tmedimgr = "tmedimgr.fits"; tmedimgr4 = "tmedimgr4.fits"
     tmedimgr2 = "tmedimgr2.fits"; tmedimgr3 = "tmedimgr3.fits"
     tframe2c = "tframe2c.fits"
     tmedtxc = "tmedtxc.txt"
     tmedimgc = "tmedimgc.fits"
     tcorrimg  = "tcorrimg.fits"
     cstripelog = "cstripe.log"
     ind = "N"
     ifile = mktemp("cstifl")
     ofile = mktemp("cstofl")
     naxis1 = 512   # default

     cache imgets     # need this action due to a bug in imgets

    # Check the existence global files
     if (access(cstripelog))
          delete(cstripelog, ver-, >& "dev$null")
     if (access(ifile))
          delete(ifile, ver-, >& "dev$null")
     if (access(ofile))
          delete(ofile, ver-, >& "dev$null")
     if (access(tmedimgr)) 
          imdelete(tmedimgr, ver-, >& "dev$null")
     if (access(tmedimgr2)) 
          imdelete(tmedimgr2, ver-, >& "dev$null")
     if (access(tmedimgr3)) 
          imdelete(tmedimgr3, ver-, >& "dev$null")
     if (access(tmedtxr))
            delete(tmedtxr, ver-, >& "dev$null")
     if (access(tmedtxc))
            delete(tmedtxc, ver-, >& "dev$null")

    # Find out the suitable input option
     _finout(ftmpi, ind, ifile, ofile)

     print("", >> cstripelog)
     print("Destriping index: ", dripindex, >> cstripelog)
     print("", >> cstripelog)

   # Read the input image from the list and perform the destriping process
     filist = ""; filist = ifile     # open the files
     folist = ""; folist = ofile  
     ncc = 0
     while( (fscan(filist,framein) != EOF) && (fscan(folist,frameout) != EOF) )
       {
         # get the naxis value from the header
           ncc += 1
           if (ncc == 1) 
             {
               imgets(framein, para="i_naxis1")
               naxis1 = int(imgets.value)
             }
         # check the existence files
         if (access(frameout))
             imdelete(frameout, ver-, >& "dev$null")

         print("", >> cstripelog)
         print("")
         print("Image: ", framein, >> cstripelog)
         print("Output Image: ", frameout, >> cstripelog)
         print(framein, " is in processing for noise-correction")
         print("", >> cstripelog)
    
         if (dripindex == "MB")
           { # using Mike Irwin's fdrift.e to do the noise correction
             _cfdrift(framein, frameout)
             goto lab
           } # this brace is from if block (dripindex == MB)
         else if ((dripindex == "B")||(dripindex == "R") || (dripindex == "C"))
           { # using iraf tasks to do the noise correction based on
             # Mike Irwin's old version drift.e

            if (access(tmedimgr4)) 
               imdelete(tmedimgr4, ver-, >& "dev$null")
            if (access(tframe2c))
               imdelete(tframe2c, ver-, >& "dev$null")
            if (access(tmedimgc))
               imdelete(tmedimgc, ver-, >& "dev$null")
            if (access(tcorrimg))
               imdelete(tcorrimg, ver-, >& "dev$null")

        #    # Calculate the R/C median 
             if ((dripindex == "R") || (dripindex == "B"))
               {# Calculate the row median, tmedimgr: 1-dimensional naxis1-vector 
                 _rcmedian(framein, naxis1, tmedtxr, tmedimgr)
                 delete(tmedtxr, ver-, >& "dev$null")
                 ss2 = _rcmedian.flag
                 if (ss2 == "B")
                    bye

        # change tmedimgr into a 2-d image in which each column is the same
                unlearn imstack
                imstack (tmedimgr,tmedimgr2)
                unlearn imtranspose
                imtranspose (tmedimgr2, tmedimgr3, len_blk=naxis1)
                unlearn blkrep
                blkrep (tmedimgr3, tmedimgr4, naxis1, 1)
                imdelete(tmedimgr, ver-, >& "dev$null")
                imdelete(tmedimgr2, ver-, >& "dev$null")
                imdelete(tmedimgr3, ver-, >& "dev$null")
               }  # this brace is from if block (dripindex = R or B)

          if ((dripindex == "C") || (dripindex == "B")) #caculate column median
             { # prepare to use 'imexpr' with its median function to calculate
               # the median the row vector; tmedimgc - 1-dim image
                 imtranspose (framein, tframe2c, len_blk=naxis1)  
                 _rcmedian(tframe2c, naxis1, tmedtxc, tmedimgc)
                 delete(tmedtxc, ver-, >& "dev$null")
                 ss2 = _rcmedian.flag
                 if (ss2 == "B")
                    bye
             }  # this brace is from if block (dripindex = C or B)

           # Do the correction
           # Prepare the correction image: tcorrimg
            if (dripindex == "B")  # tcorrimag is a (naxis1 x naxis1) image
              {  
                unlearn imarith
                imarith(operand1=tmedimgr4, op="*", operand2=tmedimgc,
                 result=tcorrimg, pixtype="real", calctype="real", verbose=yes,
                 >> cstripelog)
               }
             else if (dripindex == "R") #tcorrimag is a (naxis1 x naxis1) image
               imcopy(tmedimgr4, tcorrimg, verbose=yes, >> cstripelog)
             else if (dripindex == "C")  # tcorrimag is a 1-dim (naxis1) image
                imcopy(tmedimgc, tcorrimg, verbose=yes, >> cstripelog)

            # Perform the correction
                unlearn imarith
                imarith(operand1=framein, op="*", operand2=tcorrimg,
                result=frameout, pixtype="real", calctype="real", verbose=yes, 
                 >> cstripelog)    
       
          } # this brace is from if-else block (dripindex == B,C,R)
       else
          { #wrong input --> default option 
             print("Wrong input index: ", dripindex)
             print("Wrong input index: ", dripindex, >> cstripelog)
             dripindex = "MB"
             print("Now we are using the default index: ", dripindex)
             print("Now we are using the default index: ", dripindex, >> cstripelog)
             _cfdrift(framein, frameout) 
          }

       lab:   # jump out from if block (dripindex = MB)
              print("", >> cstripelog)
              print("=========================================", >> cstripelog)

       # Update the header
            _irheadup(frameout, ind)

       }  # this brace is from while block (filist = ifile; folist = ofile)

         filist = ""      # close the files
         folist = ""

       # Cleaning up
          delete(ifile//","//ofile, ver-, >& "dev$null")
          #imdelete(tcorrimg, ver-, >& "dev$null")
          if (access(tmedimgr))
             imdelete(tmedimgr, ver-, >& "dev$null")
          if (access(tmedimgc))
              imdelete(tmedimgc, ver-, >& "dev$null")

          print(" <<=========== CSTRIPE DONE ==============>>")
          beep; beep; beep

end



