# IRAF script -- cassquad.cl
#
#   function: to assemble four quadrants into one
#
#
# programmer: sjchan 
#
#  history: oct97   --   original name:  cirass.cl 
#           23jan98 --   change into cassquad.cl
#           11feb98 --   add an option: to transpose images into a right
#                          orientation
#           23feb98 --   fixed the bug in order to use wild cards (*) input
#                         tofile = ofile ---> tofile = mktemp("caqtofl")
#                        delete the scaled images after the assembled images
#                         created. 
#                        quick check the input list (total number = 4*(+ve int)
#           11june98 --  make an option to turn off scaling the quads
#                        (default: doscale == yes)
#	    26mar99  --	 mhoenig: added doass option (to allow for pre-assembled
#			  images)
#	    22april99 -- mhoenig: finalized alterations for pre-assembled images
#

procedure cassquad(frame_list, telescope, doscale)

string	frame_list {"",prompt="Input quadrant images (@list or *.fits)",mode="ql"}
string  telescope  {"WHT", prompt="Telescope to be used (WHT|INT|none)", mode="ql"}
bool    doscale    {yes, prompt="Scale the quadrants?", mode="ql"}
bool	doass	   {yes, prompt="Assemble the quadrants?"}

struct *filist, *folist
struct *filistm, *filista

begin
        string  ftmpi          #ir list of quadrant image. 
        string  telescope1     #ir telescope to be used
        bool    doscale1       #ir scaling the quadrants 
        string  framein        # input quadrant
        string  frameout       # output frame
        string  tframein       # scaled input frame
        string  ifile          # final list of final input list for assembling
        string  ofile          # the output list of assembled images
        string  cassquadlog      # logfile
        string  sec[4]         # the sections of each quadrant
        string  tempimg        # a temporary empty image 
        string  indc           # indicator for file manager task
        int     itemp, itemp4  # dummy variables
        int     icount, icount2  # dummy counters
        int     len            # length of string ftmpi
        string  tofile         # input file for CHIPTRANS
        string  templog        # temporary logfile (chiptrans.log)
        string  medfl          # temporary file containing median
        string  avefl          # temporary file containing average of median
        int     icc            # quadrant counter
        real    med            # median of each quad-image
        real    ave            # average of median of each 4-quadrant images
        real    sum            # sum of median of each 4-quadrant images
        real    scale          # the scale factor (ave/med)
        string  ss1            # total number of files in ifile in string
        int     iss1           # total number of files in ifile in integer
        int     ich            # dummy variable
	bool 	doass1

        #  Get the rest of the parameters

        ftmpi=frame_list
        telescope1 = telescope
        doscale1   = doscale
        cassquadlog = "cassquad.log"
        templog = "chiptrans.log"
        indc="A"       # option for assemble 4 quads.
        ifile=mktemp("caqifl")
        ofile=mktemp("caqofl")
        medfl=mktemp("caqmfl")
        avefl=mktemp("caqafl")

        sec[1] = "[513:1024,1:512]"
        sec[2] = "[1:512,1:512]"
        sec[3] = "[1:512,513:1024]"
        sec[4] = "[513:1024, 513:1024]"
        tempimg = "zeroimg.fits"
        ss1 = "1"
	doass1 = doass

        # Load the task
        if (!defpac("noao"))
          {
           noao
           artdata
           keep
          }
         if (access(ifile))
             delete(ifile, ver-, >& "dev$null")
         if (access(ofile))
             delete(ofile, ver-, >& "dev$null")
         if (access(cassquadlog))
             delete(cassquadlog, ver-, >& "dev$null")
         if (access(tempimg))
              imdelete(tempimg, ver-, >& "dev$null")


	if (doass1)
	{
		
	#  Find out the suitable input option
           
	   unlearn _finout
           _finout(ftmpi, indc, ifile, ofile)
          
        #  Check the total number of files in the input list
           count(ifile) | scan(ss1)
           iss1 = int(ss1)
           ich = mod(iss1, 4)
           if (ich != 0)
              {
                print("Total number of input files: ", iss1)
                print("Wrong input: input file number should be equal to 4 * (+ve integer) !")
                bye
              } 

        #  Create an empty (constant value of zero) two dimensional image
        #   with the size 1024 X 1024

           unlearn mkpattern
           mkpattern (tempimg, pattern="constant", option="replace", 
             v1=0., ndim=2, ncols=1024, nlines=1024)
           

              # Read the input list and caculate the median
                filist = "" 
                filist = ifile   # open the input files to calculate the median
                                 # of each image
                while (fscan(filist, framein) != EOF)
                  {
                     if (doscale1)
                        imstatistics(framein, fields="midpt", binwidth=1.0e-4, 
                         format=no, >> medfl)
                     else
                        print("1.0", >> medfl) #dummy action for non-scaling

                  }  # this brace is from while block (filist, framein)
                filist = ""   # close the file

                # Calculate the average of the median of each 4-quadrant images
                icc = 0; sum = 0.0
                filistm = ""; filistm = medfl
                while (fscan(filistm, med) != EOF)
                  {
                     icc += 1
                     if (doscale1)
                       {
                         if (icc > 4) # reset icc to zero and sum to zero
                           {
                             icc = 1
                             sum = 0
                           }
                         if (icc <= 4)
                           {
                             sum += med
                             if (icc == 4)
                               {
                                 ave = sum/icc
                                 print(ave, >> avefl)# store the average into
                                                     # a file
                                }
                            }  # this brace is from if block (icc <=4)
                         } # this brace is from if-block (doscale)
                        else
                          print("1.0", >> avefl) #dummy action for non-scaling
 
                   } # this brace is from while block (filistm, med)

       # prepare an output file containing assembled image names
        # input file list for task chiptrans
             len = strlen(ftmpi)
             if (stridx(ftmpi, "@") == 1)
               {
                 tofile = substr(ftmpi, 2, len)
                 tofile = "a"//tofile
                 if (access(tofile))
                    delete(tofile, ver-, >& "dev$null")
               }
             else 
               {
                 tofile = mktemp("caqtofl")
               }

         icount = 0; icount2 = 0
          filist = ""; folist = ""
          filist = ifile; folist = ofile    # open the files
          filistm = ""; filistm = medfl
          filista = ""; filista = avefl
          while ((fscan(filist,framein) !=EOF) && (fscan(filistm, med) !=EOF) )
            {
             print("", >> cassquadlog)
             print("============================================", >> cassquadlog)
             print("", >> cassquadlog)
             print("Image: ", framein, >> cassquadlog)
             
             if (doscale1)
                print("Its median: ", med, >> cassquadlog)
     
             tframein = "w"//framein
             if (access(tframein))
                delete(tframein, ver-, >& "dev$null")

             icount += 1
             itemp = mod(icount, 4)
             if (itemp == 1) 
              {
               while((fscan(folist, frameout)!=EOF)&&(fscan(filista,ave)!=EOF))
                  {
                   if (access(frameout))
                      imdelete(frameout, ver-, >& "dev$null")
       
                   print(frameout, >> tofile)
                   icount2 += 1

                   if (doscale1) #scaling option only
                     {
                       print("ave of median of 4-quadrants: ", ave, 
                               >> cassquadlog)
                    #   print("ave: ", ave)
                       scale = ave/med
                       print("scale factor: ", scale, >> cassquadlog)
                     #  print("scale: ", scale)
                       imarith(operand1=framein, op="*", operand2=scale,
                         result=tframein, pixtype="real", calctype="real",
                         verbose=yes, >> cassquadlog)

                      } #this brace is from if-block (doscale)
                   else #non-scaling option
                     {
                       scale = 1.0
                       print("This is a non-scaling quad option: ",>> cassquadlog)
                       imcopy(framein, tframein, ver+, >> cassquadlog)
                     }

                   imcopy(tempimg, frameout, ver+, >> cassquadlog)
                   mkheader(frameout, framein, append=no, verbose=no)
                   imcopy(tframein//sec[2], frameout//sec[1], ver+, >> cassquadlog)
                   break    # exit the while inner loop 
                  } # this brace is from while inner loop (frameout, ave)
                } # this brace is if block (itemp = 1)

              if ((itemp == 2) || (itemp == 3) || (itemp == 0))
                {
                   if (doscale1) #scaling option only
                     {
                        scale = ave/med
                        print("scale factor: ", scale, >> cassquadlog)
                      #  print("scale: ", scale)
                        imarith(operand1=framein, op="*", operand2=scale,
                          result=tframein, pixtype="real", calctype="real",
                          verbose=yes, >> cassquadlog)
                     } #this brace is from if-block(doscale)
                   else
                     {  #non-scaling option only
                      print("This is non-scaling quad option:", >> cassquadlog)
                      imcopy(framein, tframein, ver+, >> cassquadlog)
                        scale = 1.0  #non-scaling option
                     } 
                } # this brace is from if-block (itemp==2,3,0)

              if (itemp == 2)
               imcopy(tframein//sec[2], frameout//sec[2], ver+, >> cassquadlog)

              if (itemp == 3)
               imcopy(tframein//sec[2], frameout//sec[3], ver+, >> cassquadlog)

              if (itemp == 0)
               {
               imcopy(tframein//sec[2], frameout//sec[4], ver+, >> cassquadlog)
                 itemp4 = itemp + 4
               }  # this brace is from if block (itemp = 0)

               # delete the scaled images
                imdelete(tframein, ver-, >& "dev$null")
            }  # this brace is from while outer loop
          
              filist = ""; folist = ""   # close the files
              filistm = ""; filista = ""

              if (access(tempimg))
                imdelete(tempimg, ver-, >& "dev$null")
		

	}   # this is from "if (doass1)"
	
	
        else if (doass1==0)
	{
	
	if (stridx(ftmpi, "@") == 1)
           ifile = substr(ftmpi, 2, strlen(ftmpi))
        else
         {
           ifile = mktemp("fin")
           sections(ftmpi, option="fullname", > ifile)
         }
	 
	 # Now here comes the key line! If the data is already assembled, then
	 # the output file ready to go on to chiptrans, tofile, is the same as
	 # ifile (the name of the list of input images).
	 # All I needed to add above was a few lines to parse the original input
	 # files parameter, ftmpi, to allow for an @list (I got the method
	 # straight out of _finout, which would only get confused trying to get
	 # rid of the q? bit when there is none in pre-assembled images).
	 # cmkchip can then handle the assembled images as before (it in turn
	 # calls _finout to add a "t" to the filenames).
	 #
	 # 21-04-99: Needed to add subsequent bit for naming tofile (pasted from
	 # above), and changed "tofile = ifile" into a copy command.
	 
         len = strlen(ftmpi)
         if (stridx(ftmpi, "@") == 1)
            {
            tofile = substr(ftmpi, 2, len)
            tofile = "a"//tofile
            if (access(tofile)) delete(tofile, ver-, >& "dev$null")
            }
         else 
            {
            tofile = mktemp("caqtofl")
            }

	 copy (ifile, tofile, ver-, >& "dev$null")
	 
	}

           # transpose each image to a right orientation

             if ((telescope1 == "WHT") || (telescope1 == "INT"))
               {
                unlearn chiptrans
                chiptrans("@"//tofile, telescope1)

                print("", >> cassquadlog)
                print("========================================", >> cassquadlog)
                type (templog, >> cassquadlog)
               }
           # cleaning up
             delete(ifile, ver-, >& "dev$null")
             delete(ofile, ver-, >& "dev$null")

             if (stridx(ftmpi, "@") != 1)
              {
               delete(tofile, ver-, >& "dev$null")
               delete("t"//tofile, ver-, >& "dev$null")
              }
            delete(medfl, ver-, >& "dev$null")
            delete(avefl, ver-, >& "dev$null")

             # print ("")
	     print ("CASSQUAD done.")

end




