# IRAF script -- _mkndrlist.cl
#	
#   this is a sub file management task which is a HIDDEN task.
#    user cannot use it in the front end.
#   function:  to divide a list of finput iles into few (total_folds) sublists
#                 of files which will be in a file (inlist)
#              to make few lists of files which will be in a file (outlist)
#
# programmer: sjchan (
#        history: jan98 -- created
#                26june98 -- add a function (subtask) in order to seperate
#                             the path name is the list
#                15july98 -- combine the function of _mkndrlist and _mknout
#        
#

procedure _mkndrlist(file_in, tndr, cfold, tquad, ran1, ran2, ndr_list, out_list)

string	file_in   {"",prompt="List of Input images",mode="ql"}
int     tndr  {min=1, prompt="Total number of NDR for a fixed-pos obs",mode="ql"}
string  cfold   {"01", prompt="Current fold number (with 0 before 1-9)", mode="ql"}
int     tquad  {16, prompt="Total number of quadrants", mode="ql"}
int     ran1   {1, prompt="Lower value of output RC pair", mode="ql"}
int     ran2   {4, prompt="Upper value of output RC pair", mode="ql"}
string  ndr_list {"", prompt="File contain input list per fold", mode="ql"}
string  out_list {"", prompt="File contain output list per fold", mode="ql"}

string  check    {"", prompt="Check file flag (G/B)"}
struct  *filist


begin
        string  filein      # input file list
        int     tndr1       # total number of ndrs for a fixed-pos observation
        string  cfold1      # current fold number
        int     tquad1      # total quadrants
        int     rc1, rc2    # lower and upper range of RC pair
        int     tmpndr[2]   # dummy variable for rc1, rc2
        string  ndrlist     # a file containing ndr input fileanmes per fold
        string  outlist     # a file containing ndr output filenames per fold
        string  ilist       # list of input files in #th ndr
        string  ilisto      # a prefix for ilist file
        string  olist       # list of output files in #th ndr
        string  olistt      # temporary prefix of list of output files in
                               #th ndr
        string  olisto      # a prefix for olist file
        string  framein     # input frame with full path name
        string  framein2    # input frame without full path name
        string  temphead    # the prefix of an image name
        string  temptail    # the subfix(extension) of an image name
        string  sic[2]      # dummy counters in string with prefix "0" in (1-9)
        string  foldtail    # dummy variable
        string  check1      # check file flag
        int     icounter    # counter
        int     ndrseq     # total sequence number in one ndr (= tot_quad)
        int     ic, ic2     # dummy counters
        int     len         # the total length of an input filename
        int     lentemp     # the location of the last '_" in the filename
        int     lentemp2    # the location of the last "." in the filename
        string  sruno       # running number (in string)
        int     locrun      # the run number in integer
        int     ndig        # the number of digit in integer
        string  s1
        string  realhead    # the prehead of image (without pathname)

      #  Get the rest of the parameters

        filein=file_in
        tndr1=tndr
        cfold1 = cfold
        tquad1 = tquad
        rc1    = ran1
        rc2    = ran2
        ndrlist=ndr_list
        outlist = out_list
        ilisto = "ndr"
        olisto = "rc"
        foldtail="_"//cfold1//"p"
        temphead = ""
        temptail = ""
        sruno = "0000"
        locrun = 0
        ndig = 4
        olist = ""
        olistt = ""
        realhead = ""

        if (access(ndrlist))
          delete(ndrlist, ver-, >& "dev$null")
        if (access(outlist))
          delete(outlist, ver-, >& "dev$null")

        # find out the total number of input files in the list
        count(filein) | scan(s1)
        icounter = int(s1)

        # find out the total seq number in one ndr
        ndrseq = icounter/2     # total quads 
        
	if (ndrseq != tquad1) 
          { 
            print("Sorry - file incomplete!")
            check1 = "B"
            check = check1
            bye
          }
         else
           check1 = "G"

        filist = ""; filist = filein   # open the file

       # make ndrlist files

	 ic = 0
         tmpndr[1] = rc1; tmpndr[2] = rc2
	 
         for (k=1; k <= icounter; k += ndrseq)
          {  
            ic += 1
            _sdigit(tmpndr[ic], 2)
            sic[ic] = _sdigit.value
	    
            ilist = ilisto//sic[ic]//foldtail # make a ndr list input filenames
            
            if (ic == 2)
                {
                   olistt = olisto//sic[2]//sic[1]//foldtail 
                               # make a ndr list output filenames (fixed name)
                                # fixed substring, temporary only
                }

               ic2 = 0
               while (fscan(filist,framein) !=EOF)
                {
                  ic2 += 1
                  if (ic2 == 1)
                    {
                      imgets(framein, param="nrun")
                      sruno = imgets.value
                      if ((sruno == "") || (sruno == "0") || (sruno == "/"))
                        { # try to get the running number from filename
                           _locrnonew(framein)
                           locrun = int(_locrnonew.srunno)
                           _sdigit(locrun, ndig)
                           sruno = _sdigit.value
                        }

                if (ic == 2)
                  {
                   olist="r"//sruno//"_"//olistt #(ndr input list name with nrun)
                    if (access(olist))
                       delete(olist, ver-, >& "dev$null")
                   } #this brace is from if block (ic == 2)

                   ilist="r"//sruno//"_"//ilist #ndr output list name with nrun

                    if (access(ilist))
                      delete(ilist, ver-, >& "dev$null")

                    } # this brace is from (if block ic2 == 1)

                  print(framein, >> ilist)   # make an input ndr list
		  
        # add this option on 26june98
        # to seperate the pathname from the full image name with pathname
                   _sepdir(framein)
                   framein2 = _sepdir.fname

        # find out the location of the last "_" in the given filename
                  len = strlen(framein2)
                  _locate(framein2, "_")
                   lentemp = _locate.value

        # make the prehead from char#1 to char#(lentemp)
                     temphead = substr(framein2, 1, lentemp)

         # find out the location of the 1st last "." in the given filename
         #   the location of the last "." in framein2 (.fits)
                   _locate(framein2, ".")
                   lentemp2 = _locate.value
                   temptail = substr(framein2, lentemp2, len)


         # make the output image names and put them into a given file 
                   if (ic == 2)
                      print(temphead//"rc"//sic[2]//sic[1]//foldtail//temptail, >> olist)

         
        # check whether a "complete" is finished
                   if (ic2 == ndrseq)
                         break     # leave the ndr to create another file
                }  # this brace is from while ndr

        # collect the input and output list by ndrlist and outlist

	      print (ilist, >> ndrlist)

              if (ic == 2)
                 print(olist, >> outlist)

          }  # this brace is from for outer ndr i

          filist = ""   # close the file

          check = check1
end

