# IRAF script -- _dithead2fl
#      function: get the offset information from the header
#	
# programmer: sjchan 
#          history: 
#             5may98 -- created
#            10june98 -- modified: add an option 
#                               to look for ra_off if it cannot find raoff 
#                               and similarily for decoff

procedure _dithead2fl(frame_in, pixunit, ashiftfl, fileout)

string	frame_in   {"",prompt = "List of Input images", mode="ql"}
string  pixunit    {"WHT", prompt="Pixel unit to be used (WHT/INT/pix)", mode="ql"}
string ashiftfl    {"none", prompt="Input app-offset file (for no use header only)", mode="ql"} 
string  fileout    {"app_shift.in", prompt = "Ouput file containing offset w.r.t. to BASE pos", mode="ql"}
string  check      {"G", prompt="check header flag?"}

struct *filist

begin


        string  ifile      #i Input list of images string
        string  pixunit1   #i pixel unit to be used
        string  ashiftfl1  #i Input app-offset file 
                            #i (none: use header / app-offsetfl: no use header)
        string  fileout1   #i output file containing approxmated offset 
        string  framein    #i input image
        string  sraoff     #o raoff offset w.r.t. rabase in string
        string  sdecoff    #o decoff offset w.r.t. decbase in string
        real    raoff      #o raoff in real (asec)
        real    decoff     #o decoff in real (asec)
        real    pixelscale #i pixelscale
        real    raoffpix   #o raoff in pixel-coordinates
        real    decoffpix  #o decoff in pixel-coordinates  
        string  twarn      #o temporary file containing error message from
                           #    imgets
        string  swarn      #o the first word in the error message (Warning:)

        cache imgets     # need this action due to a bug in imgets

        #  Get the rest of the parameter

        ifile = frame_in
        pixunit1 = pixunit
        ashiftfl1 = ashiftfl
        fileout1 = fileout
        twarn    = mktemp("twarn")
        swarn    = "G"

        # check the existence of the output file
   
        if (access(fileout1))
            delete(fileout1, ver-, >& "dev$null")
 
         if (pixunit1 == "WHT")
            pixelscale = 0.32  # asec/pixel
         if (pixunit1 == "INT")
            pixelscale = 0.46 
         if (pixunit1 == "pix")
            pixelscale = 1.   # input in pixelscale
      
        
        if (ashiftfl1 == "none")
         {  # get app-offset information from header
          filist= ""; filist = ifile
          while(fscan(filist,framein) !=EOF)
           {
            imgets(framein, param="raoff", >& twarn)
            sraoff  = imgets.value;  raoff  = real(sraoff)
             unlearn type
             type(twarn) | scan(swarn)
             delete(twarn, ver-, >& "dev$null")
            if ((sraoff == "") || (swarn == "Warning:") || (sraoff == "/"))
              {
                    print("no RAOFF value in the header!")
                    print("Try to get RA_OFF value!")
                    imgets(framein, param="ra_off", >& twarn)
                    sraoff  = imgets.value;  raoff  = real(sraoff)
                    swarn = "G" #clean the previous record
                    unlearn type
                    type(twarn) | scan(swarn)
                    delete(twarn, ver-, >& "dev$null")
                    if ((sraoff == "")||(swarn == "Warning:")||(sraoff == "/"))
                       { 
                         swarn = "G" #clean the previous record
                         print("no RA_OFF value in the header also!")
                         print("Use input approximated-offset file option!")
                         check = "B"
                         bye
                       } #this brace if from inter if-block(sraoff=="","0","/")
                    else
                     {
                        imgets(framein, param="dec_off")  
                        sdecoff = imgets.value;  decoff = real(sdecoff)
                     }
              } # this brace is from outer if block (sraoff=="","0","/")
            else
             {
              imgets(framein, param="decoff")  
              sdecoff = imgets.value;  decoff = real(sdecoff)
             }
            raoffpix =  - raoff / pixelscale
            decoffpix = decoff / pixelscale

            printf("%7.1g%7.1g%8.1g%7.1g\n",raoffpix,decoffpix, raoff,decoff, >> fileout1)

          } # this brace is from while block (filist, framein)
         filist = "" # close the file 
         } # this brace is from if block (ashiftfl1 == "none")
        else
         {  # get app-offset information from input file
            filist = ""; filist = ashiftfl1
            while(fscan(filist, raoff, decoff) 	!=EOF)
              {
                raoffpix = raoff / pixelscale
                decoffpix = decoff / pixelscale
                printf("%7.1g%7.1g%8.1g%7.1g\n",raoffpix,decoffpix, raoff,decoff, >> fileout1)
              } # this brace is from while block (filist, raoff, decoff)
             filist = "" # close the file

         } # this brace is from if else block (app-offset information from file


end

