# IRAF script -- crrr2rrrc.cl
#	
#   function:  to rename the input data filenames in order to make the
#              cqlook tasks understand it (only for input data is
#                 RRR-RC from PC)
#   
#
# programmer: sjchan 
#   history:  dec97:  created - ccmkquad.cl
#             23jan98: change into cmkquad.cl
#             24feb98: rename to cmkint1img.cl (only for 1st-int data)
#             30mar98: copy from cmkint1img.cl (for RRR-RC data from PC)
#             1apr98:  put noise correction 

procedure crrr2rrrc(frame_in, tot_fold, tot_quad, rrrc_out, answer, stripe)

string	frame_in  {"",prompt="(@List/*.fits or .imh) of Input images",mode="ql"}
int     tot_fold  {min=2, prompt="total number of rrr-folds for a fixed-pos obs",mode="ql"}
int     tot_quad {16, prompt="Total number of quadrants", mode="ql"}
string  rrrc_out {"rrrc_inputname", prompt="Output list containing fold output filenames", mode="ql"}
string  stripe   {"B", prompt="Destriping correction option (B/R/C/NO)", mode="ql"}
bool    answer    {yes, prompt="Sort the input list?"}


struct *lilist, *lolist



begin
        string  ftmpi      # input file list
        int     foldnum    # total number of folds for a fixed-pos observation
        int     totquad1   # total number of quadrants
        string  ofile     # a file containing fold output filenames
        string  ifile     # the final version of input file list
        string  foldin    # a file containing fold input filenames
        string  framein     # input file list containing input image
        string  frameout    # output file list containing output images
        string  crrr2rrrclog  # logfile
        int     icounter    # counter
        int     leni       # length of input file list string
        int     tefoldno    # dummy variables tefoldno = foldnum - 1
        bool    answer1    # ask sort the input list
        string  stripe1    # destriping correction option
        string  cflag       # check file flag (G/B)
        string  nofile     # a temporary file containing fold output files
                             #  in which are noise-corrected images
        string  tmplog     # temporary logfile of CSTRIPE
        bool    rccor1     # ask whether this is a reset-corrected image
                           # rccor1 == yes (always)

      #  Get the rest of the parameters

        ftmpi = frame_in
        foldnum=tot_fold
        totquad1 = tot_quad
        ofile = rrrc_out
        stripe1 = stripe
        answer1=answer
        foldin = "dummyfold"
        crrr2rrrclog = "crrr2rrrc.log"
        tefoldno = foldnum - 1
        nofile = mktemp("crcofl")
        tmplog = "cstripe.log"

        #  Find out the suitable input option

        leni=strlen(ftmpi)

        if (stridx(ftmpi, "@") == 1)
           ifile = substr(ftmpi, 2, leni)
        else
         {
           ifile = mktemp("fin")
           sections(ftmpi, option="fullname", > ifile)
         }

     # Check existence of output files

        if (access(ofile))
          delete(ofile, ver-, >& "dev$null")
        if (access(crrr2rrrclog))
          delete(crrr2rrrclog, ver-, >& "dev$null")
        if (access(tmplog))
          delete(tmplog, ver-, >& "dev$null")


      # Sort the input file list (increaing order in sequence number)
      #  if user wishes (if no: the input file has been SORTED
        if (answer1)
            _finsort(ifile)

      # Make fold input file lists and fold output file lists
        cmkllistrrrc(ifile, foldnum, foldin, ofile, totquad1)
        cflag = cmkllistint1.check
        if (cflag == "B") 
            bye      # exit this task

      # Rename the files

        ic = 0
        lilist = ""; lolist = ""
        lilist = foldin; lolist = ofile
        while ( (fscan(lilist, framein) !=EOF) && (fscan(lolist, frameout) !=EOF) )
        {
          delete("@"//frameout, ver-, >& "dev$null") # delete the existed output images before
                                       # the new ones are created
          ic += 1
          print("======================================", >> crrr2rrrclog)
          print("", >> crrr2rrrclog)
          print("Fold"//str(ic)//" :", >> crrr2rrrclog)
          imcopy("@"//framein, "@"//frameout, ver+, >> crrr2rrrclog)

          # update the header
          hedit("@"//frameout, field="errrfold", value=tefoldno, add+, del-,
              ver-, update+, show-)

                # Perform descriping option
                 # B /MB- descriping rows and columns
                 # R / MR- descriping only rows
                 # C / MC- descriping only columns
                 # NO - non-descriping

                if ( (stripe1 == "B")||(stripe1 == "R") ||(stripe1 == "C") ||
                     (stripe1 == "MB")||(stripe1 == "MR")||(stripe1 =="MC") )
                   {
                     cstripe("@"//frameout, stripe1)
                     unlearn type
                     type(tmplog, >> crrr2rrrclog)
                     print("n"//frameout, >> nofile) 
                   }  # this brace is from if block (destriping option)

        }  # this brace is from while fold (lilist, framein)
          lilist = ""; lolist = ""   # close the files

          
        if ((stripe1 == "B")||(stripe1 == "R")||(stripe1 == "C")||(stripe1 == "MB" ))
           {
             delete(ofile, ver-, >& "dev$null")
             rename(nofile, ofile, field = "all")
           }  # this brace is from if block (destriping option)
 

         if (access(foldin))
           {
             # delete *inlp* files which are created from cmkllistint1.cl
            delete("@"//foldin, ver-)   
            delete(foldin, ver-) 
            }



          print("   << ========= CRRR2RRRC DONE =========== >>")
          beep; beep; beep

end

