# IRAF script -- cmkslope.cl
#	
#   function:  to provide  all the combination of RC-images from 
#                adjacent-RC images within a given NDR range
#                
#
#                 
#
# programmer: sjchan (jan 98)
#     history: jan98 -- created at WHT (cmkrclp.cl)
#             4feb98 -- the name of output main text list has run number
#                          (cmkrclp.cl)
#             4feb98 -- renamed cmkvrclp.cl
#                         add TTRANSPOSE to reverse the input file 
#             13may98 -- renamed cmkslope.cl  
#             26may98 -- renamed cmkslope.cl       
#
#

procedure cmkslope(rcfl_in, fl_out, pix_type, calc_type)

string	rcfl_in   {"rxxxx_outfold1",prompt="(List of Input RC files",mode="ql"}
string  fl_out    {"rxxxx_ofold1", prompt="(List of of Output RC files", mode="ql"}
string  pix_type {"real", prompt="pixtype of output images", mode="ql"}
string  calc_type {"real", prompt="calctype for IMARITH operation", mode="ql"}

struct  *rilist2
struct  *rolist2

begin
        string  rcflin     # input file list containing input image per fold
        string  rcflout    # output file list containing output image per fold
        string  tflin1        # input selected fold file 
        string  flin1         # input selected fold file in reverse order
         string  flout       # output file fold list
        string  trcflin[2] # dummy variables
        string  cmkslopelog  # logfile
        int     ic           # dummy counters
        int     len3       # lenght of ss3 string (see below)
        int     inum1, inum2 # dummy counters
        int     inum         # the location of the last "_" of rcflin string
        string  ss1, ss2, ss3   # dummy variables
        string  pixty      # pixtype of output images
        string  calcty     # calcuating type for IMARITH
        string  base       # prefix of basenm
        string  basenm     
        string  fout       # dummy variable for output images
        string  ind        # indicator
        string  ss4        # dummy variable of substring of rcflin
        string  thead      # the prefix of the input file list (rcflin)
                             # with "run number"
        int   inumm      # the location of the 2nd last "_" in string rcflin

      #  Get the rest of the parameters

        tflin1 = rcfl_in
        flout = fl_out
        pixty = pix_type
        calcty = calc_type
        cmkslopelog = "cmkslope.log"
        ind = "RC"   # Reset correction
        base = "rc"
        flin1 = "flin1.txt"

     # Check the existence of the output file
        if (access(flout))
           delete(flout, ver-, >& "dev$null")
        if (access(cmkslopelog))
           delete(cmkslopelog, ver-, >& "dev$null")
        if (access(flin1))
           delete(flin1, ver-, >& "dev$null")

    # make a new input list in reverse order
            ttranspose(tflin1, flin1, "v", ver+, >> cmkslopelog)

     # Read contents  outfold# in current fold
            ic = 0
            rilist2 = ""
            rilist2 = flin1
            while ( (fscan(rilist2, rcflin) != EOF))
             {   # rcflin = rxxxx_rc0i_#p: contains image files

               _locate(rcflin, "_")  # find the location of the last "_" of
               inum = _locate.value    # rcflin string
               len3 = strlen(rcflin)
               ss3  = substr(rcflin, inum, len3)
               ss4  = substr(rcflin, 1, inum-1)
               _locate(ss4, "_")
               inumm = _locate.value
               thead = substr(ss4, 1, inumm)      

               ic += 1
               if (ic == 1) 
                 {
                   trcflin[ic] = rcflin
                   ss1 = substr(rcflin, inum-4, inum-3)
                   goto lab   # lab is a label, 
                              # need to read once more in this file
                 }
               else if (ic == 2)
                 {
                  trcflin[2] = rcflin
                  inum1 = inum - 1
                  ss2 = substr(rcflin, inum-2, inum1)
                 }
               else 
                 {
                  trcflin[1] = rcflout
                  trcflin[2] = rcflin
                  inum1 = inum - 1
                  ss2 = substr(rcflin, inum-2, inum1)
                 }

         # Make the rootname of the output list
                basenm = base//ss1//ss2
                rcflout = thead// basenm//ss3
                print(rcflout, >> flout)

                   print("-----------------------------------", >> cmkslopelog)
                   print("", >> cmkslopelog)
                   print("RC pairs:", ss1, ss2, >> cmkslopelog)
                   print("RC pairs:", ss1, ss2)

                _mkrclist(rcflin, basenm, rcflout) # Make the output list

          # Check the existence of output images

                rolist2 = ""; rolist2 = rcflout
                while ( fscan(rolist2, fout) != EOF)
                 {
                   if (access(fout))
                     delete(fout, ver-, >& "dev$null")
                 }              
                rolist2 = ""

                 # Provide the real  image and update the header     
                   unlearn imarith
                   imarith(operand1="@"//trcflin[1], op="+", 
                      operand2="@"//trcflin[2],
                       result="@"//rcflout,  pixtype=pixty, calctype=calcty,
                       verbose=yes, >> cmkslopelog)
             
#                  hedit("@"//rcflout, field="fold", value=ic, add+, del-, 
#                    ver-, update+, show-)
                   hedit("@"//rcflout, field="rcflag", 
                      value=ind, add+, del-, ver-, update+, show-)
       
                   goto lab   # 
                    # from while fold (rcflout)
             lab:       # lab is from if else block (ic == 1) 
      
             }   # this brace is from while block (rilist2, rcflin)
           rilist2 = ""
    
           delete(flin1, ver-, >& "dev$null")

           print(" << =========== CMKSLOPE DONE ============ >>")
           
end

