# IRAF script -- cobsinit.cl
#
#  function: to enter the essential information during the runs
#
#  stage: need to change
# progrmmer : sjchan (December 1997)
#

procedure cobsinit(tabname,filename,rootname,object,imagetype,cat_ra,cat_dec,
                    cat_epoc,
                    tot_loop, loopnum_st,loopnum_end,filter,exprrr,
                    utstart, ststart, airmass, readout, readrate,
                    status, weather, cont, last, date_obs)

string tabname {"cobsinit.inf", prompt="Output filename of the observing log", mode="ql"}
string filename {"",prompt="Input name of the loop-1 file within a loop [18s]", mode="ql"}
string rootname {"",prompt="Input rootname of a set of files[11s])", mode="ql"}
string object {"obj_title",prompt="Input the name of current object[14s]",mode="ql"}
string imagetype {"target", prompt="Input object type (target|dark|flat)", mode="ql"}
string cat_ra  {"03:17:14.50", prompt="RA Taken from the target list; hh:mm:ss.ss", mode="ql"}
string cat_dec {"-15:21:00.00", prompt="DEC Taken from the target list ; Sdd:mm:ss.ss; S=-", mode="ql"}
string cat_epoc {"1950.0", prompt="Epoch of the coordinates in RA, DEC; 1950.0|2000.0", mode="ql"}
string tot_loop {"10",prompt="Effective total number of this loop (totloop_RRR-1[2s]", mode="ql"}
string loopnum_st {"1", prompt="Starting loop/run  number in a given loop[4s]", mode="ql"}
string loopnum_end {"10", prompt="End loop/run number in a given loop[4s]", mode="ql"}
string filter   {"J", prompt="Filter[4s]", mode="ql"}
string exprrr {"5.0", prompt="Length of exposure time per Read-Reset-Read (sec)[5s]", mode="ql"}
string utstart {"01:10:10.0", prompt="UT at exposure start; hh:mm:ss.s", mode="ql"}
string ststart {"00:00:00.0", prompt="Local sideral time at exposure start; hh:mm:ss.s", mode="ql"}
string airmass  {"1.00", prompt="Airmass at start x.xx", mode="ql"}
string readout {"normal", prompt="Detector readout mode[6s]", mode="ql"}
string readrate {"387", prompt="Detector readout rate[6s]", mode="ql"}
string status {"concluded", prompt="termination mode (concluded, aborted, error)", mode="ql"}
string weather {"excellent", prompt="Weather condition (excellent,good,moderate,cloudy)", mode="ql"}
bool cont {yes, prompt=">>>Next entry?", mode="ql"}
string last {"no", prompt="This is the last entry tonight? (no|yes)", mode="ql"} 
string date_obs {"09/12/97", prompt="Date of observation; dd/mm/yy"}

begin
      # Local variable declarations
        string fname1       # name of loop-1 file within a given loop
        string tabname1     # filenmae of the obseving log
        string rname1       # rootname of input files
        string title        # the title of this object
        string imgtype      # image type
        string ra1          # RA of the object that the telescope is tracking
        string dec1         # DEC of the object that  the telescope is tracking
        string equinox1     # equinox of the coordinates in RA, DEC
        string totloop      # total number of a loop
        string loopst       # Starting loop/run  number in a given loop
        string loopend      # end loop/run number in a given loop
        string filter1       # filter
        string exprrr1     # Length of exposure time per loop (sec)
        string utstart1     # UT at exposure start
        string ststart1     # local sideral time start
        string airmass1     # airmass at start
        string status1      # status mode of observation
        string  last1        # prompt this is the last observation
        string tmpdummy     # dummy file name
        string dateobs      # date of observation
        string readout1     # detector readout mode
        string readrate1    # detector readout rate
        string weather1     # weather condition
        int    i


      # Get the reset of the parameters
        tabname1 = tabname
        fname1 = filename
        rname = rootname
        title = object     
        imgtype = imagetype
        ra1 = cat_ra
        dec1 = cat_dec
        equinox1 = cat_epoc
        totloop = tot_loop
        loopst  = loopnum_st
        loopend = loopnum_end
        filter1 = filter
        exprrr1 = exprrr
        utstart1 = utstart
        ststart1 = ststart
        airmass1 = airmass
        readout1 = readout
        readrate1 = readrate
        status1 = status
        weather1 = weather
        last1 = last
        dateobs = date_obs
        
        tmpdummy = "obstoday.inf"
  
      # Check the existence of the files
           if (access(tabname1))
                delete(tabname1, ver-, >& "dev$null")         
        
      # Enter the main loop to into the data into the given file

        if (last1 == "yes") 
          goto lab
 
        for (i = 1; i <= 1000; i += 1)
          {
           if (i > 1)
             {
              _cobsinit(tmpdummy,filename,rootname,object,imagetype,
                    cat_ra,cat_dec,cat_epoc, 
                    tot_loop, loopnum_st,loopnum_end,filter,exprrr,
                    utstart, ststart, airmass, readout, readrate,status,
                    weather)
             }
           else
             {
              _cobsinit(tmpdummy,fname1, rname1,title,imgtype,
                   ra1,dec1,equinox1,
                   totloop, loopst,loopend,filter1,exprrr1,
                   utstart1, ststart1, airmass1, readout1, readrate1,status1,
                   weather1)
             }
            if (!cont)
             {
                copy(tmpdummy, tabname1, ver-)
                break  # jump out the for loop
             }
          }  # this brace is from the for loop

       lab:
       if (last1 == "yes")  # record the date-obs and print the 
                            # field name at the top of
         {          # the columns

           stty ncols=300   # change the width of the columns for TYPE to
                            # display long line

           print("DATE-OBS=", dateobs, >> tabname1)
           print("        filename        rootname           title imgtype     CAT-RA       CAT-DEC  CAT-Epoch loop l_st  l_end filter exp(s)   UT          ST      Airmass R-mode   R-rate  Status    Weather", >> tabname1)

           _cobsinit(tmpdummy,fname1,rname1,title,imgtype,ra1,dec1,equinox1,
                   totloop, loopst,loopend,filter1,exprrr1,
                   utstart1, ststart1, airmass1,readout1,readrate1, status1,  
                   weather1) 
           type(tmpdummy, >> tabname1)
           print ("")
           print ("*****  Remember to delete OBSTODAY.INF before you logout  *****")
           print ("")
           print ("               << =====  Tonight DONE====== >>")
           beep; beep; beep
           stty ncols= 87    # change back to default value
         }  # this brace is from if (last) loop

           
end

