# IRAF script -- _cobsinit.cl
#
## this is a record processing script which is a HIDDEN task, user cannot
#   use it in the front end.
#  function: to enter the essential information during the runs
#
# progrmmer : sjchan (December 1997)
#

procedure _cobsinit(tabname2,filename2,rootname2,object2,imagetype2,
                    ra2,dec2,equinox2,
                    tot_loop2, loopnum_st2,loopnum_end2,filter2,exptime2,
                    utstart2, ststart2, airmass2, readout2, readrate2,status2,
                    weather2)

string tabname2 {"", prompt="Input filename of the observing log", mode="ql"}
string filename2 {"", prompt="Input name of 1-loop file within a loop", mode="ql"}
string rootname2 {"",prompt="Input rootname of a set of files", mode="ql"}
string object2 {"obj_title",prompt="Input the name of current object",mode="ql"}
string imagetype2{"target", prompt="Input object type (target| dark|flat)", mode="ql"}
string ra2  {"03:17:14.50", prompt="RA that the telescope is tracking; hh:mm:ss.ss", mode="ql"}
string dec2 {"+15:21:00.00", prompt="DEC that the telescope is tracking; Sdd:mm:ss.ss; S=+/-", mode="ql"}
string equinox2 {"B1950.0", prompt="Equinox of the coordinates in RA, DEC; B1950.0|J2000.0", mode="ql"}
string tot_loop2 {"10",prompt="Total number of this loop", mode="ql"}
string loopnum_st2 {"1", prompt="Starting loop/run  number in a given loop", mode="ql"}
string loopnum_end2 {"10", prompt="End loop/run number in a given loop", mode="ql"}
string filter2   {"J", prompt="Filter", mode="ql"}
string exptime2 {"5.0", prompt="Length of exposure time per loop (sec)", mode="ql"}
string utstart2 {"01:10:10.0", prompt="UT at exposure start; hh:mm:ss.s", mode="ql"}
string ststart2 {"00:00:00.0", prompt="Local sideral time at exposure start; hh:mm:ss.s", mode="ql"}
string airmass2  {"1.00", prompt="Airmass at start x.xx", mode="ql"}
string readout2 {"normal", prompt="Dectector readout mode", mode="ql"}
string readrate2 {"387", prompt="Dectector readout rate (KHz)", mode="ql"}
string status2 {"concluded", prompt="termination mode (concluded, aborted, error)", mode="ql"}
string weather2 {"excellent", prompt="Weather condition (excellent|good|moderate|cloudy", mode="ql"}

begin
      # Local variable declarations
        string tabname1     # filenmae of the obseving log
        string fname1       # name of the loop-1 file within a given loop
        string rname1       # rootname of input files
        string title        # the title of this object
        string imgtype      # image type
        string ra1          # RA of the object that the telescope is tracking
        string dec1         # DEC of the object that  the telescope is tracking
        string equinox1     # equinox of the coordinates in RA, DEC
        string totloop      # total number of a loop
        string loopst       # Starting loop/run  number in a given loop
        string loopend      # end loop/run number in a given loop
        string filter1       # filter
        string exptime1     # Length of exposure time per loop (sec)
        string utstart1     # UT at exposure start
        string ststart1     # local sideral time start
        string airmass1     # airmass at start
        string readout1     # dectector readout mode
        string readrate1    # dectector readout rate
        string status1      # status mode of observation
        string weather1     # weather condition


      # Get the reset of the parameters
        tabname1 = tabname2
        fname1 = filename2 
        rname1 = rootname2
        title = object2     
        imgtype = imagetype2
        ra1 = ra2
        dec1 = dec2
        equinox1 = equinox2
        totloop = tot_loop2
        loopst  = loopnum_st2
        loopend = loopnum_end2
        filter1 = filter2
        exptime1 = exptime2
        utstart1 = utstart2
        ststart1 = ststart2
        airmass1 = airmass2
        readout1 = readout2
        readrate1 = readrate2
        status1 = status2
        weather1 = weather2
 
        
        printf("%20s%13s%16s%7s%13s%14s%9s%4s%6s%6s%6s%7s%12s%12s%6s%8s%8s%10s%12s\n", 
               fname1,rname1, title, imgtype, ra1, dec1,
               equinox1, totloop, loopst, loopend, filter1, exptime1, utstart1,
                ststart1, airmass1, readout1, readrate1,status1,weather1, >> tabname1)

end

