# IRAF script -- cmkqskyint1.cl
#	
#   function:  to make the quad-sky
#               input: from the output of cmkimg, cmkrrrimg (cmkquad)
#               output: prehead: "sky_q"
#
#   stage: changing
#
# programmer: sjchan 
#   history:  nov 97   -- created: ccmkqskyint1 (bad approach)
#             dec97    -- modified: at the INT (simple comments)
#                                    can only be used for a few cases 
#             23jan98  -- renamed to cmkqsky.cl  
#             9feb98   -- modified: general approach 
#             24feb98  -- modified from cmkqsky.cl (only for 1st-int data)
#                          (only produce sky at quad=1, 5, 9, 13)
#                         the RRR readout mode in CIRSI did not work properly
#                           at quad = 2, 3, 4, 6, 7, 8, 10, 11, 12, 14, 15, 16
#      

procedure cmkqskyint1(file_in, file_out, pre_head, startfold, tot_quad)

string  file_in {"@rrr_skyxxxx.in",prompt="@The input list of lists to produce list of sky images", mode="ql"}
string  file_out  {"",prompt="File name containing output sky list", mode="ql"}
string  pre_head {"skyj_q",prompt="The prehead of the output sky frames",mode="ql"}
string  startfold  {"2", prompt="The start #th fold for combination", mode="ql"}
int     tot_quad  {16, prompt="Total quadrant numbers", mode="ql"}

struct  *filist

begin

        string  fileout     #o a file containing  output sky filenames
        string  filein      #i the input list string of lists individual images
        string  ftmpi       #i temporary input list of lists individual images
        string  ifile       #i the final version of input list of lists images
                             # a file contains each fold list 
        string  quadin      #i input image
        string  frameout    #o output sky name
        string  cmkqskyint1log   #o logfile
        string  prehead     # prehead of the output sky files
        string  startfold1  #i the start fold-th for combination 
        int     ic         # counters
        int     iq         # dummy variables
        string  siq        # dummy variable 'iq' in string
        string  sic        # counter in string
        int     icc        # dummy counter
        int     leni       # length of input file list string
        int     totquad    # total quadrant numbers
        string  ext        # dummy variable (extension of the output flats)
        string  templog    # dummy variable (temporary logfile)
        string  tflin      # temporary files of quadrant-images from
                            # _mkqlist
        string  filesky    # the final version of input images to make sky
   

      #  Get the rest of the parameters

        filein  = file_in
        fileout = file_out
        prehead = pre_head
        startfold1 = startfold
        totquad = tot_quad
        cmkqskyint1log = "cmkqskyint1.log"
        templog = "ccmksky.log"
        ext = ".fits"

     # Find out the suitable input option
        leni = strlen(filein)
        if (stridx(filein, "@") == 1)
           ftmpi = substr(filein, 2, leni)
        else
         {
           ftmpi = mktemp("fin")
           sections(ftmpi, option="fullname", > ftmpi)
         }

     # Check existence of output files

        if (access(cmkqskyint1log))
           delete(cmkqskyint1log, ver-, >& "dev$null")
        if (access(templog))
           delete(templog, ver-, >& "dev$null")
        if (access(fileout))
           delete(fileout, ver-, >& "dev$null")

        print("")
        print("=====Making lists of images to produce sky-images ======")
      # Read the main list (lists of images)
        icc = 0
        filist = ""; filist = ftmpi   # main list -- list of lists
        while (fscan(filist,ifile) !=EOF)
          {  # ifile - a file containing dithering list (different run number)
               #  e.g.: rrr_r1320.in, rrr_r1321.in, ....
            icc += 1

            print(ifile)
                # make lists of quadrant-images
                  # divided into 16 files quad_1.in, ..., quad_16.in
                _mkqlist(ifile) 
      
                # make another 16 files which first line is from 'startfold1'
                for (iq = 1; iq <= totquad; iq += 1)
                  {
                     siq = str(iq)
                     tflin = "quad_"//siq//".in"
                     filesky = "skyquad"//siq//".in"
                     if (icc == 1)
                       {
                         if (access(filesky))
                            delete(filesky, ver-, >& "dev$null")
                       } # this brace is from if block icc == 1


                     unlearn fields
                     fields(tflin, "1", lines=startfold1//"-", >> filesky)
         
                      # delete tflin
                     delete(tflin, ver-, >& "dev$null")

                   } # this brace is frome for fold (iq=1, totquad)
            }  # this brace is from while block (filist, ifile)
           filist = "" # close the file
      
      print("")
      print ("Now we are ready to make sky-images")
      print("")

      # Now, we are ready to make sky-images
         for (ic = 1; ic <= totquad; ic += 1)
             {

      # since CIRSI have read-out problem for RRR-mode, only 
       # quad=1, 5, 9, 13 work.
              if ((ic == 1)||(ic == 5)||(ic == 9)||(ic == 13))
                {
            # Make the output sky names and put them into a list 
                  _sdigit(ic, 2)
                  sic = _sdigit.value
                  frameout = prehead//sic//ext
                  print (frameout, >> fileout)

      # Check the existence of the file "frameout"
                  if (access(frameout))
                     delete(frameout, ver-, >& "dev$null")

                  print("", >> cmkqskyint1log)
                  print("Quad ", ic, >> cmkqskyint1log )
                  print("Quad ", ic)
                  sic = str(ic)
                  filesky = "skyquad"//sic//".in"
                  ccmksky("@"//filesky, frameout, n_start=1)

                  unlearn type
                  type (templog, >> cmkqskyint1log)
                  print("=========================================", >> cmkqskyint1log)
         
                } # this brace is from if block (ic == 1, 5, 9, 13)

                 delete(filesky, ver-, >& "dev$null")

           }   # this brace is from for block (ic =1, totquad)


          print("   << ========= CMKQSKYINT1 DONE =========== >>")
          beep; beep; beep

end

