# IRAF script -- cmkint1img.cl
#	
#   function:  (for DEC INT run) to provide  
#   
#   stage: ned to add comments, written at the INT              
#
# programmer: sjchan 
#   history:  dec97:  created - ccmkquad.cl
#             23jan98: change into cmkquad.cl
#             24feb98: rename to cmkint1img.cl (only for 1st-int data)
#                       (subtasks: cmkllistint1)
#                       delete zero size files

procedure cmkint1img(frame_in, tot_fold, answer)

string	frame_in   {"",prompt="(@List/*.fits or .imh) of Input images",mode="ql"}
int     tot_fold  {min=2, prompt="total number of rrr-folds for a fixed-pos obs",mode="ql"}
int     tot_quad {16, prompt="Total number of quadrants", mode="ql"}
int     nrun   {prompt="running number of this set of data", mode="ql"}
bool    answer    {yes, prompt="Sort the input list?"}

struct *lilist, *lolist



begin
        string  ftmpi      # input file list
        int     foldnum    # total number of folds for a fixed-pos observation
        int     totquad1   # total number of quadrants
        int     nrun1      # total number of running number
        string  ofile     # a file containing fold output filenames
        string  ifile     # the final version of input file list
        string  foldin    # a file containing fold input filenames
        string  framein     # input file list containing input image
        string  frameout    # output file list containing output images
        string  fout        # output images
        string  cmkint1imglog  # logfile
        int     icounter    # counter
        int     leni       # length of input file list string
        int     tfoldno    # dummy variables tfoldno = foldnum - 1
        bool    answer1    # ask sort the input list
        string  sruno       # running number in string
        string  cflag       # check file flag (G/B)
        string  ss1         # dummy

      #  Get the rest of the parameters

        ftmpi = frame_in
        foldnum=tot_fold
        totquad1 = tot_quad
        nrun1 = nrun
        answer1=answer
        ofile = "ofold.in"
        foldin = "dummyfold"
        cmkint1imglog = "cmkint1img.log"
        tfoldno = foldnum - 1
        ss1 = ""
        _sdigit(nrun1, 4)
        sruno = _sdigit.value
        ofile = "r"//sruno//"_"//ofile

        #  Find out the suitable input option

        leni=strlen(ftmpi)

        if (stridx(ftmpi, "@") == 1)
          {
           ifile = substr(ftmpi, 2, leni)
           ofile = "rrr_"//ifile
          }
        else
         {
           ifile = mktemp("fin")
           sections(ftmpi, option="fullname", > ifile)
           ofile = "rrr_"//ofile
         }

     # Check existence of output files

        if (access(ofile))
          delete(ofile, ver-) 
        if (access(cmkint1imglog))
          delete(cmkint1imglog, ver-)


      # Sort the input file list (increaing order in sequence number)
      #  if user wishes (if no: the input file has been SORTED
        if (answer1)
            _finsort(ifile)

      # Make fold input file lists and fold output file lists
        cmkllistint1(ifile, foldnum, foldin, ofile, totquad1, nrun1)
        cflag = cmkllistint1.check
        if (cflag == "B") 
            bye      # exit this task

      # Rename the files

        ic = 0
        lilist = ""; lolist = ""
        lilist = foldin; lolist = ofile
        while ( (fscan(lilist, framein) !=EOF) && (fscan(lolist, frameout) !=EOF) )
        {
          ic += 1
          print("======================================", >> cmkint1imglog)
          print("", >> cmkint1imglog)
          print("Fold"//str(ic)//" :", >> cmkint1imglog)
          imrename("@"//framein, "@"//frameout, ver+, >> cmkint1imglog)
        }

 
          if (access(foldin))
           {
             # delete *inlp* files which are created from cmkllistint1.cl
            delete("@"//foldin, ver-)   
            delete(foldin, ver-) 
            ss1 = "r"//sruno//"_"//"inlp0"
            delete("@"//ss1, ver-) 
            }

          lilist = ""; lolist = ""   # close the file

          print("   << ========= CMKINT1IMG DONE =========== >>")
          beep; beep; beep

end

