# IRAF script -- csplatndr.cl
#
#  function: plots pixel values vs. time for each quadrant images
#
#  programmer: sjchan
#    
#    history: 4 aug98 -- created
#                (original idea from splat.cl by mhoenig)
#             17aug98 -- modified: add an option to plot variance as function
#                                  of average
#                                  


procedure csplatndr (infiles)

string infiles   {prompt="Input files"}
string avg     {"mode", prompt="Type of average to be used by GSTAT",
                enum="mean|midpt|mode"}
string keyword {"TIME_OBS", prompt="Keyword to extract from header"}
bool chipselect {yes, prompt="Overplot each chip and quadrant separately"}
bool ansrms     {yes, prompt="Plot variance as a function of average also"}
bool cont        {yes, prompt=">> Next figure"}

struct *flist  

begin


    # Define local variables

    string infiles1  	    # input files
    string keyword1	    # keyword to extract from header
    string avg1  	    # GSTAT average to use (mean/midpt/mode)
    bool   chipselect1      # Overplot each chip and quadrant separately
    bool   ansrms1             # Plot variance as a function of avg
    int noimages  	    # no. of input images
    string imglist  	    # filename of list of images
    string imgname  	    # name of current image
    real    imavg	    # the actual average value for the particular image
    real    imrms1          # the sttdev of the actural average value
    string quadlist1         # filename containing plot files
    string  qno            #  quadrant number
    string  cno            #  chip number
    string  time           #  time stamp
    int     iqno           #  quadrant number in integer
    int     icno           #  chip number in integer
    int     tmpqno         #  virtual quadrant number (1-dim) 1,2,...,16
    string  axislen        #  axis length (1024 or 512)
    string  stquad          #  total number of quadrants in string
    int     tquad           #  total number of quadrants in integer
    int     ic[16]
    string  s1
    int  i                  # dummy counter
    int     icc

    # Get the reset of the parameters
    
    infiles1 = infiles
    keyword1 = keyword
    avg1 = avg
    chipselect1 = chipselect
    ansrms1 = ansrms
    keyword1 = "TIME_OBS"
    quadlist1 = "quad.list"
  
    if (access(quadlist1))
       delete(quadlist1, ver-, >& "dev$null")

    imglist=mktemp("filenames")//".list"
    sections (infiles1, option="fullname", > imglist)
    noimages = sections.nimages
    print ("")
    print ("No. of images is: ", noimages)
    print ("")

    for (i = 1; i <= 16; i += 1)
      ic[i] = 0

  # Read input files and then estimate "average" and variance by GSTAT
    icc = 0
    flist = ""; flist=imglist
    while (fscan (flist, imgname) != EOF)
    	{
          icc += 1
          print ("Image: ", imgname)
	  gstatistics (imgname, fields=avg1//",stddev", >& "dev$null")

          if (avg1 == "mean") 
               imavg=gstpar.mean
          else if (avg1 == "midpt")
               imavg=gstpar.midpt
          else if (avg1 == "mode") 
               imavg=gstpar.mode

          imrms1 = (gstpar.stddev)*(gstpar.stddev)

      # get the quadno and chipno and time_obs from the header or from filename
          unlearn hselect
          hselect(imgname, field="chip,quad,time_obs",expr="yes") | scan(cno,qno,time)
       
          iqno = int(qno); icno = int(cno)
          tmpqno = (icno - 1) * 4 + iqno
   
          print (avg1, "\t\t = \t", imavg)
          if (ansrms1)
               print("variance \t\t = \t", imrms1)

print("stddev:", gstpar.stddev)
  
          print (keyword1, "\t = \t", time)
          print("")       

       # get the totquad and the length of axis from headers       
          if (icc == 1)
            {
              unlearn hselect
              hselect(imgname, field="nframes, i_naxis1", expr="yes") | scan(stquad, axislen)
              tquad = int(stquad)
            } 

        # generate the input filenames if chipselect == yes
         if (chipselect1)
           {
               for (i = 1; i <= 16; i += 1)
                 {
                   if (tmpqno == i)
                    {
                      ic[i] = ic[i] + 1

                      if (ic[i] == 1)
                        {
                          s1 = "datafile" + i + ".in"

                          if (access(s1))
                             delete(s1, ver-, >& "dev$null")

                          print(s1, >> quadlist)
                      
                        } # ic[i] == 1
                     } #if block (tmpqno == i)
                   } # for block 
            } #this block is from if-block (chipselect1 == yes)
          else
            {
              if (icc == 1)
                  print("datafile.in", >> quadlist)
            }

      # generate  data input files for plotting 
        _divfile(imgname, imavg, imrms1, time, tmpqno, chipselect1)

	print ("")
	
	} #this brace is from while block (flist, imgname)
        flist = "" # close the file


        delete (imglist, ver-, >& "dev$null")
    
      # set up the axis attributes
        unlearn axispar
        unlearn pltpar
        unlearn dvpar

        axispar.xlabel = keyword1
        axispar.ylabel = avg1

        axispar.box = yes
        axispar.title = infiles1              
        axispar.grid = no

        dvpar.device = "stdgraph"
        dvpar.fill = yes

       # plotting graph
        _chipplot(quadlist, chipselect1, ansrms1, tquad, axislen)

	   	   
end
