# IRAF script -- cmkllistrrrc.cl
#	
#   this is a sub file management task which is ALMOST same as
#       HIDDEN task _mkllist
#
#   function:  to divide a list of finput iles into few (total_folds) sublists
#                 of files which will be in a file (inlist)
#              to make few lists of files which will be in a file (outlist)
#    different: _mkllist.cl -- ic = 0
#               cmkllist.cl -- ic == -1
#                 print(ilist, >> foldlist) if (ic > 0)
#               (try to fit the files which were reset corrected the PC).
#
# programmer: sjchan 
#   history: nov97  -- created (_mkllist.cl)
#            4feb98 -- modified 
#                      add a required parameter "totquad" to check number of
#                       files
#                      put run number as a prefix of outfoldX
#            6feb98 -- rename cmkllist.cl (for front end case)
#            30mar98 -- rename cmkllistrrrc.cl (for RRR-RC case only)
#            19aug98 -- add an option to seperate the pathname from full image
#                name with pathname 


procedure cmkllistrrrc(file_in, tot_fold, fold_list, out_list, totquad)

string	file_in   {"",prompt="List of Input images",mode="ql"}
int     tot_fold  {min=1, prompt="total number of raw-rrr-folds for a fixed-pos obs",mode="ql"}
string  fold_list {"", prompt="a file containing fold input filenames",mode="ql"}
string  out_list {"", prompt="a file containing final fold output image names", mode="ql"}
int     totquad {16, prompt="Total number of quadrants", mode="ql"}
string  check   {"G", prompt= "Check file flag (G/B)"}

struct  *filist


begin
        string  filein      # input file list
        int     totfold     # total number of folds for a fixed-pos observation
        string  foldlist    # a file containing fold input fileanmes 
        string  outlist     # a file containing fold output filenames
        string  ilist       # list of input files in #th fold
        string  ilisto      # a prefix for ilist file
        string  olist       # list of output files in #th fold
        string  olisto      # a prefix for olist file
        string  framein     # input frame without full pathname
        string  framein2    # input frame with full pathname
        string  temphead    # the prefix of an image name
        string  temptail    # the subfix(extension) of an image name
        int     icounter    # counter
        int     foldseq     # total sequence number in one fold
        int     ic, ic2     # dummy counters
        int     len         # the total length of an input filename
        int     lentemp     # the location of the last '_" in the filename
        int     lentemp2    # the location of the last "." in the filename
        string  sic2        # ic2 in string
        int     totquad1    # total number of quadrants
        string  check1      # check file flag
        string  sruno      # run number in string
        int     runo       # run number in integer
        int     ndig       # the number of digit of max running no in integer
        int     k

     

      #  Get the rest of the parameters

        filein=file_in
        totfold=tot_fold
        foldlist=fold_list
        outlist = out_list
        totquad1 = totquad
        check1 = check
        ilisto = "infd"
        olisto = "outfd"
        temphead = ""
        temptail = ""
        sruno = "0000"
        runo  = 0
        ndig  = 4

      # Check existence of output files
        if (access(foldlist))
          delete(foldlist, ver-, >& "dev$null")
        if (access(outlist))
          delete(outlist, ver-, >& "dev$null")

        # find out the total number of input files in the list
        count(filein) | scan(s1)
        icounter = int(s1)

        # find out the total seq number in one fold
        foldseq = icounter/totfold      # total quads
        if (foldseq != totquad1)
          {
            print("File IMCOMPLETE!!")
            check1 = "B"
            check = check1
            bye
          }
        else
          check1 = "G"
        
        filist = ""; filist = filein   # open the file
       # make foldlist files

         ic = -1
         for (k=1; k <= icounter; k += foldseq)
          {  
            ic += 1
            ilist = ilisto//str(ic)//".in" #make a fold list input filenames 
            olist =olisto//str(ic)//".in"  #make a fold list output filenames

               ic2 = 0
               while (fscan(filist,framein2) !=EOF)
                {
                  ic2 += 1
                  
          # add this option on 19aug98
        # to seperate the pathname from the full image name with pathname
                   _sepdir(framein2)
                   framein = _sepdir.fname

            # get the run number from the header or from the filename
                  if (ic2 == 1)
                    { #  try to get the running number from filename first
                        # in order to avoid the zero size of file
                           _locrnonew(framein)
                           runo = int(_locrnonew.srunno)
                           _sdigit(runo, ndig)
                           sruno = _sdigit.value
                      if (sruno == "0000") # Try imheader 
                        {
                          print("Try header!")
                          imgets(framein, param="nrun")
                          sruno = imgets.value
                          if ((sruno == "") || (sruno == "0") || (sruno == "/R"))
                            print("Cannot find running number from header also!")
                            sruno = "0000"
                        } # this brace is from if block (srunno = "0000")
                      # fold input list and output list name nrun
                      olist="r"//sruno//"_"//olist
                      ilist="r"//sruno//"_"//ilist 

                      if (access(ilist))
                         delete(ilist, ver-, >& "dev$null")
                      if (access(olist))
                         delete(olist, ver-, >& "dev$null")
                    } # this brace is from the if block (ic2 == 1)

                  print(framein2, >> ilist)   # make an input fold list

        # find out the location of the last "_" in the given filename
                  len = strlen(framein)

                  _locate(framein, "_")
                  lentemp = _locate.value

        # make the prehead from char#1 to char#(lentemp)
                     temphead = substr(framein, 1, lentemp)

        # find out the location of the last "." in the given filename
                    _locate(framein, ".")
                    lentemp2 = _locate.value

        # make the subhead from char#lentemp2 to char#(len)
                  if (ic2 == 1)
                     temptail = substr(framein, lentemp2, len)

        # make an output fold list
                 _sdigit(ic2,2)
                 sic2 = _sdigit.value
                 print(temphead//str(ic)//"p"//temptail, >> olist)

        # check whether a "complete" is finished
                   if (ic2 == foldseq)
                         break     # leave the fold to create another file
                }  # this brace is from while block

            if (ic > 0)
               {
                 print (ilist, >> foldlist)
                 if (ic < totfold)
                    print(olist, >> outlist)
               } # this brace is from if block (ic > 0)

          }  # this brace is from for outer for block k

          filist = ""   # close the file
          check = check1 


end

