# IRAF script - cirmean.cl
#
#  function: Determine mean/standard deviation of a list of numbers. (x, y)
#
# programmer: sjchan (march 1997)

procedure cirmean(input, logfl)

file	input	{prompt="File containing list of numbers to calculate"}
string  logfl   {"",prompt="Enter the output file name"}

real	meanx	{0.0,prompt="Output: mean of numbers of x"}
real	stdx	{0.0,prompt="Output: standard deviation of x"}
real	meany	{0.0,prompt="Output: mean of numbers of y"}
real	stdy	{0.0,prompt="Output: standard deviation of y"}


struct	*in

begin
	# Declarations
	int	n		# Number of values accumulated.
	real	sumx, sum2x	# Sums.
        real    sumy, sum2y
	real	x, y		# Values
        string  meanlog

	# Get query parameters and initialize list.
	in = input
        meanlog = logfl

	# Collect statistics.
	n = 0
	sumx = 0.
	sum2x = 0.
        sumy =0.
        sum2y = 0.
	while (fscan (in, x, y) != EOF)
        {   
            sumx += abs(x)  # to make the -ve shift into +ve shift
            sum2x += (x*x)
            sumy += abs(y)
            sum2y += (y*y)
            n += 1
	}

	# Calculate statistics.
	switch (n) {
	case 0:
	    {
		meanx = INDEF
		stdx = INDEF
		meany = INDEF
		stdy = INDEF
	    }

	case 1:
	    {
		meanx = sumx
		stdx = INDEF
		meany = sumy
		stdy = INDEF
	    }

	default:
	    {
		meanx = sumx / n
		stdx = (sum2x - meanx * sumx) / (n - 1)
		if (stdx < 0)
		    stdx = INDEF
		else
		    stdx = sqrt (stdx)

		meany = sumy / n
		stdy = (sum2y - meany * sumy) / (n - 1)
		if (stdy < 0)
		    stdy = INDEF
		else
		    stdy = sqrt (stdy)

	    }
	}

	in = ""      # close the input file

	# Print results
        print ("", >> meanlog)
        print ("===============================================",>> meanlog)
	print ("meanx = "//meanx//" stdx = "//stdx, >> meanlog)
	print ("meany = "//meany//" stdy = "//stdy, >> meanlog)

        print ("")
        print ("===============================================")
	print ("meanx = "//meanx//" stdx = "//stdx)
	print ("meany = "//meany//" stdy = "//stdy)


end
