# IRAF SPP -- cirinfo.x
#
#  function: Get values of the an image header parameter as a character string.
#            The value is returned as a CL parameter of type string;
#            It creates an ASCII file which contains all the selected header
#              information of images
#
#   stage:  need change
#   programmers:  sjchan (oct 1997)
#    history:   oct97 -- created
#               28may98 -- modified
#

task cirinfo = t_cirinfo

include	<error.h>   # macros related to the error handling
include	<imhdr.h>   # macros related to the header information
include	<imio.h>    # macros related to the images I/O

procedure t_cirinfo()

pointer	sp          # pointer for memory stack
pointer im          # pointer to the address of the input image descriptor
pointer	images      # pointer to the address of the input image name
pointer template    # pointer to the address of the name of the input list
pointer valuetit    # pointer to the address of the value of the title
pointer valuetime   # pointer to the address of the value of the starting time
pointer filter      # pointer to the address of the value of filter
pointer dateobs     # pointer to the address of the value of date_obs
pointer nrun     # pointer to the address of the value of individual running number
pointer chip       # pointer to the address of the value of the detector number
pointer quad     # pointer to the address of the value of the quad number in a detector
pointer outfile     # pointer to the address of the name of the output file
int imlist          # the list descriptor for ASCII file
int  fd             # the file descriptor for ACCII file
real  expt          # exposure time

pointer	immap()   # function to open image, this returns a pointer type
                    #  variable that is pointer to the address of the image descriptor
int imtopen()     # function to open image template
int imtgetim()    # function to get next image name
int  open()       # function to open or create a text or binary file
real imgetr()     # function to get a header parameter

begin

    # Mark the memory stack, this marks the beginning of the block of 
    #   memory to be referenced
         call smark (sp)

    # Allocate (stack memory) character buffers, 
     # SZ_FNAME: the maximum number of chars in a line(hlib$iraf.h)
     # TY_CHAR: the data type is Character (hlib$iraf.h)
         call salloc (template, SZ_FNAME, TY_CHAR)
    	 call salloc (images, SZ_FNAME, TY_CHAR)
	 call salloc (valuetit, SZ_LINE,  TY_CHAR)
	 call salloc (nrun, SZ_LINE,  TY_CHAR)
         call salloc (chip, SZ_LINE, TY_CHAR)
         call salloc (quad, SZ_LINE, TY_CHAR)
	 call salloc (filter, SZ_LINE,  TY_CHAR)
	 call salloc (valuetime, SZ_LINE,  TY_CHAR)
	 call salloc (dateobs, SZ_LINE,  TY_CHAR)
         call salloc (outfile, SZ_FNAME, TY_CHAR)
       
    # Get a cl string parameters; Memc[] passing memory buffer to the procedure
	call clgstr ("template", Memc[template], SZ_FNAME)
        call clgstr ("outfile", Memc[outfile], SZ_FNAME)

     # Get the input images from the template list, 
        imlist = imtopen (Memc[template]) 

     # Open the output text file; passing memory buffer(outfile) to the
      # "open" procedure; check any error ocurrs when the file is opened
      # detail explanation:
        # NEW_FILE:  the I/O mode is New file
        # TEXT_FILE: the file type is Plain text (ASCII)

        iferr (fd = open (Memc[outfile], NEW_FILE, TEXT_FILE))
               call erract (EA_WARN)    # check any error 

        call fprintf(fd,"      Filename                Title        NRun   Chip   Quad  Filter Time_Obs(ms)        Date_Obs        Expt(s)\n\n")# formatted print to any open file

     # Main processing block. An image is processed in each pass through
     # the block.
          # get the "next" image name from the list
       while ( imtgetim(imlist, Memc[images], SZ_FNAME) !=EOF )
        {
         # Open the input image, 
	  im = immap (Memc[images], READ_ONLY, 0)

         # Get  string parameters from the image header
    	  iferr (call imgstr (im, "i_title", Memc[valuetit], SZ_LINE)) 
	    call erract (EA_WARN)

	  iferr (call imgstr (im, "nrun", Memc[nrun], SZ_LINE)) 
	    call erract (EA_WARN)

      	  iferr (call imgstr (im, "chip", Memc[chip], SZ_LINE)) 
	    call erract (EA_WARN)

      	  iferr (call imgstr (im, "quad", Memc[quad], SZ_LINE)) 
	    call erract (EA_WARN)

          iferr (call imgstr (im, "time_obs", Memc[valuetime], SZ_LINE)) 
	    call erract (EA_WARN)
 
	  iferr (call imgstr (im, "filter", Memc[filter], SZ_LINE)) 
	    call erract (EA_WARN)

	  iferr (call imgstr (im, "date_obs", Memc[dateobs], SZ_LINE)) 
	    call erract (EA_WARN)

          iferr (expt= imgetr (im,"exp_time")) 
	    call erract (EA_WARN)

       #  print the information which get from header to a file         
#          call fprintf (fd,"%15s%16s %13s%6s%8.1f%6s %6s%7s%7s\n")
          call fprintf (fd,"%39s%11s%6s%6s%6s%6s%16s%23s%8.1f\n")
          call pargstr (Memc[images])
          call pargstr (Memc[valuetit])
          call pargstr (Memc[nrun])
          call pargstr (Memc[chip])
          call pargstr (Memc[quad])
          call pargstr (Memc[filter])
          call pargstr (Memc[valuetime])
          call pargstr (Memc[dateobs])
           call pargr (expt)     # expt is a real variable

       #  Unmap (close) an image
          call imunmap (im)      
        }    # this brace is from the while block
     
      # Close the output file
        call close(fd)

      # Close the image template (the list of input images)
        call imtclose (imlist)

      # Free the memory:

       call sfree (sp)


end
