# IRAF script -- cirentroid.cl
#
# function: to find the shifts w.r.t. the reference image for entroiding.
#	
# programmers: sjchan (August 1996; findshift)
#                     (March 1997: irshift)
#                     (Oct 1997: change into cirentroid.cl to suit IRAF v2.11
#

procedure cirentroid (frame_in,listimage,shift_fl)

string	frame_in   {"",prompt="Input reference image for centroiding ",mode="ql"}
string  listimage  {"",prompt="Input list of images (@/*.fits;including the reference image)",mode="ql"}
string  shift_fl  {"",prompt="Output file containing the shift of each image",mode="ql"}
string  cood_fl  {"none",prompt="Coordinate file for non-interactive mode"}


begin
        # Local variable declarations
        string  framein    # Input reference image for centroiding
        string  l_images   # Input list of images
        string  l_coords   # Coordinate file for non-interactive mode
        string  shiftfile  # Output file containing the shift of each image
        string  junk       # dummy variable
        string  imname     # name of input image
        string  pdout1     # logfile from tvmark, dummy variable
        string  tcoo     # coordinate file containing the positions of objects
        string xshift, yshift   # x-shift, y-shift of each object in the frame
        string shiftlog           # logfile
        string ind                # indicator
        string ifile, ofile       # final version of input and output
        string fout2          # input file variable for task cirmkobj if 
                              #   using offset option
        string shiftfile2     # same as shiftfile (dummy variable)
        string subim          # dummy variable
        struct line           # dummy variable (to read shiftlog)
        bool    shifts_found = no  # dummy variable (to find shift)
        int     leni          # length of input list file name

	# Make sure the appropriate packages are loaded.

	if (!defpac("noao"))
	   noao

        #  Get the rest of the positional parameters

        framein=frame_in
        l_images=listimage
        shiftfile=shift_fl
        l_coords=cood_fl
        pdout=""
        shiftlog="cirentroid.log"
        ind="O"      # dummy definition
        ifile="dummy1"   # only need ifile
        ofile="dummy2"   # dummy definition
        shiftfile2="oset.dat"

        # Check the existence of the files

        if (access(shiftfile))
            delete (shiftfile, ver-, >& "dev$null")
        if (access(shiftfile2))
            delete (shiftfile2, ver-, >& "dev$null")
        if (access(shiftlog))
            delete (shiftlog, ver-, >& "dev$null")
        if (access(ifile))
            delete (ifile, ver-, >& "dev$null")
        if (access(ofile))
            delete (ofile, ver-, >& "dev$null")

        #  Find out the suitable input option

           _finout(l_images, ind, ifile, ofile)

        if (l_coords == "none")
          {
          # For interactive mode
            unlearn display
            display (framein,1, fill=yes)

            pdout1=mktemp("tdma")
  
           # Make a coords file
            print("")
            print("tvmark is running in interactive mode.")
            print("Type 'c' to mark the reference objects, type 'q' to quit")
            print("")

            unlearn tvmark
            tvmark (1, "", logfile=pdout1, autolog=yes, mark="circle", 
                      radii="3.0",color=204, interactive=yes)

            tcoo=pdout1
        }
        else
        {  # For non-interactive mode
           tcoo=l_coords
        }

       # Estimate the shifts
         unlearn imcentroid
         imcentroid ("@"//ifile, coords=tcoo, reference=framein, shifts="", 
                        niterate=20, tolerance=0,verbose=yes,
                        >> shiftlog)
         
	# read the shifts information, imcentroid prints out the center of
        #  objects and then print the shift position with the header "#Shifts"

	list = shiftlog
	while (fscan (list, line) != EOF)
           {
             if (substr(line, 1, 7) == "#Shifts")
              {
		shifts_found = yes
		break
              }
	    }

	if (shifts_found)
         {
	    while (fscan (list, imname, xshift, junk, yshift, junk) == 5)
              printf("%6s%8s %30s\n",xshift,yshift,imname, >>shiftfile2)

           # numeric_sort=no: to make the reference image (0., 0.) 
           #                  at the top of the file
            sort (shiftfile2, column=0, ignore_white=no, numeric_sort=no,
                   reverse_sort=no, >> shiftfile)

           #  make an input file for "cirmkobj" if using offset option
          
             leni=strlen(l_images)
             subim=substr(l_images, 2, leni)
             if (stridx(l_images, "@") == 1)
                fout2="o"//subim
             else
              {
                fout2="osetimage.in"
                print("Remember to rename osetimage.in\n")
              }
            
             fields (shiftfile, "3", lines="1-9999", quit_if_miss=no, 
                 print_file_n=no, >> fout2)

           # Calcuate the mean of xhift and yshift to decide the action of 
           # the offset in 'cirmkobj'

             cirmean(shiftfile2, shiftlog)

         }
	else     # this is from the if block "shift_found"
	    error (1, "No shifts were calculated.")

         
        # Cleaning up 
         if (l_coords=="none")
             delete (pdout1, ver-, >& "dev$null")
    
         print("   <<====== cirentroid DONE =====>>")

end

