# CIRBADPIX
#   function: Find out the 1st approximation bad pix coordinates and
#               badpix mask

task cirbadpix = t_cirbadpix

include <imhdr.h>  # macros related to the header information
include <error.h>  # macros related to the error handling
include <imio.h>   # macros related to the images I/O
include <ctype.h>  # macros related to character and string-related definations

procedure t_cirbadpix ()

pointer	sp              # pointer for memory stack
pointer im1, im2        # pointer to the address of the input and output image name
pointer template       #I pointer to the address of the name of the input list
pointer outfile        #O pointer to the address of the name of the output file
                            # of the badpix coordinates
pointer outimage       #I pointer to the address of the name of the output list
int inlist, outlist     # the list descriptors of the input and output list
real    valuet, valuel  # the values for good and bad pixels
real    lower, upper   #I the lower and upper limit of the replacement window
int     fd              # the file descriptor 

pointer	imtopen()       # function to open image template
pointer immap()         # function to open image, this returns a pointer type
                           # variable that is pointer to the address of the
                           # image descriptor
int	imtgetim()      # function to get next image name
int     imtlen()        # function for returning number of images in the list
int     open()          # function to open or create a text or binary file
real	clgetr()        # function to get the value of cl parameter

errchk	immap           #  when an error occurs in a procedure whose name is 
                         # listed in an ERRCHK statement, program execution in
                         #  the RETURN statement

begin

     # Mark the memory stack, this marks the beginning of the block 
     #    of memory to be referenced
	call smark (sp)

     # Allocate (stack memory) character buffers
      # SZ_FNAME: the maximum number of chars in a line (hlib$iraf.h)
      # TY_CHAR: the data type is character (hlib$iraf.h)
	call salloc (template, SZ_FNAME, TY_CHAR)
        call salloc (outimage, SZ_FNAME, TY_CHAR)
	call salloc (outfile, SZ_FNAME, TY_CHAR)

      # get a cl string parameters,; Memc[] passing memory buffer to the
       #  procedure
	call clgstr ("template", Memc[template], SZ_FNAME)
        call clgstr ("outimage", Memc[outimage], SZ_FNAME)
        call clgstr ("outfile", Memc[outfile], SZ_FNAME)
	lower = clgetr ("lower")
	upper = clgetr ("upper")

       # Allocate the input and output list descriptors 
	inlist = imtopen (Memc[template])
	outlist = imtopen (Memc[outimage])

       # Check the consistency of number of the input images and 
        # output images 
	if (imtlen (inlist) != imtlen (outlist))
        {
	    call imtclose (outlist)  # close the output image template
	    call imtclose (inlist)   # close the input image template
	    call sfree (sp)          # free all the memory
	    call error (1, "input and output lists don't match")
               # signal error condition (errtext cannot include \n)   
	}

        valuet = 1.0      #  bad  values
        valuel = 0.0      #  good values


       # error checking: 
        # IS_INDEFR: macros define functions to test values against indefinite
        # the ERRACT procedure allows a program to repost the error that
        # was caught by the IF block. If ERRACT is called with an argument
        # of EA_WARN, the error message is printed on the standard error stream
        # and execution of the program proceeds as usual
	if (IS_INDEFR(lower) || IS_INDEFR(upper))
	   call erract (EA_WARN)

     # Main processing loop. An image is processed in each pass through
     # the loop.
       # Get the "next" image name from the input list and output list
       # BOTH are NOT equal to EOF
	while (imtgetim (inlist, Memc[template], SZ_FNAME) != EOF &&
	    imtgetim (outlist, Memc[outimage], SZ_FNAME) != EOF) 
        {      
         # Open the input and output images; the 3rd argument of IMMAP
          #  procedure is the pointer to another image, already opened with
          #  another immap() call. It is used only if the access mode is 
          #  NEW_COPY and specifies a template image.
           # using IFERR to check the error and print the error message
	    iferr (im1 = immap (Memc[template], READ_ONLY, 0))
              {
		call eprintf ("Problem opening input image:\n") 
                    #formatted print to STDOUT
		call erract (EA_WARN)
		next  # shifts control to the next iternation of a loop,
                      # in this case: exit this condition
	      }
	    iferr (im2 = immap (Memc[outimage], NEW_COPY, im1))
              {
		call imunmap (im1)  # unmap an image
		call eprintf ("Problem opening output image:\n")
		call erract (EA_WARN)
		next
	      }

            # Open the output text file
               # NEW_FILE: mode is: to create a new file
               # TEXT_FILE: type is: File of lines of text
              iferr (fd = open (Memc[outfile], NEW_FILE, TEXT_FILE))
                call erract (EA_WARN)

             # call procedure MKBAD to make the badpix list and badpix image
	       call mkbad (im1, im2, fd, lower, upper)

               call close(fd)    # close the output file
	    call imunmap (im2)   # unmap (close) an output image
	    call imunmap (im1)   # unmap (close) an input image
	}   # this brace is from the while loop

	call imtclose (outlist)   # close the output image template
	call imtclose (inlist)    # close the input image template

       # Free the memory: it is not necessary (not possible) to free the 
        # individual memory buffers allocated using salloc().  However,
        # the stack pointe rshould be reset using sfree().
	call sfree (sp)       

end


# MKBAD
#  function -- make  a badpix mask and find out the bad pix coordinates
#               in a first approximation
#

procedure mkbad (im1, im2, fd, lower, upper)

pointer	im1, im2, 		# input & output image descriptors
real	lower, upper		# range to be replaced

long	v1[IM_MAXDIM], v2[IM_MAXDIM] #vectors with IM_MAXDIM dimension(imhdr.h)
pointer	buf1, buf2    #the buffer pointers
int	n             # the length of 
int     fd            # file descriptor
int     nline          # the number of line
real    valuel, valuet   # the values for replacements 

int	imgnlr()     # function to get next image line
int     impnlr()     # function to put next image line


begin

        valuel=1.0
        valuet=0.0
     
       # move a "long scalar = 1" into a vector v1 and v2 with dim = IM_MAXDIM
	call amovkl (long(1), v1, IM_MAXDIM)  
	call amovkl (long(1), v2, IM_MAXDIM)

	n = IM_LEN(im2,1)   # the length of the dim1 (dim x) of output image
         nline= 0
   
      call fprintf(fd,"     X     Y    pix value\n\n")
         while (imgnlr(im1,buf1,v1) != EOF && impnlr(im2,buf2,v2) != EOF)
           {
             nline = nline + 1
    
            # copy Memr[buf1] to Memr[buf2], replacing values <= floor 
            #  to "valuel"
	      call arler (Memr[buf1],Memr[buf2],n,lower,valuel,valuet,fd,nline)

            # copy Memr[buf1] to Memr[buf2], replacing values => ceiling
            #  to "valuet"
	      call arger (Memr[buf1],Memr[buf2],n,upper,valuel,valuet,fd,nline,
                    lower)
           }

end


# ARLER 
#  function -- Copy a to b, replacing values <= floor.
#
procedure arler (a, b, n, floor, newval, newval2, fd, nline)

real	a[ARB]			#I input array, arbitrary
real	b[ARB]			#O output array, arbitray
int	n, nline	        #I size of the arrays
real	floor                   #I replacement lower limit
real    newval                  #I replacament constant - lower limit
real    newval2	                #I replacement constant - upper limit
int	i                       #  dummy counter
int     fd                      #  file descriptor
int     ix                      #  counter 

begin

        ix = 0
	do i = 1, n     
          {
	    if (a[i] <= floor)
              {
                ix   = i
	 
        	b[i] = newval     # make the low value badpix equal to "newval"

               # record the location and value of the lower value badpix
                call fprintf(fd,"%6d%6d%10.2f\n") # formatted print 
                call pargi (ix)   # pass an integer argument to a printf()
                call pargi (nline) # pass an integer argument to a printf()
                call pargr (a[i])  # pass a real argument to a printf()
               }
	    else
		b[i] = a[i]  # make other values equal to pixels of input image
          }   # this brace is from do loop

end


# ARGER 
#  
#   function -- Copy a to b, replacing values >= ceiling.
#

procedure arger (a, b, n, ceiling, newval, newval2, fd, nline, floor)

real	a[ARB]			#I input array, arbitary
real	b[ARB]			#O output array, arbitary
int	n, nline	        #I size of the arrays
real	floor                   #I replacement lower limit
real    ceiling                 #I replacement upper limit
real    newval                  #I replacament constant - lower limit
real    newval2	                #I replacement constant - upper limit
int	i                       #  dummy counter
int     fd                      #  file descriptor
int     ix                      #  counter 

begin

        ix = 0
	do i = 1, n
         {
	    if (a[i] >= ceiling)       
             {
                ix = i
	 
                 b[i] = newval    # make the low value badpix equal to "newval"

              # record the location and value of the higher limit value badpix
                 call  fprintf(fd,"%6d%6d%10.2f\n")
                 call pargi (ix)
                 call pargi (nline)
                 call pargr (a[i])
             }
	    else
                if (a[i] >= floor)  # make the goodpix equal to "newval2"
		   b[i] = newval2

         } # this brace is from do loop

end



