# IRAF script -- cir4ddfdisp.cl
#	
#   functions:  to take a quick look at a field thru difference of 2 setsof
#                images
#              option: given 4 pair sets of images (4m=1,2,3, ...)
#                        to display 4m-diff-images into 4 different buffers
#                        based on the chip no
#
# programmer: sjchan 
#     history: 11mar98 -- created

#

procedure cir4ddisp(imglist1, imglist2, stat, telescope, answer)

string  imglist1 {"", prompt="@List1 of 4m input images",mode="ql"}
string  imglist2 {"", prompt="@List2 of 4m input images", mode="ql"}
bool  stat {yes, prompt="Display image statistics", mode="ql"}
string  telescope {"WHT", prompt="Telescope to be used(WHT/INT/none)", mode="ql"}
bool  answer {yes, prompt=">>> Next 4 diff-images?"}

struct *flist1, *flist2

begin
        string ftmpi1      #i input string containing list1 of images
        string ftmpi2      #i input string containing list2 of images
        string tel1        #i telescope to be used
        string ifile1      #i final version of the input list1
        string ifile2      #i final version of the input list2
        string framein1    #i image name from the input list1
        string framein2    #i image name from the input list2
        string ofile       #i dummp variables (never really use them)
        string ind         #  indicator (dummy variable)
        string frameout    # Output image 
        string chipno      #o chipno in string
        string quadno      #o quadno in string
        bool   sstat       # prompt display image statistics 
        int    frameno     # display frame buffer
        int    icount      # dummy counter
        int    naxis       # length of the axis
        real   dmag        # the display window magnification
        int    icc         # counter, 1,2,3,4
        int    icc2        # n-counter, icount = icc * icc2
        string dummy       # dummy variable

         cache imgets     # need this action due to a bug in imgets

      #  Get the rest of the parameters

        ftmpi1 = imglist1
        ftmpi2 = imglist2
        sstat  = stat
        tel1 = telescope
        frameno = 1
        ind = "DI"  # dummy definition
        ifile1 = mktemp("cddif1")
        ifile2 = mktemp("cddif2")
        ofile  = mktemp("cddof")  # dummy variable
        frameout = "diff.fits"
        dmag  = 0.5  # display window magnification, tile option (naxis = 512)
        chipno = "3"
        quadno = "1"
        dummy = "th"

      # Check the existence of the files
         if (access(frameout))
              imdelete(frameout, ver-, >& "dev$null")
         if (access(ifile1))
              delete(ifile1, ver-, >& "dev$null")
         if (access(ifile2))
             delete(ifile2, ver-, >& "dev$null")   
         if (access(ofile))
             delete(ofile, ver-, >& "dev$null")

      # Find out the suitable input option
         # for input list1
         _finout(ftmpi1, ind, ifile1, ofile) 
    
         # for input list2
          if (access(ofile))
            delete(ofile, ver-, >& "dev$null")
      
          _finout(ftmpi2, ind, ifile2, ofile)
 

       # Read the file ifile1, ifile2 containing the names of files
          icount = 0; icc = 0; icc2 = 0
          flist1 = ""; flist1 = ifile1
          flist2 = ""; flist2 = ifile2
          while( (fscan(flist1, framein1) != EOF) &&
                    (fscan(flist2, framein2) !=EOF) )
            {
               if (access(frameout))
                   imdelete(frameout, ver-, >& "dev$null")    

             # Obtaining the difference   
               unlearn imarith
               imarith(operand1=framein1, op="-", operand2=framein2,
                  result=frameout,  pixtype="real", calctype="real",
                  verbose=yes)  

             if (sstat)
              {
                 print("")
                 unlearn gstatistic
                 gstatistic(frameout, fields="doall")
               }  

             # Display the different image
              icount += 1
              icc += 1
       
            # try to get the chipno from the header
             imgets(framein1, param ="chip")
             chipno = imgets.value
             if ( (chipno == "") || (chipno == "0") || (chipno == "/") )
               {
                print("CHIPNO value is BAD in the header! Try filename")

                  _locchipno(framein1)
                  chipno = _locchipno.schipno
                  if (chipno == "0") 
                    {
                      print("**** Check your input data ****")
                       bye    # exit the program
                    }
                }   # this brace is from if else block (search chipno from 
                     # filename
             
               if (icount == 1)
                 {  # find out the size of the input image
                   imgets(framein1, param ="i_naxis1")
                   naxis = int(imgets.value)
                   if (naxis == 1024)
                         dmag = 0.25
                 }
             if (naxis == 1024)
               {
                 if (chipno == "1")
                   frameno = 2
                 if (chipno == "2")
                   frameno = 4
                 if (chipno == "3")
                   frameno = 3
                 if (chipno == "4")
                   frameno = 1
                 print("Chip ",chipno, " on frame ", frameno)
               }   #this brace is from if block (naxis = 1024)
             else      
               {  # quadrant-images (naxis = 512)
                 _qdispfno(frameout, icc, chipno, tel1)
                 frameno = _qdispfno.fno
                 quadno  = _qdispfno.sqno
               print("Chip ",chipno, " Quad ",quadno, " on frame ", frameno)
               } # this brace is from if else block (for naxis = 512)

             unlearn display
             display (frameout, frameno, xmag=dmag, ymag=dmag)
             print("")
             print("================================================")
      
             if (icc == 4)
               {
                 icc2 += 1
                 if ( (icc2 == 1)||(icc2 == 21)||(icc2 == 31) )
                    dummy = "st"
                 else if ( (icc2 == 2)||(icc2 == 22)||(icc2 == 32) )
                    dummy = "nd"
                 else if ( (icc2 == 3)||(icc2 == 23)||(icc2 == 33) )
                    dummy = "rd"
                 else
                    dummy = "th"

                 print("")
                 print(icc2,dummy," four images have been loaded")
                 print("You may use Tile frame option in Ximtool")
                 print("")
                 icc = 0  # reset icc to zero
                 if (answer == no)
                    break
               } # this brace is from if block(icc == 4)

        }   # this brace is from while block (flist1=ifile1, flist2=ifile2)

           # cleaning up
 
           flist1 = ""; flist2=""   #close the files
           delete(ifile1, ver-, >& "dev$null")
           delete(ifile2, ver-, >& "dev$null")
           delete(ofile, ver-, >& "dev$null")

end

