# IRAF script -- chip4disp
#      functions:
#           load 4 chip-images into 4 display buffers; user uses tile option
#              in ximtool
#           the chipno can obtain from header or from file name
#           option: to transpose 4-chip-images
#                    (now, only for WHT)
#          
#	
# programmer: sjchan
#     history: 10mar98 -- created
#              14may98 -- modified (for using INT option)
#

procedure chip4disp(frame_in, telescope)

string	frame_in     {"",prompt="List of (@ or *.fits) Input Images",mode="ql"}
string  telescope    {"WHT", prompt="Telescopes to be used (WHT/INT/none)", mode="ql"}

struct *flist

begin
        # Local variable declarations
          string  ftmpi        #i input string containing list of images
          string  tel          #i telscopes to be used
          string  framein      #i input image name from the given lista
          string  ifile        #i final version of the input list
          string  ifile2       #i final vesion of input list if use transpose
                                 # option
          string  ofile        #i dummp variable (never use it)
          string  ind          #  indicator (dummy variable)
          string  chipno       #o chipno in string
          int     frameno      # display frameno
          string  trans        #o transpose information from header
          int     i            # dummy counter
          int icount
          
          cache imgets   # need this action due to a bug in imgets
        
        # Get the rest of the parameters

          ftmpi = frame_in
          tel = telescope
          ind="DI"   # dummy definition
          ifile=mktemp("crtif") # only need ifile
          ofile=mktemp("crtof")  # dummy definition
          chipno=""
          frameno = 1
          icount = 0
          trans = ""

           if (access(ifile))
             delete(ifile, ver-, >& "dev$null")
           if (access(ofile))
             delete(ofile, ver-, >& "dev$null")

		
        #  Find out the suitable input option

           _finout(ftmpi, ind, ifile, ofile)

        #  Find out the images have been transposed

           i=0
           flist = ""; flist = ifile
           while (fscan(flist, framein) !=EOF)
             {
               i += 1
               imgets(framein, param="transpos")
               trans = imgets.value
               break  # jump out the loop
             } # this brace is from while block
           flist = "" # close the file     
 
        # option to transpose images
           if ((tel == "WHT") || (tel == "INT") )
             {
               if (trans == "TR")
                 {
                  ifile2 = mktemp("crtif2")
                  copy(ifile, ifile2, ver-)
                  print("These are transposed images")
                 }
               else
                 {
                   chiptrans("@"//ifile, tel)
                   ifile2 = "t"//ifile
                 }
             } # this brace is from tel == WHT or INT
            else
             {
               ifile2 = mktemp("crtif2")
               copy(ifile, ifile2, ver-)
             }  # this brace is from tel == none

           # Read the file 'ifile2' containing the names of files

           flist = "";      flist = ifile2
           while (fscan (flist, framein) != EOF)
            {
             icount += 1
             # try to get the chipno from the header
             imgets(framein, param ="chip")
             chipno = imgets.value
             if ( (chipno == "") || (chipno == "0") || (chipno == "/") )
               {
                print("CHIPNO value is BAD in the header! Try filename")

                  _locchipno(framein)
                  chipno = _locchipno.schipno
                  if (chipno == "0") 
                    {
                      print("**** Check your input data ****")
                       bye    # exit the program
                    }
                }   # this brace is from if else block (search chipno from 
                     # filename

                if (tel == "WHT")                
                  {
                     if (chipno == "1")
                       frameno = 2
                     if (chipno == "2")
                       frameno = 4
                     if (chipno == "3")
                       frameno = 3
                     if (chipno == "4")
                       frameno = 1

                     goto lab
                  } # this brace is from if block (tel == "WHT")
                if (tel == "INT")
                  {
                     if (chipno == "1")
                       frameno = 3
                     if (chipno == "2")
                       frameno = 1
                     if (chipno == "3")
                       frameno = 2
                     if (chipno == "4")
                       frameno = 4

                     goto lab
                  } # this brace is from if block (tel == "INT")
                if (tel == "none")
                  {
                    if (chipno == "1")
                       frameno = 1
                     if (chipno == "2")
                       frameno = 2
                     if (chipno == "3")
                       frameno = 4
                     if (chipno == "4")
                       frameno = 3

                     goto lab
                  } # this brace is from if block (tel == "none")

                 lab:              
                 print("Chip ",chipno, " on frame ", frameno)
                  unlearn display
                  display (framein, frameno, xmag=0.25, ymag=0.25)
      

            }   # this brace is from while block (flist, framein)

            flist = "" #close the file

        print("")
        print("Now you may use Tile Option in Ximtool Control Panel")
        print("")

        # Cleaning up 

       
        flist=""   # close the file
        delete(ofile, ver-, >& "dev$null")
        delete(ifile, ver-, >& "dev$null")
        delete(ifile2,ver-, >& "dev$null") 

end

