# IRAF script -- _chipplot.cl
#	
#   this is a main file management task which is a HIDDEN task.
#    user cannot use it in the front end.
#     plot the mean pixel value of an image v.s. time
#

# programmer: sjchan 
#      history: 5aug98 -- created
#              17aug98 -- modified: get iquad, ichip, and nframes from headers
#                          different line pattern, colour and markder 
#                          are based on the above information, 
#               
#

procedure _chipplot(plotlist, chipselect, ansrms, tquad, axislen, plot2)

string  plotlist   {"", prompt="Plotting list", mode="ql"}
bool    chipselect {yes, prompt="Overplot each chip and quadrant separately", mode="ql"}
bool  ansrms       {yes, prompt="Plot variance as function of average", mode="ql"}
int     tquad      {"", prompt="Total number of quadrants", mode="ql"}
string  axislen    {"", prompt="Length of axis", mode="ql"}
bool    plot2      {yes, prompt=">> Next plot?"}

struct *plist
struct *plist2

begin

        string  plotlist1      #i plotting list
        bool    chipselect1    #i  Overplot each quadrant
        bool    ansrms1
        int     tquad1         #i total number of quadrants
        string  axislen1       #i length of axis
        string  pmarker[16]        # marker (maximum choose 8*2)
        string  ppattern[4]       # line patterns ( 4 chooses)
        int     pcolor[16]        # color (4*4 chooses)
        string  snaxis              # length of axis
        int     tmpquad             # current quadrant number (1-dim)
        int     quadno              # quadrant number (2-dim)
        int     chipno              # chipno
        string  s2, s1, s3
        int ic, is1, i, j, k
        real xdata, ydata, zdata
        real xmax, xmin, ymax, ymin, zmax, zmin
        

      #  Get the rest of the parameters

        plotlist1 = plotlist
        chipselect1 = chipselect
        ansrms1 = ansrms
        tquad1 = tquad
        axislen1 = axislen
        s3 = "dummyplot.list"

      # set up the plotting attributes
         pltpar.crvstyle = "straight"
         dvpar.append = no

      # set up  markers
         pltpar.marker = "box"

         axispar.xlabel = csplatndr.keyword
         axispar.ylabel = csplatndr.avg

      # set up colors ( device and graphics kernel dependent)       
         pltpar.crvcolor = 1  #black
         for (i = 0; i <= 15; i += 4)
           {
             pmarker[1+i] = "plus"
             pmarker[2+i] = "diamond"
             pmarker[3+i] = "circle"
             pmarker[4+i] = "box"

             pcolor[1+i] = 1  #black --> white (on screen)
             pcolor[2+i] = 2  #white --> red (on screen)
             pcolor[3+i] = 3  #red   --> green (on screen)
             pcolor[4+i] = 6  #yellow

           } #this brace is from for block i=0,1, pmarker

       # set up line pattern       
         for (i = 0; i <= 4; i += 1)
            {
              ppattern[1] = "solid"
              ppattern[2] = "dashed"
              ppattern[3] = "dotted"  
              ppattern[4] = "dotdash"
            }

      # find the common xmax,xmain, ymax,ymin for axis (overplot case)
        xmin = 1.0e+8; xmax = 0.
        ymin = 1.0e+8; ymax = -1.0e+8
        zmin = 1.0e+8; zmax = -1.0e+8
        plist = ""; plist = plotlist1
        while(fscan(plist, s2) !=EOF)
          {
             count(s2) | scan(s1)
             is1 = int(s1)
             plist2 = ""; plist2 = s2
             while(fscan(plist2, xdata, ydata, zdata, tmpquad) !=EOF)
               {
                 xmin = min(xdata, xmin)
                 xmax = max(xdata, xmax)
                 ymin = min(ydata, ymin)
                 ymax = max(ydata, ymax)
                 zmin = min(zdata, zmin)
                 zmax = max(zdata, zmax)
               }
              plist2  = "" #close the file
          }
              plist = "" #close the file

          #plot average as function of time
            axispar.wl = xmin - 25.0
            axispar.wr = xmax + 25.0
            axispar.wb = ymin - 25.0
            axispar.wt = ymax + 25.0

            print ("")
            print ("Plotting graph... ", csplatndr.avg, " as function of ", 
                  csplatndr.keyword)
            print ("")



         ic = 0
         plist = ""; plist = plotlist1 #open the file
         while (fscan(plist, s2) != EOF)
           {
              if (access(s3))
                 delete(s3, ver-, >& "dev$null")

              plist2 = ""; plist2 = s2
              while(fscan(plist2, xdata, ydata, zdata, tmpquad) != EOF)
                     print(xdata, "\t", ydata, >> s3)

               plist2 = "" #close the file
               
             if (!chipselect1)
               sgraph (s3, pointmo=yes, szmarker=0.05) 
             else
               {
                ic += 1
                   if (ic > 1)
                      dvpar.append = yes

                if (ic <= 16)
                  {
                    pltpar.marker = pmarker[ic]
                    pltpar.crvcolor = pcolor[ic]
                  }
                if (tquad1 <= 4) 
                  {
                   pltpar.cycolor = no
                   for (k = 1; k <= 4; k += 1)
                     {
                       if ((tmpquad == k) || (axislen == "1024"))
                         {
                           pltpar.pattern = ppattern[k]
                           goto lab
                         }
                     }
                  } #this brance is from if-block (tquad <=4)
                else if (tquad1 > 4) # more than 1 chip
                  { 
                     pltpar.cycolor = yes 
                     for (k = 1; k <= 16; k += 4)
                       {
                          quadno = mod(tmpquad, 4)
                          if (quadno == 0) 
                               quadno = 4
                          chipno = (tmpquad - quadno)/4 + 1
                          
                          if ((tmpquad >=  k) && (tmpquad <= k+3))
                            { 
                              pltpar.pattern = ppattern[chipno]
                              goto lab
                            } #this brace is from if-block (tmpquad = k to k+3)
                       } #this brace is from for block (k = 1, 16, k += 4)

                  } #this brace is from if-else-block (tquad > 4)

                lab:
                sgraph (s3, pointmo=yes, szmarker=0.02) 
                sgraph(s3, pointmo=no)
                delete(s3, ver-, >& "dev$null")             
               }

          } # this brace is from while block (plist, s2)
         plist = "" #close the file

         if (ansrms1)
           { #need to plot one more figure: variance as function of average

             if (!plot2)
               goto lab3

               print ("")
               print ("Plotting graph... ",  " variance as function of ", csplatndr.avg)
               print ("")

             # need to reset to plotting attributes
              dvpar.append = no
              axispar.wl = ymin - 25.0
              axispar.wr = ymax + 25.0
              axispar.wb = zmin - 25.0
              axispar.wt = zmax + 25.0
        
              axispar.xlabel = csplatndr.avg
              axispar.ylabel = "variance"
              ic = 0
              plist = ""; plist = plotlist1 #open the file
              while (fscan(plist, s2) != EOF)
                {
                  if (access(s3))
                    delete(s3, ver-, >& "dev$null")

                  plist2 = ""; plist2 = s2
                  while(fscan(plist2, xdata, ydata, zdata, tmpquad) != EOF)
                        print(ydata, "\t", zdata, >> s3)

                  plist2 = "" #close the file
               
                  if (!chipselect1)
                     sgraph (s3, pointmo=yes, szmarker=0.05) 
                  else
                    {
                      ic += 1
                      if (ic > 1)
                         dvpar.append = yes

                      if (ic <= 16)
                        {
                          pltpar.marker = pmarker[ic]
                          pltpar.crvcolor = pcolor[ic]
                        }
                      if (tquad1 <= 4) 
                        {
                          pltpar.cycolor = no
                          for (k = 1; k <= 4; k += 1)
                            {
                              if ((tmpquad == k) || (axislen == "1024"))
                                {
                                  pltpar.pattern = ppattern[k]
                                  goto lab2
                                }
                            } #this brace is from for-block (k=1,2,3,4)
                         } #this brace is from if-block (tquad <=4)
                       else if (tquad1 > 4) # more than 1 chip
                         { 
                           pltpar.cycolor = yes 
                           for (k = 1; k <= 16; k += 4)
                             {
                               quadno = mod(tmpquad, 4)
                               if (quadno == 0) 
                                  quadno = 4
                               chipno = (tmpquad - quadno)/4 + 1
                          
                               if ((tmpquad >=  k) && (tmpquad <= k+3))
                                 { 
                                   pltpar.pattern = ppattern[chipno]
                                   goto lab2
                                 } #this brace is from if-block (tmpquad = k to k+3)
                             } #this brace is from for block (k = 1, 16, k += 4)

                        } #this brace is from if-else-block (tquad > 4)

                    lab2:
                    sgraph (s3, pointmo=yes, szmarker=0.02) 
                    sgraph(s3, pointmo=no)
                    delete(s3, ver-, >& "dev$null")             
                 }#this brace is from if-else block (chipselect1 == yes)

              } # this brace is from while block (plist, s2)
              plist = "" #close the file
 
           } #this brace is from if-block (ansrms1 == yes)
           lab3:
           i = 0
           

end

