# IRAF script: photrans_log
#
#  gets gain from CIRSI data using photon transfer method.
#  10-12-98: this version plots on log. scales
#   no automatic gain determination yet.
#
#  Mike Hoenig, December '98


procedure photrans_log (runno1, runno2)

string runno1   {prompt="First run number to use"}
string runno2   {prompt="Second run number to use (NB. must be same no. of files)"}
string chipquad {"c1q2", prompt="Chip and quadrant (eg. 'c1q2')"}
string avg      {"mean", prompt="Type of average to be used by GSTAT",
                 enum="mean|midpt|mode"}
string xrang   	{"*", prompt="Range of x-coordinates to be used"}		 
string yrang   	{"*", prompt="Range of y-coordinates to be used"}		 
bool deleteim	{yes, prompt="Delete temporary image files?"}

begin


    # Define local variables

    string l_runno1  	    # run no. 1
    string l_runno2  	    # run no. 2
    string l_chipquad	    # chip, quadrant
    string l_avg	    # GSTAT average to use
    bool l_deleteim 	    # delete images at end?
    string l_xrang  	    # x range
    string l_yrang  	    # y range

    file imglist1  	    # filename of 1st list of images
    file imglist2  	    # filename of 2nd list of images
    file imglist1_2  	    # filename of 1st and 2nd list of images (pasted together)
    string immask1  	    # expression for 1st list of images
    string immask2  	    # expression for 2nd list of images
    int noimages1  	    # no. of input images - 1
    int noimages2  	    # no. of input images - 2
    string imgname1 	    # name of input image in 1st list
    string imgname2 	    # name of input image in 2nd list
    int i1  	    	    # integer used for substringing in the filename
    int i2  	    	    # dto.
    string rootimgname1     # the image filename, without the prefix
    string rootimgname2     # dto. for run no. 2
    string plusname 	    # the output name of the imarith + file
    string minusname	    # the output name of the imarith - file
    file plusnamlist	    # list of output + names
    file minusnamlist	    # dto. for -
    string imgname  	    # temp. file for scanning for filenames
    real imavg  	    # temp. file for taking image averages
    real avg_div_2   	    # the above divided by 2
    string datafilexaxis    # output values for x axis of plot
    string datafileyaxis    # output values for y axis of plot
    real standdev   	    # the std. dev. from the - images
    file datafile	    # the final data file (for plotting)
    string lab_x     	    # x-axis label (complex string concatenation possible)
    string lab_y     	    # y-axis label
    string lab_title	    # title of graph
    string imgname_sec	    # the image name string, including the [X:X,X:X] info
    real standdev_sqrt2     # std.dev. divided by sqrt2
    
    
    l_runno1 = runno1
    l_runno2 = runno2
    l_chipquad = chipquad
    l_avg = avg
    l_deleteim = deleteim
    l_xrang = xrang
    l_yrang = yrang


    # Make sure STSDAS is loaded (needed for GSTAT)

    if (!defpac("stsdas"))
    	{
    	stsdas motd-
    	}


    imglist1="filenames1.list"
    imglist2="filenames2.list"
    imglist1_2="filenames1_2.list"
    if (access(imglist1)) delete (imglist1, ver-, >& "dev$null")
    if (access(imglist2)) delete (imglist2, ver-, >& "dev$null")
    if (access(imglist1_2)) delete (imglist1_2, ver-, >& "dev$null")
    
    # The following construction is the best I could do, the only thing it doesn't
    # catch is files without _any_ prefix - which should hopefully be a thing of the
    # past anyway.
    
    immask1="*_"//l_runno1//"_"//l_chipquad//"_???.fits"
    immask2="*_"//l_runno2//"_"//l_chipquad//"_???.fits"
    
    sections (immask1, option="fullname", > imglist1)
    noimages1 = sections.nimages
    sections (immask2, option="fullname", > imglist2)
    noimages2 = sections.nimages
    
    if (noimages1!=noimages2)
    	{
	print ("")
	print ("ERROR: There seems to be a mismatch between the number of images")
	print (" for each run number!")
        print ("run no. "//l_runno1//": "//noimages1//" images")
        print ("run no. "//l_runno2//": "//noimages2//" images")
        print ("Please check your input files again...")
	print ("")
	beep
	bye
	}

    print ("")
    print ("No. of images per run number is: ", noimages2)
    print ("")

    # Do the various imarith stuff
    
    # cheeky me, I just dropped to the shell to run paste - or does anyone know a
    # way in IRAF to concatenate two lists in parallel?
    
    !paste filenames1.list filenames2.list > filenames1_2.list

    print ("Performing imarith's ...")
    
    plusnamlist="photrans_plusnames.list"
    minusnamlist="photrans_minusnames.list"
    if (access(plusnamlist)) delete (plusnamlist, ver-, >& "dev$null")
    if (access(minusnamlist)) delete (minusnamlist, ver-, >& "dev$null")

    list=imglist1_2
    while (fscan (list, imgname1, imgname2) != EOF)
        {
	print ("Now processing images: ", imgname1, " and ", imgname2)
	
        # clever construction (and it works too!) to get rid of the file prefix:
	# 1. get first char. in run no. and its position in the filename
	
	i2 = stridx (substr(l_runno2, 1, 1), imgname2)
	
	# 2. then lift out the substring of the filename starting with the run no.
	
	rootimgname2=substr(imgname2, i2, (strlen(imgname2)))
	
	# same again for other image:

	i1 = stridx (substr(l_runno1, 1, 1), imgname1)
	rootimgname1=substr(imgname1, i1, (strlen(imgname1)))
	
	# now JUST DO IT
	
	plusname="photrans_"//l_runno1//"+"//rootimgname2
	minusname="photrans_"//l_runno2//"-"//rootimgname1
	if (access(plusname)) delete (plusname, ver-, >& "dev$null")
	if (access(minusname)) delete (minusname, ver-, >& "dev$null")
	
	imarith (imgname1, "+", imgname2, plusname)
	print (plusname, >> plusnamlist)
	
	imarith (imgname2, "-", imgname1, minusname)
	print (minusname, >> minusnamlist)
	}
    
    print ("imarith's done.")

    # Now get some image statistics with gstat

    print ("")
    print ("Performing image statistics ...")

    datafilexaxis="photrans_data.x"
    datafileyaxis="photrans_data.y"
    if (access(datafilexaxis)) delete (datafilexaxis, ver-, >& "dev$null")
    if (access(datafileyaxis)) delete (datafileyaxis, ver-, >& "dev$null")

    # Now, get (A + B) / 2 from the + images...

    list=plusnamlist
    while (fscan (list, imgname) != EOF)
    	{
    	imgname_sec=imgname//"["//l_xrang//","//l_yrang//"]"

	gstatistics (imgname_sec, fields=l_avg, >& "dev$null")
	
    	# note rather clumsy construction here. better would be:
	# imavg = gstpar.//l_avg or something. but that doesn't seem to work!
	
        if (l_avg=="mean") imavg=gstpar.mean
        if (l_avg=="midpt") imavg=gstpar.midpt
        if (l_avg=="mode") imavg=gstpar.mode
	
	avg_div_2 = imavg / 2
	
	print (avg_div_2, >> datafilexaxis)
	}
	
    # ...and the noise thing from the - images.
    
    list=minusnamlist
    while (fscan (list, imgname) != EOF)
    	{
    	imgname_sec=imgname//"["//l_xrang//","//l_yrang//"]"

    	gstatistics (imgname_sec, fields="stddev", >& "dev$null")
	
	standdev = gstpar.stddev
	
	# divide by sqrt2, need to account for the fact that 2 images were used:
	standdev_sqrt2 = standdev/1.4142
	
	print (standdev_sqrt2, >> datafileyaxis)
	}
	
    # Now, just paste those two datafiles together again...
    
    datafile="photrans_data.list"
    if (access(datafile)) delete (datafile, ver-, >& "dev$null")
    
    !paste photrans_data.x photrans_data.y > photrans_data.list
    
    # ...and plot them with sgraph!
    
    print ("")
    print ("Plotting ...")
        
    # Create labels:
    lab_x=l_avg//" of (("//l_runno1//" + "//l_runno2//") / 2)"
    lab_y="(std.dev. of ("//l_runno2//" - "//l_runno1//")) / sqrt.2"
    lab_title="Run nos. "//l_runno1//" & "//l_runno2//" "//l_chipquad//" "//"["//l_xrang//","//l_yrang//"]"
    
    sgraph (datafile, device="stdgraph", append=no, fill=yes, pointmo=yes, 
    	    marker="circle", szmarke=7, wl=0, wr=0, wb=0, wt=0, logx=yes,
	    logy=yes, box=yes, grid=no, ticklab=yes, xlabel=lab_x, ylabel=lab_y,  
	    title=lab_title, sysid=yes)
    
    # Clean up
    
    print ("")
    print ("Cleaning up ...")
    
    if (l_deleteim)
    	{
	imdelete("@"//plusnamlist, ver-, >& "dev$null")
	imdelete("@"//minusnamlist, ver-, >& "dev$null")
	}
    delete (imglist1, ver-, >& "dev$null")
    delete (imglist2, ver-, >& "dev$null")
    delete (imglist1_2, ver-, >& "dev$null")
    delete (plusnamlist, ver-, >& "dev$null")
    delete (minusnamlist, ver-, >& "dev$null")
    delete (datafilexaxis, ver-, >& "dev$null")
    delete (datafileyaxis, ver-, >& "dev$null")
    
    print ("")    


end
