## Meghan Gray, August 12 1998
## 
## makes a 2nd pass median sky image from 1st pass sky-subtracted frames
##  using object masks created by task mymakeobjmask (from phiirs)
## 
## also subtracts this 2nd pass sky from original object images
##
##  uses mymakeobjmask (modified by meg from phiirs package)
##
##  23/10/98 --	changed 'mymakeobjmask' to 'makeobjmask' as phiirs
##		now supports fits files
##  28/01/98 -- mhoenig changed package name from 'cirsi' to 'cirdr'!

procedure skytwo(inputlist,skyout)

string inputlist	{"", prompt="list of input images"}
string skyout		{"sky", prompt="name of sky image"}
bool   makemask         {yes, prompt="make object masks?"}
bool   makesky          {yes, prompt="make medianed sky?"}
bool   subsky           {yes, prompt="subtract medianed sky?"}
string *oldlist=""      {prompt = "ignore this!"}

begin
	string images,badmask,sky
	string s1,img,suff,newimg,final
        string newname
        string oldname
        

	images = inputlist
	sky    = skyout

        if(access("_tmp.list")  ) delete("_tmp.list",ver-)
	if(access("_in.list")   ) delete("_in.list", ver-)
        if(access("_mask.list") ) delete("_mask.list", ver-)
	if(access("_image.list")) delete("_image.list", ver-)
        if(access("_pass2.list") ) delete("_pass2.list",ver-)
	files(images,>>"_tmp.list")
	suff="objmask"

#   _in.list    = list of input 1st pass sky-subtracted images (s*.fits)
#   _mask.list  = list of bad pixel maps to be created
#   _image.list = list of non sky-subtracted images (t*.fits)
#   _pass2.list = list of non sky-subtracted images for input into csubsky
#                (same images as _image.list, but with different names
#                 so that first pass sky subs aren't overwritten)


        if (!defpac("phiirs"))
            phiirs
        if (!defpac("cirdr")){
	    cirdr
	    cqlook
	    cpreproc
	}

# create the appropriate input lists 
	list="_tmp.list"
        print("\nThese are the images to be processed: ")
	while (fscan(list,s1) !=EOF) {
	    i = strlen(s1)
	    img=subst(s1,1,i-5)
	    print(img)
	    files(img,>>"_in.list")
	    
	    badmask=img//suff//".pl"
	    files(badmask,>>"_mask.list")
	    
	    i = strlen(img)
	    newimg = substr(img,2,i)
	    files(newimg//".fits",>>"_image.list")
	    files("2"//newimg//".fits",>>"_pass2.list")
	    
	}
        print("")

# make the object masks from first-pass sky subtracted images
#  and update BPM keyword in non-sky subtracted images

	copy("_image.list","tmpfoo.list")
	if(makemask) {
	    list="_mask.list"
	    while(fscan(list,s1) != EOF) {
		if(access(s1)) delete(s1, ver-)
            }
	    print(" \nWe will now make the object masks!")
	    makeobjmask("@_in.list", suffix=suff, headlist="@_image.list",
	    subsample=1, filtsize=15, nsmooth=3, threshtype = "nsigma",
	    nsigthresh=2., constthresh=0., ngrow=3, statsec= "",
	    checklimits=yes, zmin=-32767., zmax=32767., inv=no, verbose=yes)
	}
	copy("tmpfoo.list","_image.list")
	delete("tmpfoo.list")

# make the 2nd pass sky image from non-sky subtracted images and object masks

	if(makesky) {
	    if(access(sky)) imdelete(sky,ver-)
	    print(" \nWe will now create a medianed sky image! ")
	    imcombine("@_image.list", sky, combine="median", reject="none",
	    project=no, outtype="real", offset="none", masktype="badvalue",
	    maskvalue=1., blank=0, scale="median", zero="none", weight="none",
	    expname="", statsec="", nlow=0.1, nhigh=0.2, logfile="STDOUT")
	}

# copy the input images to temporary names and subtract the sky image
	if(subsky) {
	    list="_pass2.list"
	    oldlist = "_image.list"
	    print("\nMaking temp copies of images for sky subtraction")
	    while(fscan(list,newname) != EOF && fscan(oldlist,s1) != EOF) {
		if (access(newname)) 
		print(newname, ":  image already exists")
		else
		imcopy(s1,newname)
	    }
	    print("\n   We will now subtract the medianed sky image!")
	    csubsky("@_pass2.list",sky)
	    delete("@_pass2.list")
	}

end


