# 23/10/98 -- obsolete;  new version of phiirs supports .fits files
# modified by meg 12/8/98 -- changed *.imh suffixes to *.fits
#
# makeobjmask.cl -- Create object masks for input images.   
#
# Image is sky subtracted, either using a constant value, or optionally by
# median filtering the image on a specified spatial scale and subtracting 
# filtered image.   If the desired filtering scale is large, the user may want
# to first subsample the image to a smaller size before filtering in order to 
# speed up the calculation -- the resulting sky frame is then block replicated 
# back up to the original image size before subtracting.
#
# After sky subtraction, a threshold is applied to the image after optional
# boxcar smoothing.  The threshold may be specified in terms of a number of sky
# sigma above the median sky level as measured using iterative sigma rejection,
# or as a specified constant number of ADU above the sky level.  The resulting 
# thresholded image is turned into a mask with "sky" set to 0 and "objects" set
# to 1.  The user may "grow" additional rings of pixels around masked regions 
# to increase their area.
#
# Finally, the resulting mask may optionally be recorded in the input image 
# header keywords BPM and OBJMASK.  The user may in fact create a mask from one 
# input image and add it into the header of another by specifying different 
# lists for inlist and headlist.
#
# 950208: renamed makeobjmask.  Switched output prefix to suffix.
# 950314: adjusted use of "sections" task
# 950324: added "invert" option here instead of in mkobjmask.cl

procedure makeobjmask(inlist)

string	inlist		{prompt="Image(s) to mask"}
string	suffix		{"objmask",prompt="Suffix for mask files."}
string	headlist="!default" {prompt="Image(s) to which to add BPM cards"}
int subsample  {1,min=0,prompt="Block averaging factor before median filtering"}
int	filtsize {15,min=0,prompt="Median filter size for local sky evaluation"}
int	nsmooth	{3,min=0,prompt="Scale for boxcar smothing before thresholding"}
string	threshtype  {"nsigma",enum="nsigma|constant",prompt="Thresholding type: nsigma or constant"}
real	nsigthresh	{2.,prompt="Threshold for masking in sky sigma"}
real	constthresh	{0.,prompt="Constant threshold above sky for masking"}
int	ngrow	 {0,min=0,prompt="Width of rings to grow around masked objects"}
string	statsec	  {"",prompt="Image region to use for computing sky statistics"}
bool  checklimits  {yes,prompt="Check min and max pix values before filtering?"}
real	zmin		{-32767.,prompt="Minimum data value for fmedian"}
real	zmax		{32767.,prompt="Minimum data value for fmedian"}
bool	inv		{yes,prompt="Invert output mask so objects are zero?"}
bool	verbose		{yes,prompt="Verbose output?"}
struct	*imglist
struct	*imglist2

begin

string	inl,check,inh
int	nbox,narea
int	ix,iy
real	thresh, dmin, dmax, realsize
string	infile, img, workimg
string	infile2, img2
string	cutsec

# Get query parameter.
	inl = inlist
	inh = headlist

# Check validity of boxcar smoothing scale.

	if (nsmooth > 0) {
		if (2*int(nsmooth/2) == nsmooth) { # i.e. if nsmooth is even...
	print ("ERROR:  parameter nsmooth should be set to an odd value.")
			return
		}
	}
		

# Notify user of effective median filter scale.

	if (subsample > 1 && filtsize > 0) {
		realsize = subsample * filtsize
      print ("After subsampling image, effective median filter scale will be ",
			realsize)
	}

# Size for boxcar smoothing in growing stage.

	nbox = (2*ngrow + 1)
	narea = nbox * nbox

# Expand input file list.
	infile = inl
	check = substr(infile,1,1)
	if(check=="@") {
		infile=substr(inl,2,strlen(inl))
	}
	else {
		infile =  mktemp("tmp$makeobjmask")
		print(inl,>>infile)
	}
	imglist = infile

#	infile =  mktemp("tmp$makeobjmask")
#	sections (inl,option="fullname",>infile)
#	imglist = infile

# If parameter headlist != "", update image headers with bad pixel list.

	if (headlist != "") {
		infile2 = headlist
		check = substr(infile2,1,1)
		if(check=="@") {
			infile2=substr(inh,2,strlen(inh))
		}
		else {
			if(check=="!") {
				infile2=infile
			}
			else {
				infile2 =  mktemp("tmp$makeobjmask")
				print(inh,>>infile2)
			}
		}
		imglist2 = infile2
#		infile2 =  mktemp("tmp$makeobjmask")
#		sections (headlist,option="fullname",>infile2)
#		imglist2 = infile2
	}

# Loop through input files.

	while (fscan(imglist,img) != EOF) {

# Strip ".imh" extension off filename if present.

		fileroot (img,validim+)
		img = fileroot.root

if (verbose) print ("  Working on image ",img,"-------------------------------")
	
		if (verbose) print ("     Subtracting local sky.")

# If filtsize > 0, median filter image to produce local sky, then subtract 
# that from the image.

		if (filtsize > 0) {

# 	If subsample > 1, block average input image to smaller size.

		  if (subsample > 1) {
			if (verbose) print ("        Block averaging.")
		blkavg (img,"_blk_"//img,subsample,subsample,option="average")
			workimg = "_blk_"//img
		   } else {
			workimg = img
		  }

# First, check limits of data range.  Wildly large (positive or negative) data 
# values will screw up fmedian calculation unless checklimits = yes and zmin 
# and zmax are set to appropriate values, e.g. zmin=-32768, zmax=32767.   
# Note that the old fmedian bug which occurred if zmin=hmin and zmax=hmax 
# has been fixed in IRAF version 2.10.1.

		  if (verbose) print ("        Median filtering sky.")
		  if (checklimits) {
			  minmax (workimg,force+,update+,ve-)
		  if (verbose) print("     Data minimum = ",minmax.minval,
					" maximum = ",minmax.maxval)
		  }
	  if (checklimits && (minmax.minval < zmin || minmax.maxval > zmax)) {
			if (minmax.minval < zmin) {
				dmin = zmin
			   } else { 
				dmin = minmax.minval
			}
			if (minmax.maxval > zmax) {
				dmax = zmax
			   } else { 
				dmax = minmax.maxval
			}
	if (verbose) print ("     Truncating data range ",dmin," to ",dmax)
		fmedian (workimg,"_fmed_"//workimg,xw=filtsize,yw=filtsize,
			 boundary="nearest",hmin=-32768,hmax=32767,
			 zmin=dmin,zmax=dmax,>&"dev$null")
		   } else {
fmedian (workimg,"_fmed_"//workimg,xw=filtsize,yw=filtsize,boundary="nearest",
	 hmin=-32768,hmax=32767,zmin=INDEF,zmax=INDEF,>&"dev$null")
		  }

# If we have block averaged, block replicate median filtered image back to original size.

		  if (subsample > 1) {
			if (verbose) print ("        Block reproducing.")
		blkrep ("_fmed_"//workimg,"_fmed_"//img,subsample,subsample)
			imgets(img,"i_naxis1")
			ix = int(imgets.value)
			imgets(img,"i_naxis2")
			iy = int(imgets.value)
			cutsec = "[1:"//ix//",1:"//iy//"]"
			imcopy ("_fmed_"//img//cutsec,"_fmed_"//img,ver-)
		  }

		  imarith (img,"-","_fmed_"//img,"_mask_"//img)

		} else {

# ...or, just copy the image to a working mask frame.

		  imcopy (img,"_mask_"//img)

		}

# Calculate image statistics to determine median sky level and RMS noise.

		if (verbose) print ("     Computing sky statistics.")
		iterstat ("_mask_"//img//statsec,verbose=verbose,print=verbose)
		if (nsmooth > 0) {
		if (verbose) print ("     Smoothing image before thresholding.")
			boxcar ("_mask_"//img,"_mask_"//img,nsmooth,nsmooth)
		}

# Calculate threshold.

		if (threshtype == "constant") {
			thresh = iterstat.median + constthresh
		   } else {
			thresh = iterstat.median + nsigthresh * iterstat.sigma
		}
		if (verbose) print ("     Thresholding image at level ",thresh)

# Apply threshold to image, setting "objects" to 1 and "sky" to 0.
# The order of the imreplace statments must be different if threshold is
# greater than or less than 1.

                if (thresh >= 0.) {
#                 imreplace ("_mask_"//img//".imh",0.,upper=thresh,lower=INDEF)
                  imreplace ("_mask_"//img//".fits",0.,upper=thresh,lower=INDEF)
#                 imreplace ("_mask_"//img//".imh",1.,lower=thresh,upper=INDEF)
                  imreplace ("_mask_"//img//".fits",1.,lower=thresh,upper=INDEF)
                 } else if (thresh < 0.) {
#                  imreplace ("_mask_"//img//".imh",1.,lower=thresh,upper=INDEF)
                  imreplace ("_mask_"//img//".fits",1.,lower=thresh,upper=INDEF)
#                 imreplace ("_mask_"//img//".imh",0.,upper=thresh,lower=INDEF)
                  imreplace ("_mask_"//img//".fits",0.,upper=thresh,lower=INDEF)
                }

# Copy mask to .pl file.

		if (verbose) print ("     Saving mask as ",img//suffix//".pl")
		imcopy ("_mask_"//img,img//suffix//".pl",ve-)

# If desired, grow rings around masked objects.

		if (ngrow > 0) {
		if (verbose) print ("     Growing rings around masked objects.")
		imarith (img//suffix//".pl","*",narea,img//suffix//".pl")
		boxcar  (img//suffix//".pl",img//suffix//".pl",nbox,nbox)
		imreplace (img//suffix//".pl",1,lower=1,upper=INDEF)
		}

# Invert mask if desired.
		if (verbose) print ("     Inverting mask so objects=zero.")
		if(inv)minv(img//suffix//".pl",img//suffix//".pl")

# Record mask name into BPM keyword in image header of files specified 
# by inlist2.

		if (headlist != "") {
	if (fscan(imglist2,img2) != EOF) {
        if(verbose)print("     Recording pixel mask into header of image ",img2)
	hedit(img2,"BPM",img//suffix//".pl",add+,ver-,update+,show-)
	hedit(img2,"OBJMASK",img//suffix//".pl",add+,ver-,update+,show-)
	}	
		}

# Clean up.
		if (filtsize > 0) {
#			imdelete ("_fmed_"//img//".imh",ve-)
			imdelete ("_fmed_"//img//".fits",ve-)
			if (subsample > 1 ) {
#				imdelete ("_blk_"//img//".imh",ve-)
				imdelete ("_blk_"//img//".fits",ve-)
# 				imdelete ("_fmed_"//workimg//".imh",ve-)
				imdelete ("_fmed_"//workimg//".fits",ve-)
			}
		}
#		imdelete ("_mask_"//img//".imh",ve-)
		imdelete ("_mask_"//img//".fits",ve-)

	}

#	delete (infile,ver-)
#	if (headlist != "" && check != "!") delete (infile2,ver-)
	imglist = ""
	imglist2 = ""

end

