procedure image_focus (images, nstep, focstart, focstep, scale, usesrtd)

string images 	{prompt="List of focus images"}
int nstep	{7,prompt="Number of focus steps"}
real focstart	{prompt="Starting focus value in mm"}
real focstep	{prompt="Focus increment in mm"}
real scale	{0.42,prompt="Image scale in arcsec per pixel"}
bool usesrtd	{no,prompt="Are you using the Sparc Real-Time Display?"}
struct *infd	{prompt="Leave this one alone"}
struct *curvfd	{prompt="Leave this one alone"}

begin

	string original1, imlist, listin
	string dum1, dum2, dum3, dum4, dum5, dum6, dum7, dum8, dum9
	string dum10, dum11, dum12, dum13, xin, yin, zin
	string output1, output2, namein, focstr, dirp, gapp, letr, key
	real x, y, z, xprev, yprev, pscl, dumfoc
	real dx1, dy1, dx2, dy2 
	real d1, d2, d3, d4, d5, d6, d7, d8
	real f0, df, fadd, fx
	int i,j, nimg, steps, knohead, kmeter
	int nmark, pixstep, code, iwcs

# make sure needed packages are loaded
if (! defpac ("nmisc")) {
	print ("nmisc package not loaded")
	bye
	}
if (! defpac ("utilities")) {
	print ("utilities package not loaded")
	bye
	}
if (! defpac ("proto")) {
	print ("proto package not loaded")
	bye
	}

if (usesrtd) {
   print(" ")
   print("  If you are using the SRTD")
   print("  IT IS YOUR RESPONSIBILITY TO BE SURE THAT THE CORRECT")
   print("  FOCUS IMAGE IS VISIBLE ON THE SRTD TOOL BEFORE STARTING")
   print("  THIS TASK.  IF THE CORRECT IMAGE IS NOT VISIBLE:")
   print("      PUT MOUSE CURSOR IN IMAGE DISPLAY WINDOW AND ")
   print("      HIT - q - WITHOUT MARKING ANY STARS.  ")
   print("      THEN DISPLAY THE IMAGE AND RESTART THIS TASK")
   print(" ")
}

# change input parameters to local variables

imlist = images
f0 = focstart
df = focstep
steps = nstep
pscl = scale

# check for dreg copies of old working files
if (access("tmp_coord1")) {
   delete ("tmp_coord1", go_ahead+, verify-, >& "dev$null")
}
if (access("tmp_coord2")) {
   delete ("tmp_coord2", go_ahead+, verify-, >& "dev$null")
}
if (access("tmp_results")) {
   delete ("tmp_results", go_ahead+, verify-, >& "dev$null")
}
if (access("tmp_outlist")) {
   delete ("tmp_outlist", go_ahead+, verify-, >& "dev$null")
}
if (access("tmp_curvdump")) {
   delete ("tmp_curvdump", go_ahead+, verify-, >& "dev$null")
}

# read headers of input images to see if TELFOCUS entry present
# if entry not present, imgets will return value of "0" (string); in
# that case, add TELFOCUS to header with value computed from input parameters
# --or if TELFOCUS present but < 1.0, assume it's in meters and convert it
# to millimeters
fadd = f0
listin = mktemp ('tmp$ims')
files (imlist, sort-, > listin)
infd = listin
nimg = 0
kmeter = 0
knohead = 0
while ( fscan (infd, namein) !=EOF ) {
   imgets (namein, "TELFOCUS", >& "dev$null")
   dumfoc = real(imgets.value)
   if ( dumfoc < 0.00001 ) {
	hedit (images=namein, fields='TELFOCUS', value=fadd,
	   add+, delete-, verify-, show+, update+)
	knohead = 1
   } else if (dumfoc < 1.0) {
	fadd = dumfoc*1000.0
	hedit (images=namein, fields='TELFOCUS', value=fadd,
	   add+, delete-, verify-, show+, update+)
	kmeter = 1
   }
   fadd = fadd + df
   nimg = nimg + 1
}

# print warnings about headers
if (knohead > 0) {
   print("WARNING: could not find header parameter TELFOCUS in original")
   print("images.  Added values for TELFOCUS to image header(s) in units")
   print("given in task parameters")
}
if (kmeter > 0) {
   print("WARNING: found values < 1.0 for header parameter TELFOCUS.")
   print("Assuming these are in meters.  These header values HAVE BEEN")
   print("OVERWRITTEN with the same quantities -- in millimeters -- ")
   print("because the telescope focus settings are given in millimeters.")
}

infd=listin
# display the first (or only) image
if ( fscan (infd, namein) !=EOF ) {
   print("Displaying image ", namein)
   if (!usesrtd) {
	display (namein, fr=1)
	}
}
#TEST FOR SRTD

# now do the focus testing: more than 1 image, assume no multiple exposures

if (nimg > 1) {
   print("  ")
   print("Put mouse cursor in image display window...")
   print("Mark star(s) to measure with keystroke - a - ")
   print("After each marking wait for the image cursor to return before")
   print("   hitting another key.")
   print("With mouse cursor still in image display - Hit - q - to quit.")
   print("  ")

# read image cursor positions into a file
while (fscan (imcur, x, y, iwcs, key) != EOF) {
	if (substr(key,1,1) == "a") {
	   print (x, y, >> "tmp_coord1")
	} else if (substr(key,1,1) == "q") {
	   break
	} else {
	   beep
	}
}

# first check that a sensible number of stars has been marked
   if (!access("tmp_coord1")) {
	print("You have marked NO stars!")
	print("You must mark at least 1 star!")
	print("Exiting...")
	bye
   }

   curvfd = "tmp_coord1"
   nmark = 0
   while (fscan (curvfd, x, y) != EOF) {
	nmark = nmark + 1
   }
   if (nmark < 1) {
	print("You MUST mark at least 1 star!")
	print("Exiting...")
	bye
   }

   print("Starting starfocus...")
   print("Wait a while...")
   print("When graphics cursor appears in graphics window---")
   print("move mouse cursor to that window and hit - q - to quit")
   print("  ")
   starfocus (images=imlist, focus="TELFOCUS", nexposures=1, coords="mark1",
     display-, frame=1, level=0.5, size="GFWHM", beta=INDEF, 
     scale=pscl, radius=5.0, sbuffer=5.0, swidth=5.0, saturation=60000.0, 
     ignore_sat-, iterations=2, xcenter=INDEF, ycenter=INDEF, logfile="", 
     imagecur="tmp_coord1", graphcur="")

} else {

# if only 1 image, assume it has multiple exposures and proceed to test
# star positions

   fadd = f0
   focstr = fadd
   for (i=2; i <= steps; i+=1) {
	fadd = fadd + df
	focstr = focstr//","//fadd
   }

   print("  ")
   print("Mark the ",steps," images IN ORDER from first focus ")
   print("   position to last with keystroke -a- .")
   print("After each marking wait for the image cursor to return before")
   print("   hitting another key.")
   print("You may use > 1 star but mark all ",steps," images completely")
   print("   for each star before moving on to the next star.")
   print("Hit - q - when done.")
   print("  ")

# read image cursor positions into a file
while (fscan (imcur, x, y, iwcs, key) != EOF) {
	if (substr(key,1,1) == "a") {
	   print (x, y, >> "tmp_coord1")
	} else if (substr(key,1,1) == "q") {
	   break
	} else {
	   beep
	}
}
# check that some stars were marked ie file created
if (!access("tmp_coord1")) {
	print("You have marked NO stars!")
	print("You must mark ",steps," for at least 1 star.")
	print("Exiting...")
	bye
}

# first check that a sensible number of stars has been marked
   curvfd = "tmp_coord1"
   nmark = 0
   while (fscan (curvfd, x, y) != EOF) {
	nmark = nmark + 1
   }
   if (nmark < steps) {
	print("You MUST mark ",steps," images for at least 1 star!")
	print("You have marked only ",nmark)
	print("Exiting...")
	bye
   } else if (mod(nmark,steps) > 0) {
	print("You MUST mark exactly ",steps," images for EACH star!")
	print("You have marked ",nmark)
	print("Exiting...")
	bye
   }

# now figure out the geometry: are steps aligned with rows, columns, or
# neither; what is the step size, and where is the double step
   curvfd = "tmp_coord1"
   nmark = 1
   while (fscan (curvfd, x, y) != EOF) {
	print(x, y, >> "tmp_coord2")
	if (nmark == 2) {
	   dx1 = x - xprev
	   dy1 = y - yprev
	} else if (nmark == steps) {
	   dx2 = x - xprev
	   dy2 = y - yprev
	}
	xprev = x
	yprev = y
	nmark = nmark + 1
   }
# are all steps too small?
   if (abs(dx1)<10.0 && abs(dx2)<10.0 && abs(dy1)<10.0 && abs(dy2)<10.0) {
	print("Steps between images too small!")
	print("Run a new multiple exposure focus image with steps of")
	print("AT LEAST 15 pixels")
	print("Exiting...")
	bye
# are x-steps small (==> movement is along y direction)?
   } else if (abs(dx1) < 10.0 && abs(dx2) < 10.0) {
	if (abs(dy1) < abs(dy2)) {
	   gapp = "end"
	   pixstep = int(abs(dy1))
	} else {
	   gapp = "beginning"
	   pixstep = int(abs(dy2))
	}
	if (dy1 < 0.0) {
	   dirp = "-line"
	} else {
	   dirp = "+line"
	}
# are y-steps small (==> movement is along x direction)?
   } else if (abs(dy1) < 10.0 && abs(dy2) < 10.0) {
	if (abs(dx1) < abs(dx2)) {
	   gapp = "end"
	   pixstep = int(abs(dx1))
	} else {
	   gapp = "beginning"
	   pixstep = int(abs(dx2))
	}
	if (dx1 < 0.0) {
	   dirp = "-column"
	} else {
	   dirp = "+column"
	}
   } else {
# if all steps are large (==> movement along some arbitrary angle)
# then use imexam + curfit because starfocus will not work
	imexam (input=namein, frame=1, image=namein, logfile="tmp_results", 
	   keeplog+, defkey="a", imagecur="tmp_coord2", use_display-)

	curvfd = "tmp_results"
	if ( fscan (curvfd, dum1) != EOF) {
	   print ("  ")
	   print ( "  ... Setting up file for focus fit ...")
	   print ( " When fit is done put graphics cursor on minimum")
	   print ( " of fitted curve and hit <shift>-C to get:")
	   print ( "   -best focus setting = x coordinate")
	   print ( "   -estimate of seeing = y coordinate")
	   print ( " Hit keystroke - q - when done.")
	   print ("  ")
	}
	if ( fscan(curvfd, dum1, xin, yin, dum2, dum3, dum4, dum5, dum6, dum7, 
	   dum8, dum9, zin) !=EOF ) {
	   printf("# FOCUS        FWHM \n", > "tmp_outlist")
	}
	j = 0
	while (fscan (curvfd, x, y, d1, d2, d3, d4, d5, d6, d7, d8, z) !=EOF ) {
	    fx = f0 + real(j)*df
	   y = z * pscl
	   printf("%7.2f     %7.2f\n",fx,y, >> "tmp_outlist")
	   j = j + 1
	   if ( j == steps ) 
		j = 0
	}
# fit curve to FWHM as function of focus
	curfit (input="tmp_outlist", function="legendre", weighting="uniform",
	   order=4, interactive+, axis=1, listdata-, verbose-,
 	   calctype="double", power+, device="stdgraph", cursor="",
	   > "tmp_curvdump")
# clean up; for now delete all output text files
# maybe later use them to compute the min of the curve
	infd = ""
	delete (listin, ver-, >& "dev$null")
	delete ("tmp_coord1", ver-, >& "dev$null")
	delete ("tmp_coord2", ver-, >& "dev$null")
	delete ("tmp_results", ver-, >& "dev$null")
	delete ("tmp_outlist", ver-, >& "dev$null")
	delete ("tmp_curvdump", ver-, >& "dev$null")
	bye
   }

# now: if this point is reached we are ready to run starfocus in 
# multiple-exposure mode
# first make up a list of just the first-image positions
   curvfd =  "tmp_coord1"
   nmark = 0
   while (fscan (curvfd, x, y, code, letr) != EOF) {
	if (mod(nmark,steps) == 0) {
	   print( x, y, >> "tmp_incur")
	}
	nmark = nmark + 1
   }
   print("  ")
   print("Starting starfocus...")
   print("Wait a while...")
   print("When graphics cursor appears in graphics window---")
   print("move mouse cursor to that window and hit - q - to quit")
   print("  ")
   starfocus (images=imlist, focus=focstr, nexposures=steps, 
     step=pixstep, direction=dirp, gap=gapp, coords="mark1",
     display-, frame=1, level=0.5, size="GFWHM", beta=INDEF,
     scale=pscl, radius=5.0, sbuffer=5.0, swidth=5.0, saturation=60000.0, 
     ignore_sat-, iterations=2, xcenter=INDEF, ycenter=INDEF, logfile="", 
     imagecur="tmp_incur", graphcur="")
   delete("tmp_incur", ver-, >& "dev$null")
}

# print warning message, clean up, and quit
#print("  ")
#print("Caution: these FWHM are in units of arcsec but they are only")
#print("   approximate seeing estimates.  Use IMEXAM if you want to ")
#print("   estimate seeing.")
#print("  ")

infd = ""
curvfd = ""
delete (listin, ver-, >& "dev$null")
delete ("tmp_coord1", ver-, >& "dev$null")
delete ("tmp_coord2", ver-, >& "dev$null")

end
