# IRAF script -- c2mksky.cl
#
#   function:  to make a combined 2nd-passsky frame 
#	
# programmer: sjchan 
#        history: 11may98 -- created
#          Notice: only skytype = EF  #empty field is available
#                 18june98 -- modified (rename from cc2msky --> c2mksky)



procedure c2mksky(imglist,imgout,nstart,sky1img,skytype,fwhmobj,threshold,edrad)

string	imglist {"@skyimg.in",prompt="(@List of/ *.fits) Input images",mode="ql"}
string  imgout  {"sky2img.fits",prompt="Output 2nd-pass combined sky image",mode="ql"}
int     nstart  {1, prompt="the starting fold number for imcombine", mode="ql"}
string  sky1img {"sky1pass.fits", prompt="1st-pass skyimage", mode="ql"} 
string  skytype {"EF", prompt="Skytype(empty(EF)/crowded(CF)/bigobj(BO)", mode="ql"}
real fwhmobj    {5.0, prompt="FWHM of the object in pixels", mode="ql"}
real threshold  {3.5, prompt="Threshold in sigma for feature detection", mode="ql"}
real edrad      {2.5, prompt="Radius of the normal aperture mask (fwhmobj unit)", mode="ql"}
string coolist  {"objcoo.in", prompt="List of output location of ojects in each image", mode="ql"}

string  *filist

begin
        string  imglist1            # List of input images
        string  imgout1             # Output combined 2n-pass sky image
        int     nstart1             # the starting fold number for imcombine
        string  sky1img1            # 1st-pass skyimage
        string  skytype1            # skytype
        real    fwhmobj1            # FWHM of the object in pixel
        real    threshold1          # threshold in sigma for feature dectection
        real    edrad1              # Radius of the aperture mask for IMEDIT
        string  coolist1            # List of output location of objects in 
                                      # each frame
        string  frametemp           # Input image
        string  ifile,ifile1, ofile # final version of input and output
        string  csofile             # list of the cleaned sky images
         string  c2mkskylog         # logfile
        string  indc                # indicator
        int     nl, nh              # nlow and nhigh (reject=minmax in 
                                    #    imcombine
        int     icount, ic          # number of images in input image list
        string  skyframein          # individual cleaned sky image
        string  toutsky             # individual 2nd-pass sky image
        string  csskyfl             # temporary file containing individual 
                                     # cleaned-sky with 1st-pass sky backgd.
        string  scomfct             # combine function in IMCOMBINE
        string  templog             # temporary logfile

        #  Get the rest of the parameter

        imglist1 = imglist
        imgout1  = imgout
        nstart1  = nstart
        sky1img1 = sky1img
        skytype1 = skytype
        fwhmobj1 = fwhmobj
        threshold1 = threshold
        edrad1 = edrad
        coolist1 = coolist

        c2mkskylog="c2mksky.log"
        ind="C"       # dummy definition
        icount = 0; ic = 0
        ifile = mktemp("c2skyi")
        ifile1 = mktemp("c2skyia")
        ofile = mktemp("c2skyo")
        csofile = "cleansky.in"
        csskyfl = "sky2frame.in"
        templog = "ccleanskye.log"

        nh=0
        nl=0
	
        #  Check the existence of files
           if (access(c2mkskylog))
             delete(c2mkskylog, ver-, >& "dev$null")
           if (access(ifile))
             delete(ifile, ver-, >& "dev$null")
           if (access(ifile1))
             delete(ifile1, ver-, >& "dev$null")
           if (access(ofile))
             delete(ofile, ver-, >& "dev$null")
           if (access(csofile))
             delete(csofile, ver-, >& "dev$null")
           if (access(csskyfl))
             delete(csskyfl, ver-, >& "dev$null")
           if (access(imgout1))
             delete(imgout1, ver-, >& "dev$null")

        #  Find out the suitable input option

           _finout(imglist1, indc, ifile, ofile)
          
        # Read the file 'ifile' to count the number of files

        filist = "";  filist = ifile
        while (fscan(filist,frametemp) !=EOF)
         {
          ic += 1
            if (ic >= nstart1)
              {
                 icount += 1
                 print(frametemp, >> ifile1)
              }
         }  # this is from the while fold (filist, frametemp)
        filist=""   # close the file

        print("icount = ", icount)
         if (icount <= 2)
           {
            nh = 0
            nl = 0
           }
         else if ((icount > 2)  && (icount < 5))
           {
            nh = 1
            nl = 1
           }
         else if ((icount >= 5) && (icount < 10))
          { 
            nh = 2
            nl = 1
          }
         else if ((icount >= 10) && (icount < 20))
          {
            nh = 5
            nl = 3
          }
         else if (icount < 30) 
         {
            nh = 10
            nl = 5
         }
         else if (icount < 40)
         {
            nh = 13
            nl = 10
         }
         else if (icount < 45)
         {
            nh = 20
            nl = 15
         }
         else if (icount < 50)
         { 
            nh = 20
            nl = 20
         }
         else if (icount < 60)
         {
            nh = 25
            nl = 20
         }
         else if (icount < 65)
         {
            nh = 30
            nl = 25 
         }
         else if (icount < 70)
         {
            nh = 30
            nl = 30 
         } 
         else if (icount < 75)
         {
             nh = 35
             nl = 30
         }
         else if (icount < 80)
         { 
             nh = 35
             nl = 35
         }
         else
         {   
             nh = 40
             nl = 35 
         }

      # produce the coordinate list and then clean the sky
        if (skytype1 == "EF")
          ccleanskye("@"//ifile1,fwhmobj1,threshold1,csofile,coolist1,edrad1) 
        else
          {
            print("Skytyp: ", skytype1," option is not available!")
            print("Only EF -- empty field option is available!")
            bye
          }
             
         unlearn type
         print("", >> c2mkskylog)
         type(templog, >> c2mkskylog)

      # produce individual 2nd-pass sky frame
        
         print("*********************************************", >> c2mkskylog)
         print("")
         print("", >> c2mkskylog)
         print("Making individual 2nd-pass cleaned sky images")
         print("Making individual 2nd-pass cleaned sky images", >> c2mkskylog)
         print("", >> c2mkskylog)

         filist = ""; filist = csofile
         while (fscan(filist, skyframein) != EOF)
           {
            # make the output filename of individual 2nd-pass sky frame
              toutsky = "tas_"//skyframein 
              if (access(toutsky))
                  delete(toutsky, ver-, >& "dev$null")
                    
              unlearn imarith
              imarith(operand1= skyframein, op="+", operand2=sky1img1, 
                result = toutsky,  pixtype="real", calctype="real", 
                 verbose=yes, >> c2mkskylog)
              
               print(toutsky, >> csskyfl)

            } # this brace is from while block (filist, skyframein)
         filist = "" # close the file

       # Make the combined 2nd-pass sky frame
         print("******************************************", >> c2mkskylog)
         print("Making a combined 2nd-pass sky:", >> c2mkskylog)

         unlearn imcombine
         if (icount <= 2)
             scomfct = "average"
         else
             scomfct = "median"

         imcombine("@"//csskyfl,imgout1,combine=scomfct, reject="minmax",
            outtype="real", scale="median", nlow=nl, nhigh=nh, 
            logfile=c2mkskylog)

        delete (ofile//","//ifile, ver-, >& "dev$null")
        delete (ifile1, ver-, >& "dev$null")
#        delete("@"//csofile, ver-, >& "dev$null")
#       delete(csofile, ver-, >& "dev$null")
#       delete("@"//csskyfl, ver-, >& "dev$null")
#        delete(csskyfl, ver-, >& "dev$null")

        print("      << ======= c2mksky DONE ====== >>")


end

