# IRAF script -- _fobjcoo
#                
#    function: to find the location of objects in the given frame
#                the objects.
#	
#    stage: 
# programmer: sjchan 
#             7may98: created
#             12may98: put an indicator (SS or BB) into the coordinate file
#                       to indicate the size of objects
##

procedure _fobjcoo(img, fwhmobj, thold, coordfl)

string img      {"input.fits", prompt="input image", mode="ql"}
real   fwhmobj   {5.0, prompt="FWHM of the object in pixels", mode="ql"}
real   thold    {3.5, prompt="Threshold in sigma for feature detection", mode="ql"}
string coordfl    {"obj.coo", prompt="Output coordinate list", mode="ql"}
real   skysig     { prompt="skysigma of input image"}

struct *filist

begin

     string img1          # input image
     string coordfl1        #i output coordinate file
     real   fwhmobj1         #i apphot.datapars.fwhmpsf (stellar)
     real   fwhmobj1ns       #i apphot.datapars.fwhmpsf (non-stellar)
     real   thold1          #i apphot.findpars.threshold
     real   thold11         #i apphot.findpars.threshold  
     real   tdmin1          #i apphot.datapars.datamin
     real   tdmax1          #i apphot.datapars.datamax
     string fobjcoolog      #logfile
     string tdfindo1       #o temporary output file from daofind (non-stellar)
     string tdfindo2       #o temporary output file from daofind (stellar)
     string tcendo1, tcendo2   #o dump (xcen, ycen) from tdfindo1, tdfindo2
     string tcendo1s, tcendo2b #o put indicator into tcendo1s, tcendo2b files
     string tcenfl         #o temporary output file of dsfout (get xcen, ycen)
     string tscenfl        #o temporary output file of tcenfl(sorted)
     string tcoordfl1        # output coordinate file without sort "SS and BB"
     real   tdskysig       #  input sigma for daofind (apphot.datapars.sigma)
     real   xcen1, ycen1   #o location of object
     real   xcen2, ycen2   #o location of object
     real   xtemp1a, xtemp1s, ytemp1a, ytemp1s
     string edtemp         # the string for imedit "  1   b"
     int    ic             # dummy counter
     string id             # the indicator to indicate the objtype
     real   txc, tyc       # dummy xcen,ycen

     # Get the rest of the parameter
     img1       = img
     fwhmobj1   = fwhmobj
     thold1     = thold
     coordfl1    = coordfl
     fobjcoolog = "_fobjcoo.log"
     tdfindo1 = "tdfindo1.coo"
     tdfindo2 = "tdfindo2.coo"
     tcendo1  = "tcendo1.coo"
     tcendo2  = "tcendo2.coo"
     tcendo1s = "tcendo1s.coo"
     tcendo2b = "tcendo2b.coo"
     tcenfl   = "tcenfl.coo"
     tscenfl  = "tscenfl.coo"
     tcoordfl1= "tcoordfl1.coo"

     edtemp   = "  1   b"
     txc = 0.0; tyc = 0.0

     tdmin1 = 0.0

   # Check the existence of files
     if (access(fobjcoolog))
         delete(fobjcoolog, ver-, >& "dev$null")
     if (access(coordfl1))
         delete(coordfl1, ver-, >& "dev$null")
     if (access(tdfindo1))
          delete(tdfindo1, ver-, >& "dev$null")
     if (access(tdfindo2))
          delete(tdfindo2, ver-, >& "dev$null")
     if (access(tcendo1))
          delete(tcendo1, ver-, >& "dev$null")
     if (access(tcendo2))
          delete(tcendo2, ver-, >& "dev$null")
     if (access(tcendo1s))
          delete(tcendo1s, ver-, >& "dev$null")
    if (access(tcendo2b))
          delete(tcendo2b, ver-, >& "dev$null")
     if (access(tcenfl))
          delete(tcenfl, ver-, >& "dev$null")
     if (access(tscenfl))
          delete(tscenfl, ver-, >& "dev$null")
     if (access(tcoordfl1))
          delete(tcoordfl1, ver-, >& "dev$null")

  # estimate the skysigma and datamax from the input image
    unlearn gstatistics
    gstatistics(img1, >& "dev$null")
    tdskysig   = gstpar.stddev 
    unlearn minmax    
    minmax(img1, >& "dev$null")
    tdmax1 = minmax.maxval

     print("", >> fobjcoolog)
     print("Datamin :", tdmin1, >> fobjcoolog)

    print("Skysig: ", tdskysig, >> fobjcoolog)     
    print("Datamax: ", tdmax1, >> fobjcoolog)  

    unlearn datapars; unlearn findpars
    unlearn daofind
    datapars.fwhmpsf = fwhmobj1  # stellar
    datapars.sigma   = tdskysig
    datapars.datamin = 0.
    datapars.datamax = tdmax1
    findpars.threshold = thold1
    daofind(img1, output=tdfindo1, verify = no, verbose= yes, >> fobjcoolog)
       
   # bigger objects
    fwhmobj1ns = 2.0 * fwhmobj1
    datapars.fwhmpsf = fwhmobj1ns
    daofind(img1, output=tdfindo2, verify = no, verbose= yes, >> fobjcoolog)

   # put a special indicator into the tdfindo1, tdfindo2
   #   "SS" -- input basic aperture
   #   "BB" -- big objects 
   # dump the column of XCENTER and YCENTER
      txdump(tdfindo1, "XCENTER  YCENTER", "yes", headers = no, > tcendo1)
      txdump(tdfindo2, "XCENTER  YCENTER", "yes", headers = no, > tcendo2)
      delete(tdfindo1, ver-, >& "dev$null")
      delete(tdfindo2, ver-, >& "dev$null")

     id = "SS"
     filist = ""; filist = tcendo1
     while ( fscan(filist, txc, tyc) != EOF)
         print(txc, tyc, id, >> tcendo1s)

     id = "BB"
     filist = ""; filist = tcendo2
     while ( fscan(filist, txc, tyc) != EOF)
         print(txc, tyc, id, >> tcendo2b) 

     filist = "" #close the file
     delete(tcendo1, ver-, >& "dev$null")
     delete(tcendo2, ver-, >& "dev$null")

   # merge tcendo1s and tcendo2b into tdfout
     unlearn concatenate
     concatenate(tcendo1s//","//tcendo2b, tcenfl)
     sort(tcenfl, column = 1, >> tscenfl)
     delete(tcendo1s, ver-, >& "dev$null")
     delete(tcendo2b, ver-, >& "dev$null")
     delete(tcenfl, ver-, >& "dev$null")

   
    # take away the duplicate ones
      ic = 0
      filist = ""; filist = tscenfl
      while ( fscan(filist, xcen2, ycen2, id) != EOF)
        {
          ic += 1
          if (ic == 1)
             print(xcen2, ycen2, "   ",id,  >> tcoordfl1)
          else # ic > 1)
           {
             if (  (xtemp1s >= xcen2) || (xtemp1a <= xcen2) ||
                   (ytemp1s >= ycen2) || (ytemp1a <= ycen2) )
               {
                 print(xcen2, ycen2, "   ",id, >> tcoordfl1)
               } # this brace is from inner if block 
                   # xcen2, ycen2 is in the pixel range
            
           } # this brace is from if block (ic > 1)

          xcen1 = xcen2   # store the current value for comparison
          ycen1 = ycen2
          xtemp1a = xcen1 + 1.0; xtemp1s = xcen1 - 1.0
          ytemp1a = ycen1 + 1.0;  ytemp1s = ycen1 - 1.0

        } # this brace is from while block (filist, xcen2, ycen2)
        filist = "" # close the file
        sort(tcoordfl1, column = 3, >> coordfl1)
       
          delete(tscenfl, ver-, >& "dev$null")
          delete(tcoordfl1, ver-, >& "dev$null")
          skysig = tdskysig

end



