# IRAF script -- _mkiist.cl
#	
#   this is a sub file management task which is a HIDDEN task.
#    user cannot use it in the front end.
#   function:  to make a list of input files providing runnno and prefix.
#
# programmer: sjchan
#     history: 13march 98
#              8june98: modified -- add an option to produce list for
#                           single chip or single quadrant
#              25june98: modified -- add support for the user to supply
#                          a directory where the raw data is kept.
#              14aug98: modified -- get tndr from the header of the 1st image
#                          of 1st list (rno)
#                          get "nframes" (totquad) from header
#              april99 -- mhoenig: added several conditions to allow for
# 			   pre-ass'd data, single chips and all chips.
#
#

procedure _mkilist(dpath, prefix, runno, dcase, tfold,imglist,quadnos)
string  dpath   {"current",prompt="Full absolute path or logical path", mode="ql"}
string  prefix  {"", prompt="Prefix of the filename", mode="ql"}
string  runno   {"0000", prompt="running number of this data set", mode="ql"}
string  dcase   {"NDR",  prompt="read-out mode", mode="ql"}
int     tfold   {4, prompt="total number of folds", mode="ql"}
string  imglist {"", prompt="name of the file containg output list", mode="ql"}
string  quadnos {"all", prompt="Which quadant number (all; c1/../c4; q1/../q16)", mode="ql"}
int     tndr    {prompt="Total number of NDR (only for NDR case)"}
int     tquad   {prompt="total number of quadrants"}
string  chk     {"G", prompt="file number flag (G/B)"}

struct *filist

begin

string dpath1          # full absolute path or logical path of data directory
string prefix1         # prefix of the filename
string runno1          # running number of this data set
string dcase1          # read-out mode
int    tfold1          # total number of folds
int    tquad1          # total number of quadrants
int    tndr1           # total number of NDR
string imglist1        # name of the file containing output list
string quadnos1        # quadant number (cx, x=1,2,3,4; qy, y=1,2,...,16; all)
string flpat           # file pattern to make a list
string rootpat1        # root file pattern1
string rootpat2        # root file pattern2 (containing chipno or/and quadno)
string rootpat         # root file pattern (rootpat1//rootpat2)
string ndrpat          # pattern for NDR case
string rrrpat          # pattern for RRR case
string scount          # count number of files in string
int    icount          # count number of files in integer
int    iflcount        # number of files (tquad1 * tfold1)
int    iflcount1       # number of files (iflcount/4 or iflcount/16)
int    iflcount2       # number of files (iflcount/8 or iflcount/32)
string chk1            # check file flag (G/B)
string fileid          # file id to provide a right input file
string chipno          # chip number in string
int    ichipno         # chip number in integer
int    len             # length of input quadnos1
int    iquadno         # quadrant number in integer
string squadno         # quadrant number in string
int    tquadno         # temporary quadrant number
string tmp1            # dummy variable -- quadrant number
int    itmp1           # dummy variable -- quadrant number in integer
string s2
int    ii

      cache imgets     # need this action due to a bug in imgets

      #  Get the rest of the parameters
      dpath1  = dpath
      dpath1  = osfn(dpath1)
      prefix1 = prefix
      runno1 = runno
      dcase1 = dcase
      tfold1 = tfold
      quadnos1 = quadnos      
      imglist1 = imglist
      tndr1 = 0
      tquad1 = 0
      rootpat1  = prefix1//"*"//runno1//"_c"
      rootpat2  = "?q?_"   
      flpat  = rootpat1//rootpat2
      ndrpat   = "???.fits"
      rrrpat   = "???.fits"
      iflcount = tfold1 * tndr1 * tquad1
      iflcount1 = iflcount
      iflcount2 = iflcount
      chk1 = "G"
      fileid = "a" # default file id (use all 16 quads)
      itmp1 = 1
   
      if ((dpath1 == "current") || (dpath1 == "Current"))
         dpath1 = ""
      
      # check the existence of files
      if (access(imglist1))
         delete(imglist1, ver-, >& "dev$null")

      # make a suitable pattern (rootpat2) from the choice
      #  c1,c2,c3,c4 or
      #  q1,q2,q3,...q12,q13,q14,q16  or
      #  all


       len = strlen(quadnos1)
       fileid = substr(quadnos1, 1, 1)
       tmp1 = substr(quadnos1, 2, len)
       if (fileid == "")
         fileid = "a"

       print("")
       if (fileid == "c")   # produce a list for a single chip
          {
            chipno  = tmp1 
            squadno = "?"
            itmp1 = int(tmp1)
            if ((itmp1 < 1) || (itmp1) > 4)
              {
                print("Input information incomplete to produce suitable file names")
                 print("You have 3 choices:")
                 print(" 1: Produce filename for all 16 quadrants -- all")
                 print(" 2: Produce filename for a single chip -- c1/c2/c3/c4")
                 print(" 3: Produce filename for a single quadrant -- q1/q2/.../q14/q15/q16")
                 chk1 = "B"
                 chk  = chk1
                 bye
               } # this brace is from inner if block (itmp < 1) or (itmp > 4)
          }
       else if (fileid == "q") # produce a list for a single quadrant
         {
           # get the correct quadrant number 
           itmp1 = int(tmp1)

            if ((itmp1 < 1) || (itmp1) > 16)
              {
                print("Input information incomplete to produce suitable file names")
                 print("You have 3 choices:")
                 print(" 1: Produce filename for all 16 quadrants -- all")
                 print(" 2: Produce filename for a single chip -- c1/c2/c3/c4")
                 print(" 3: Produce filename for a single quadrant -- q1/q2/.../q14/q15/q16")
                 chk1 = "B"
                 chk  = chk1
                 bye
               } # this brace is from inner if block (itmp < 1) or (itmp > 16)

           tquadno = mod(itmp1,4)
           if (tquadno == 0)
             squadno = 4
           else
             squadno = str(tquadno)

           # get the correct chip number
           if (tquadno == 0)
              ichipno = int(itmp1/4)
           else
              ichipno = int(itmp1/4) + 1

           chipno = str(ichipno)
              
         } # this brace is from else-if block (fileid == q)
       else if (quadnos1 == "all")
        { # produce a list for 16 quadrants
           chipno  = "?"
           squadno = "?"
        }
       else  # not above case, return the main program and exit
        {
          print("Input information incomplete to produce suitable file names")
          print("You have 3 choices:")
          print(" 1: Produce filename for all 16 quadrants -- all")
          print(" 2: Produce filename for a single chip -- c1/c2/c3/c4")
          print(" 3: Produce filename for a single quadrant -- q1/q2/.../q14/q15/q16")
          chk1 = "B"
          chk  = chk1
          bye
        }  # 
     
          if (cndrproc.preass==1)
	  {
	  rootpat2 = chipno//"_"
	  }
	  else if (cndrproc.preass==0)
	  {
	  rootpat2 = chipno//"q"//squadno//"_"
          }
	  
	  rootpat  = rootpat1//rootpat2    #rootpat1  = prefix1//"*"//runno1_c"

      # make an input list depending the read-out mode
       unlearn files
       if (dcase1 == "NDR")
         { 
           flpat = dpath1//rootpat//ndrpat


           files(flpat, > imglist1)

       count(imglist1) | scan(scount)
       icount = int(scount)
       if (icount == 0)
         {
           print("")
           print("Cannot generate file list")
           print("Please check your input parameters: rnorange, datapath, quadno")
           print("Exiting...")
           print("")
           chk = "B"
           bye
         }
     # get the totalndr and totquad from the 1st image of the header

             filist = ""; filist = imglist1
             while (fscan(filist, s2) != EOF)
               {
                 imgets(s2, param="totalndr")
                 tndr1 = int(imgets.value)
                 imgets(s2, param="nframes")
                 tquad1 = int(imgets.value)
                 break
               }#this brace is from while block (filist = imglist1 gets tndr1)
                 filist = "" 

              if (tndr1 == 0)
                {
                  print("")
                  print("No information about total number of NDR found the header")
                  print("tndr1: ", tndr1)
                  print("")
                }	
             if (tquad1 == 0)
                {
                  print("")
                  print("No information about total number of NDR found the header")
                  print("tquad1: ", tquad1)
                  print("")
                }

         } #this brace is from if-block (dcase1 == NDR)

       if (dcase1 == "RRR")
         {
           flpat = dpath1//rootpat//rrrpat
           files(flpat, > imglist1)

       count(imglist1) | scan(scount)
       icount = int(scount)
       if (icount == 0)
         {
           print("")
           print("Cannot generate file list")
           print("Please check your input parameters")
           print("")
           chk = "B"
           bye
         }
      # get the totquad from the 1st image of the header
             ii = 0
             filist = ""; filist = imglist1
             while (fscan(filist, s2) != EOF)
               {
                 ii += 1
                 if (ii == 2)
                   {
                    imgets(s2, param="nframes")
                    tquad1 = int(imgets.value)
                    break
                   }
               }#this brace is from while block (filist = imglist1 gets tquad1)
                 filist = "" 

             if (tquad1 == 0)
                {
                  print("")
                  print("No information about total number of NDR found the header")
                  print("tquad1: ", tquad1)
                  print("")
                }
 
         } #this brace is from if-block (dcase1 == RRR)

       
       if  (dcase1 == "NDR")
           iflcount = tfold1 * tndr1 * tquad1
       if (dcase1 == "RRR")
           iflcount = tfold1 * tquad1
	   
     # check the number of files in the list
       if (fileid == "c")
         {
         iflcount1 = iflcount/4
         iflcount2 = iflcount/8
         }
       if (fileid == "q")
         {
          iflcount1 = iflcount/16
          iflcount2 = iflcount/32
         }

       if ((cndrproc.preass==1) && (fileid=="a"))
         {
          iflcount1 = iflcount/4
          iflcount2 = iflcount/8
	 } 
       if ((cndrproc.preass==1) && (fileid=="c"))
         {
          iflcount1 = iflcount/16
          iflcount2 = iflcount/32
	 } 
	  
       count(imglist1) | scan(scount)
       icount = int(scount)

      if ((icount != iflcount) && (icount != iflcount1) && (icount != iflcount2))
         {
           print("FILES INCOMPLETE! Check outfile ", imglist1)
           print(" There are ",scount," files in the list instead of")
           print("       ",iflcount, "which is based on the the total number")
           if (dcase1 == "NDR")
             print("       of folds, NDRs and quadrants from your input.")
           if (dcase1 == "RRR")
             print("       of folds and quadrants from your input.")
           chk1 = "B"
         }
       else
           chk1 = "G"

       chk = chk1
       tndr = tndr1
       tquad = tquad1

end

