# IRAF script -- _addhist.cl
#
# this is a record processing script which is a HIDDEN task, user cannot
#   use it in the front end.
# 
# function: to append 'HISTORY' cards to the image header.
#           All existing 'HISTORY' cards are collated and moved to the end of
#           the header, and the new card is added afterward.
#
# 930730: created by Mark Dickinson (addcomment.cl)
# Nov 97: modified by sjchan

procedure _addhist (image, history, update)
string	image	 {prompt="Image(s) to which to append history card", mode="ql"}
string	history	 {prompt="History", mode="ql"}
bool	update	 {yes,prompt="Update header?",mode="ql"}
bool	verify	 {no,prompt="Verify header?"}


begin

       string 	img         #  Image to which to append history card
       string   his         #  The field value in 'history field'
       string   headfile    #  dummy variable (headfile name)
       bool     verify1     #  prompt to verify the header
       bool     update1     #  prompt to update the header
       bool     setheader   #  prompt to setheader

      # Make sure the appropriate packages are loaded.
        if (!defpac("proto"))
           proto
     
      #  Get the rest of the parameters
       img = image
       his = history
       verify1 = verify
       update1 = update

      # grep all the HISTORY card in the header and then put them in headfile

        headfile = mktemp("headerjj") #make a temporary file to hold a header
	hfix (img,command="!grep -v 'HISTORY =' $fname > "//headfile,update-)
	hfix (img,command="!grep 'HISTORY =' $fname >> "//headfile,update-)
	print("HISTORY = '", his ,"'", >>headfile)

      # verify to update the header
	  if (verify1) 
            {
	       print ("HISTORY cards currently read:")
	       match ("HISTORY =",headfile,stop-,print+)
	       if (update1)
	            setheader = yes
	       else
                {
		    setheader = no
	            print ("Header will be left unchanged.")
		}
             }  # this brace is from if (verify) block
            else
               setheader = yes

            if (setheader) 
		hfix (img,command="delete $fname ver- ; copy "//headfile//" $fname",update+)

        # Cleaning up
            delete (headfile,ver-, >& "dev$null")

end

