      program fdrift
c+
c analyze cirsi data for noise that is aligned along a line
c or column
c
c

c *** DRIFT  does driftscan-type filtering on array map usual coordinate
c ***        system ie. y -->  and x |
c ***                                V
c ***   NB.  Now includes option for dealing with varying backgrounds


* deterline command line inputs

c-

*      implicit none


      integer nmax
      parameter(nmax=512)

      integer naxes(4)
      integer imap(nmax*nmax)
      integer ibmap(nmax*nmax)
      integer ihist(65536)      

      real*4 ahist(65536)      

      real*4  xcord(65536)

      real*4 amin,amax,amedian

      real*4 map(nmax*nmax)
      real*4 bmap(nmax*nmax)

      real*4 gridx(nmax),gridy(nmax)
      real*4 coord(nmax),reflev(nmax)

      real*4 back(128,128)

      real*4 work(nmax*nmax)

      character infile*132
      character outfile*132

      character*8 dummy

      logical prhdr,verdat,movhdu,simple,extend,anynull

      character argv*40

      iunit=1     
      lr=5
      lt=6
      

c *** clear correction arrays
      do i=1,nmax
        gridx(i)=1.0
        gridy(i)=1.0
        coord(i)=i-0.5
c        reflev(i)=1.0
        reflev(i)=0.0
      enddo

      do i=1,nmax*nmax
        map(i)=0.0
        bmap(i)=0.0
        imap(i)=0
        ibmap(i)=0
      enddo

      ixstart=1
      ixend=512

      iystart=1
      iyend=512
 

* iargc returns the number of command line arguements
      nargs=iargc()

      interactive=1
      iplots=0

      if(nargs .gt. 0) then

        interactive=0

        call getarg(0,argv)
        write(*,*) argv(1:40),
     : ' number of command line arguements ',iargc()


      endif

*        call getarg(1,argv)
*        read(argv,*) ap0_x_old


c *** open the fits format file and determine if i*4 or r*4
c and determine range to read in

      call getstr('Assign input file : ',infile)

      call ftopen(iunit,infile,0,iblocksize,istatus)
      write(*,*) ' istatus= ',istatus,iblocksize
      call ft_check(istatus)
   
      imaxdim=4
      write(*,*) ' calling ftghpr '
      call ftghpr(iunit,imaxdim,simple,ibitpix,naxis,naxes,
     : ipcount,igcount,extend,istatus)
      call ft_check(istatus)

      write(*,*) 'BITPIX =',ibitpix
      write(*,*)  naxes(1),' by ',naxes(2)


      if(interactive .eq. 0) then

      call get2i4(
     : 'Enter range of records/lines to read in (ixstart,ixend) : ',
     : ixstart,ixend)

      call get2i4(
     : 'Enter range of words/columns to read in (iystart,iyend) : ',
     : iystart,iyend)


      endif

      write(*,*) ixstart,ixend,iystart,iyend

* try the fitsio io
      call frdbufi(iunit,imap,ixstart,ixend,iystart,iyend,nxout,nyout,istatus)
      write(*,*) ' exited frdbuf : ',nxout,nyout

* copy the integer array into a real array
      do i=1,nxout*nyout
        map(i)=imap(i)
        work(i)=map(i)
      enddo

      npts=nxout*nyout
      call maxmin(npts,map,amax,amin) 
      call moment(map,npts,ave,adev,sdev,var,skew,curt)

* this is quite slow
*      write(*,*) 'sorting to determine the median '
*      call sort1(work,npts)
*      i=(npts+1)/2
*      amedian=work(i)

      write(*,*) 'ave,adev,sdev,var,skew,curt,min,max,median'
      write(*,*)  ave,adev,sdev,var,skew,curt,amin,amax,amedian 

* now do mike denhist-type analysis
      do i=1,65536
        ihist(i)=0
      enddo
 
      do  i=1,npts
        ii=map(i)
        imin=min(ii,imin)
        imax=max(ii,imax)
        if(ii .gt. 1) ihist(ii)=ihist(ii)+1
        if(ii .gt. 1) ahist(ii)=ihist(ii)
      enddo


      nhist=65536

      call maxmin(nhist,ahist,amax,amin) 
      call moment(ahist,nhist,ave,adev,sdev,var,skew,curt)

      write(*,*) 'ave,adev,sdev,var,skew,curt,min,max'
      write(*,*)  ave,adev,sdev,var,skew,curt,amin,amax 


      write(*,*) 'run histat'
      call histat(ihist,mode,maxh,xmean,xpeak,fsigma,gsigma,nhist)
      write(*,*) 'exit histat'

      write(*,*) 'mode,maxh,xmean,xpeak,fsigma,gsigma'
      write(*,*) mode,maxh,xmean,xpeak,fsigma,gsigma



      write(*,
     : '(//''Mode = '',i6,''  Median = '',f8.2,''  Mean = '',f8.2/
     1 ''Interpolated peak position = '',f8.2,''  Sigma = '',f7.2/
     2 ''Minimum = '',i6,''    Maximum = '',i6//)')
     : mode,xmed,xmean,xpeak,sigma,imin,imax


      xmin=imin
      xmax=imax

      ymin=0
      ymax=maxh
      fmaxh=maxh
      do i=1,65536
        xcord(i)=i
      enddo


      if(iplots .eq. 1) then 

      call pgintro
      call pgenv(xmin,xmax,ymin,ymax,0,0)
      call pglabel(' ',' ','DENSITY HISTOGRAM')
      call pgbin(nhist,xcord,ahist,.true.)
      xtext=xmin+0.67*(xmax-xmin)

      write(dummy,'(f8.2)') xmean 
      call pgtext(xtext,0.9*fmaxh,'Mean    ='//dummy)

      write(dummy,'(f8.2)') xmed
      call pgtext(xtext,0.83*fmaxh,'Median  ='//dummy)

      write(dummy,'(f8.2)') fmode
      call pgtext(xtext,0.76*fmaxh,'Mode    ='//dummy)

      write(dummy,'(f8.2)') xpeak
      call pgtext(xtext,0.69*fmaxh,'Peak    ='//dummy)

      write(dummy,'(f8.2)') sigma
      call pgtext(xtext,0.62*fmaxh,'Sigma   ='//dummy)

      fmin=imin
      fmax=imax

      write(dummy,'(f8.1)') fmin
      call pgtext(xtext,0.55*fmaxh,'Minimum ='//dummy)

      write(dummy,'(f8.1)') fmax
      call pgtext(xtext,0.48*fmaxh,'Maximum ='//dummy)
  
      call pgextro

      endif

      npt=nyout
      nrec=nxout

      ifilt=1
      ifiltx=1
      iback=1
      iscale=16

      if(interactive .eq. 0) then


* determine the type of filtering
        call posei4
     1   ('Do you want to filter in both directions ? [Y]',ifilt)

        if(ifilt.eq.0)call posei4
     1   ('column direction only ? [Y] otherwise row direction',ifiltx)
        iback=1

* 
        call posei4('Deal with background variations ? [Y]',iback) 

        call geti4('Scale size for background determination eg 32 ',iscale)
      
      endif

      isizx=iscale

      isizxo2=isizx/2
      fsizx=1.0/float(isizx)

      isizy=iscale

      isizyo2=isizy/2
      fsizy=1.0/float(isizy)
      fsizsq=fsizx*fsizy

      write(*,*) isizx,isizy,fsizx,fsizy,fsixo2,fsizyo2
c
c *** estimate overall backgrounds
c
      if(iback.eq.1)then

        iklim=(nrec-1)/isizx+1
        jklim=(npt-1)/isizy+1

        do i=1,iklim

          do j=1,jklim
  
            ilow=(i-1)*isizx+1
            ihih=min(nrec,i*isizx)
            jlow=(j-1)*isizy+1
            jhih=min(npt,j*isizy)
            npix=0
        
            do ii=ilow,ihih
        
              iii=(ii-1)*npt
        
              do jj=jlow,jhih

                npix=npix+1
                work(npix)=map(iii+jj)

              enddo
      
            enddo

            call sort1(work,npix)
    
            back(i,j)=work(npix/2)
        
*            write(*,*) i,j,back(i,j)

          enddo

        enddo

c *** pad edge values if necessary
        if(iklim*isizx-nrec.gt.isizxo2)then
	  do j=1,jklim
  	    back(iklim,j)=back(iklim-1,j)
          enddo
        endif
        if(jklim*isizy-npt.gt.isizyo2)then
	  do i=1,iklim
  	    back(i,jklim)=back(i,jklim-1)
          enddo
        endif
c *** filter the backgrounds
        write(*,*) 'bfilt: ',iklim,jklim
*        do i=1,iklim
*           write(*,*) i,(back(i,j),j=1,jklim)
*        enddo
        call bfilt(back,iklim,jklim,5)
c
c *** find average sky value
c
        sky=0.0
        nsky=0
        do i=1,iklim
          do j=1,jklim
            nsky=nsky+1
            sky=sky+back(i,j)
          enddo
        enddo
        sky=sky/float(nsky)

        write(*,*)
        write(*,*) ' sky = ',sky,nrec,npt
        write(*,*)
c
c *** interpolate backgrounds and subtract from map
c
        do i=1,nrec
          ii=(i-1)*npt
          do j=1,npt
            call binterp(back,iklim,jklim,i,j,res,isizx,isizxo2,fsizx,
     1               isizy,isizyo2,fsizy,fsizsq)
c *** set sky to average sky value
            temp=map(ii+j)-res+sky
            bmap(ii+j)=map(ii+j)-temp
            map(ii+j)=temp
          enddo
        enddo
      endif

* write out integer bmap
      do i=1,nxout*nyout
        ibmap(i)=nint(bmap(i))
      enddo

      npts=nxout*nyout
      call maxmin(npts,bmap,amax,amin) 
      call moment(bmap,npts,ave,adev,sdev,var,skew,curt)

      write(*,*) 'ave,adev,sdev,var,skew,curt,min,max,median'
      write(*,*)  ave,adev,sdev,var,skew,curt,amin,amax,amedian 

      
      write(*,*) 'writing out the background map'

      outfile='fdrift_backmap.fits'
* copy the header block from infile and write out to outfile
      call fwrbufi(iuniti,infile,iunito,outfile,ibmap,nxout,nyout,istatus)
      write(*,*) 'write finished '
      write(*,*)

      npts=nxout*nyout
      call maxmin(npts,map,amax,amin)
      call moment(map,npts,ave,adev,sdev,var,skew,curt)
      do i=1,nxout*nyout
        work(i)=map(i)
        imap(i)=map(i)
      enddo

      call sort1(work,npts)

      i=(npts+1)/2
      amedian=work(i)

      write(*,*) 'ave,adev,sdev,var,skew,curt,min,max,median'
      write(*,*)  ave,adev,sdev,var,skew,curt,amin,amax,amedian,npts


      call histat(imap,mode,maxh,xmean,xpeak,fsigma,gsigma,npts)
      write(*,*) 'mode,maxh,xmean,xpeak,fsigma,gsigma'
      write(*,*) mode,maxh,xmean,xpeak,fsigma,gsigma


* now do mike denhist-type analysis
      do i=1,65536
        ihist(i)=0
      enddo
      do  i=1,npts
        ii=nint(map(i))
        imin=min(ii,imin)
        imax=max(ii,imax)
        if(ii .gt. 1) ihist(ii)=ihist(ii)+1
        if(ii .gt. 1) ahist(ii)=ihist(ii)
      enddo


      nhist=65536

      call maxmin(nhist,ahist,amax,amin) 
      call moment(ahist,nhist,ave,adev,sdev,var,skew,curt)

      write(*,*) 'ave,adev,sdev,var,skew,curt,min,max'
      write(*,*)  ave,adev,sdev,var,skew,curt,amin,amax 


      write(*,*) 'run histat'
      call histat(ihist,mode,maxh,xmean,xpeak,fsigma,gsigma,nhist)
      write(*,*) 'exit histat'

      write(*,*) 'mode,maxh,xmean,xpeak,fsigma,gsigma'
      write(*,*) mode,maxh,xmean,xpeak,fsigma,gsigma



      write(*,
     : '(//''Mode = '',i6,''  Median = '',f8.2,''  Mean = '',f8.2/
     1 ''Interpolated peak position = '',f8.2,''  Sigma = '',f7.2/
     2 ''Minimum = '',i6,''    Maximum = '',i6//)')
     : mode,xmed,xmean,xpeak,sigma,imin,imax


      xmin=imin
      xmax=imax

      ymin=0
      ymax=maxh
      fmaxh=maxh
      do i=1,65536
        xcord(i)=i
      enddo



      if(iplots .eq. 1) then 

      call pgintro
      call pgenv(xmin,xmax,ymin,ymax,0,0)
      call pglabel(' ',' ','DENSITY HISTOGRAM')
      call pgbin(nhist,xcord,ahist,.true.)
      xtext=xmin+0.67*(xmax-xmin)

      write(dummy,'(f8.2)') xmean 
      call pgtext(xtext,0.9*fmaxh,'Mean    ='//dummy)

      write(dummy,'(f8.2)') xmed
      call pgtext(xtext,0.83*fmaxh,'Median  ='//dummy)

      write(dummy,'(f8.2)') fmode
      call pgtext(xtext,0.76*fmaxh,'Mode    ='//dummy)

      write(dummy,'(f8.2)') xpeak
      call pgtext(xtext,0.69*fmaxh,'Peak    ='//dummy)

      write(dummy,'(f8.2)') sigma
      call pgtext(xtext,0.62*fmaxh,'Sigma   ='//dummy)

      fmin=imin
      fmax=imax

      write(dummy,'(f8.1)') fmin
      call pgtext(xtext,0.55*fmaxh,'Minimum ='//dummy)

      write(dummy,'(f8.1)') fmax
      call pgtext(xtext,0.48*fmaxh,'Maximum ='//dummy)
  
      call pgextro

      endif

c *** find corrections for columns
      print *,'Filtering now'
      if(ifilt.eq.1.or.ifiltx.eq.1)then
        sum=0.0   
        do k=1,npt
*         write(lt,'(i8,a,$)') k,buf
          do j=1,nrec
            jj=(j-1)*npt
            work(j)=map(jj+k)
          enddo
          call sort1(work,nrec)
          gridy(k)=work(nrec/2)
*          write(*,*) ' k,gridy(k) ', k,gridy(k) 
          sum=sum+gridy(k)
        enddo
c *** to keep same arithmetic mean - could alternatively use geometric
        sum=sum/float(npt)
        cmin=1.0e6
        cmax=-1.0e6
        do k=1,npt
c        gridy(k)=sum/gridy(k)
        gridy(k)=sum-gridy(k)
        cmin=min(cmin,gridy(k))
        cmax=max(cmax,gridy(k))
        enddo
      endif
      print *,' '
c *** find corrections for rows
      if(ifilt.eq.1.or.ifiltx.eq.0)then
        sum=0.0
        do k=1,nrec
*        write(lt,'(i8,a,$)') k,buf

        kk=(k-1)*npt
        do j=1,npt
        work(j)=map(kk+j)
        enddo
        call sort1(work,npt)
        gridx(k)=work(npt/2)
*          write(*,*) ' k,gridx(k) ', k,gridx(k) 
        sum=sum+gridx(k)
        enddo
c *** to keep same arithmetic mean - could alternatively use geometric
        sum=sum/float(nrec)
        do k=1,npt
c        gridx(k)=sum/gridx(k)
        gridx(k)=sum-gridx(k)
        cmin=min(cmin,gridx(k))
        cmax=max(cmax,gridx(k))
        enddo
      endif
      print *,' '
c *** lets have some plots
      write(*,*) ' cmin, cmax : ',cmin,cmax
      




      if(iplots .eq. 1) then 

      call pgintrom(1,2)
      call pgsch(1.4)

      call pgenv(0.0,float(npt),cmin,cmax,0,0)
      
      call pglabel('Column number','Correction',' ')
      call pgsls(2)
      call pgline(npt,coord,reflev)
      call pgsls(1)
      call pgline(npt,coord,gridy)
      call pgenv(0.0,float(nrec),cmin,cmax,0,0)
      call pglabel('Row number','Correction',' ')
      call pgsls(2)
      call pgline(nrec,coord,reflev)
      call pgsls(1)
      call pgline(nrec,coord,gridx)
      call pgextro

      endif

c *** now apply the corrections
      do k=1,nrec

        kk=(k-1)*npt

        do j=1,npt

c          temp=map(kk+j)*gridx(k)*gridy(j)
          temp=map(kk+j)+gridx(k)+gridy(j)

c *** and put background variations back on if necessary
*          if(iback.eq.1)temp=temp+bmap(kk+j)
          map(kk+j)=temp

        enddo

      enddo



      npts=nxout*nyout
      call maxmin(npts,map,amax,amin)
      call moment(map,npts,ave,adev,sdev,var,skew,curt)
      do i=1,nxout*nyout
        work(i)=map(i)
        imap(i)=nint(map(i))
      enddo
      call sort1(work,npts)

      i=(npts+1)/2
      amedian=work(i)

      write(*,*) 'ave,adev,sdev,var,skew,curt,min,max,median'
      write(*,*)  ave,adev,sdev,var,skew,curt,amin,amax,amedian,npts


      call histat(imap,mode,maxh,xmean,xpeak,fsigma,gsigma,npts)
      write(*,*) 'mode,maxh,xmean,xpeak,fsigma,gsigma'
      write(*,*) mode,maxh,xmean,xpeak,fsigma,gsigma


* now do mike denhist-type analysis
      do i=1,65536
        ihist(i)=0
      enddo
      do  i=1,npts
        ii=nint(map(i))
        imin=min(ii,imin)
        imax=max(ii,imax)
        if(ii .gt. 1) ihist(ii)=ihist(ii)+1
        if(ii .gt. 1) ahist(ii)=ihist(ii)
      enddo


      nhist=65536

      call maxmin(nhist,ahist,amax,amin) 
      call moment(ahist,nhist,ave,adev,sdev,var,skew,curt)

      write(*,*) 'ave,adev,sdev,var,skew,curt,min,max'
      write(*,*)  ave,adev,sdev,var,skew,curt,amin,amax 


      write(*,*) 'run histat'
      call histat(ihist,mode,maxh,xmean,xpeak,fsigma,gsigma,nhist)
      write(*,*) 'exit histat'

      write(*,*) 'mode,maxh,xmean,xpeak,fsigma,gsigma'
      write(*,*) mode,maxh,xmean,xpeak,fsigma,gsigma



      write(*,
     : '(//''Mode = '',i6,''  Median = '',f8.2,''  Mean = '',f8.2/
     1 ''Interpolated peak position = '',f8.2,''  Sigma = '',f7.2/
     2 ''Minimum = '',i6,''    Maximum = '',i6//)')
     : mode,xmed,xmean,xpeak,sigma,imin,imax


      xmin=imin
      xmax=imax

      ymin=0
      ymax=maxh
      fmaxh=maxh
      do i=1,65536
        xcord(i)=i
      enddo






      if(iplots .eq. 1) then 

      call pgintro
      call pgenv(xmin,xmax,ymin,ymax,0,0)
      call pglabel(' ',' ','DENSITY HISTOGRAM')
      call pgbin(nhist,xcord,ahist,.true.)
      xtext=xmin+0.67*(xmax-xmin)

      write(dummy,'(f8.2)') xmean 
      call pgtext(xtext,0.9*fmaxh,'Mean    ='//dummy)

      write(dummy,'(f8.2)') xmed
      call pgtext(xtext,0.83*fmaxh,'Median  ='//dummy)

      write(dummy,'(f8.2)') fmode
      call pgtext(xtext,0.76*fmaxh,'Mode    ='//dummy)

      write(dummy,'(f8.2)') xpeak
      call pgtext(xtext,0.69*fmaxh,'Peak    ='//dummy)

      write(dummy,'(f8.2)') sigma
      call pgtext(xtext,0.62*fmaxh,'Sigma   ='//dummy)

      fmin=imin
      fmax=imax

      write(dummy,'(f8.1)') fmin
      call pgtext(xtext,0.55*fmaxh,'Minimum ='//dummy)

      write(dummy,'(f8.1)') fmax
      call pgtext(xtext,0.48*fmaxh,'Maximum ='//dummy)
  
      call pgextro

      endif

c *** write output array in -32 bit disk fits format
*      call wtbuf(header,map,nxout,nyout,linux)

      call ftclos(iunit, istatus)
      do i=1,nxout*nyout
        imap(i)=nint(map(i))
      enddo

      call getstr('Assign output file : ',outfile)

* copy the header block from infile and write out to outfile
      call fwrbufi(iuniti,infile,iunito,outfile,imap,nxout,nyout,istatus)

      end

      subroutine sort1(ia,n)
      real*4 ia(n),it
      int=2
   10 int=2*int
      if(int.lt.n)goto 10
      int=min0(n,(3*int)/4-1)
   20 int=int/2
      ifin=n-int
      do 70 ii=1,ifin
      i=ii
      j=i+int
      if(ia(i).le.ia(j))goto 70
      it=ia(j)
   40 ia(j)=ia(i)
      j=i
      i=i-int
      if(i.le.0)goto 60
      if(ia(i).gt.it)goto 40
   60 ia(j)=it
   70 continue
      if(int.gt.1)goto 20
      return
      end

      subroutine binterp(array,iklim,jklim,i,j,res,isizx,isizxo2,
     1                   fsizx,isizy,isizyo2,fsizy,fsizsq)
      real*4 array(128,128)
c *** BINTERP  does bilinear interpolation on array
      ipos=(i-1)/isizx+1
      jpos=(j-1)/isizy+1
      res=array(ipos,jpos)
c *** find 4 adjacent points
      idel=i-isizx*ipos+isizxo2
      jdel=j-isizy*jpos+isizyo2
      inear=ipos-1
      if(idel.gt.0)inear=ipos+1
      jnear=jpos-1
      if(jdel.gt.0)jnear=jpos+1
      idel=iabs(idel)
      jdel=iabs(jdel)
c *** do bilinear sum
      if(inear.lt.1.or.inear.gt.iklim)goto 100
      if(jnear.lt.1.or.jnear.gt.jklim)goto 200
      tempi=(isizy-jdel)*array(ipos,jpos)+jdel*array(ipos,jnear)
      tempj=(isizy-jdel)*array(inear,jpos)+jdel*array(inear,jnear)
      res=(tempi*(isizx-idel)+tempj*idel)*fsizsq
      return
  100 if(jnear.lt.1.or.jnear.gt.jklim)return
      res=(array(ipos,jpos)*(isizy-jdel)+array(ipos,jnear)*jdel)*fsizy
      return
  200 res=(array(ipos,jpos)*(isizx-idel)+array(inear,jpos)*idel)*fsizx
      return
      end

      subroutine bfilt(xbuf,nrec,npt,ifilt)
      real*4 xbuf(128,128),ybuf(128)
c *** BFILT does bilinear median and linear filtering on background values
      do k=1,npt
      do j=1,nrec
      ybuf(j)=xbuf(k,j)
      enddo
      call median(ybuf,nrec,ifilt)
      do j=1,nrec
      xbuf(k,j)=ybuf(j)
      enddo
      enddo
c *** and along rows
      do k=1,nrec
      do j=1,npt
      ybuf(j)=xbuf(j,k)
      enddo
      call median(ybuf,npt,ifilt)
      do j=1,npt
      xbuf(j,k)=ybuf(j)
      enddo
      enddo
c *** now repeat with linear filters down columns
      do k=1,npt
      do j=1,nrec
      ybuf(j)=xbuf(k,j)
      enddo
      call linear(ybuf,nrec,3)
      do j=1,nrec
      xbuf(k,j)=ybuf(j)
      enddo
      enddo
c *** and along rows
      do k=1,nrec
      do j=1,npt
      ybuf(j)=xbuf(j,k)
      enddo
      call linear(ybuf,npt,3)
      do j=1,npt
      xbuf(j,k)=ybuf(j)
      enddo
      enddo
      return
      end


      subroutine frdbufr(map,nxout,nyout)
c+
c read in a floating point r*4 fits image using
c the fitsio library
c
c-
	real*4 map(*)

        integer nxout,nyout
        integer naxes(4)

        real*4 nullval
        character*80 line,cards(36),title
        byte header(2880)

        logical prhdr,verdat,movhdu,simple,extend,anynull

c *** RDBUF reads in fits files and picks out required region
c ***       jeader is the FITS header returned to the calling routine
c ***       map is the 2-D array of i*2 data stored as a 1-D array 
c ***       nxout is the size of the axis most slowly varying in this array
c ***       nyout is the size of the axis most radiply varying.
 
	lt=6
  	lr=5
        buf=13
        pi=4.0*atan(1.0)
 5      write(lt,5000)
 5000	format(/'Assign input file'/'*',$)
	read(lr,5500)title
 5500	format(a80)
        iunit=1
        call ftopen(iunit,title,0,iblocksize,istatus)
        write(*,*) ' istatus= ',istatus,iblocksize
        call ft_check(istatus)
   
        movhdu=.false.
        call dmphdr(iunit,movhdu)
        call ft_check(istatus)

        imaxdim=4
        write(*,*) ' calling ftghpr '
        call ftghpr(iunit,imaxdim,simple,ibitpix,naxis,naxes,
     :   ipcount,igcount,extend,istatus)
        call ft_check(istatus)

        write(*,*) ibitpix,naxis,naxes(1),naxes(2)
        write(*,*) ipcount,igcount
        write(*,*) istatus

        call ft_check(istatus)

* select a range of data        
        ixstart=513
        iystart=513

        ixend=1024
        iyend=1024

        nxread=ixend-ixstart
        nyread=iyend-iystart

        nx=naxes(1)
        ny=naxes(2)

        nxout=nx
        nyout=ny

        igroup=1

* starting pixel in input fits file
*
*
        iy=iystart


        nullval=-9999.9
        write(*,*) ' read in the image data '
        ipixel=1

        do iy=iystart,iyend


          ifpixel=ixstart+(ny*(iy-1))          

	  if(mod(iy,100).eq.0)
     :     write(*,'(6i8)') iy,ifpixel,nfpixel,ipixel,nx,ny,map(ipixel)

          call ftgpve(iunit,igroup,ifpixel,nfpixel,nullval,
     :     map(ipixel),anynull,istatus)

          if(istatus .gt. 0) then
            write(*,*) ' io error ',nx,ny,ifpixel
          endif

	  if(mod(iy,100).eq.0)
     :     write(*,'(6i8)') iy,ifpixel,nfpixel,ipixel,nx,ny,map(ipixel)

          call ft_check(istatus)
      
          ipixel=ipixel+nx

        enddo

        write(*,*) ' finished reading the image data '


c *** end of read
  200   print *,' '
        print *,' '
	return

  997 stop ' Cannot open input file'
  999 stop ' Error or unexpected eof on read'
      end



      subroutine frdbufi
     : (iunit,map,ixstart,ixend,iystart,iyend,nxout,nyout,istatus)

c+
c read in a floating point r*4 fits image using
c the fitsio library
c
c-
	integer map(*)

        integer nxout,nyout
        integer naxes(4)

        integer nullval
        
        character*80 line,cards(36),title
        byte header(2880)

        logical prhdr,verdat,movhdu,simple,extend,anynull

c *** RDBUF reads in fits files and picks out required region
c ***       jeader is the FITS header returned to the calling routine
c ***       map is the 2-D array of i*2 data stored as a 1-D array 
c ***       nxout is the size of the axis most slowly varying in this array
c ***       nyout is the size of the axis most radiply varying.
 
	lt=6
  	lr=5

*        call ftopen(iunit,title,0,iblocksize,istatus)
*        write(*,*) ' istatus= ',istatus,iblocksize
*        call ft_check(istatus)
   
        movhdu=.false.
        call dmphdr(iunit,movhdu)
        call ft_check(istatus)

        imaxdim=4
        write(*,*) ' calling ftghpr '
        call ftghpr(iunit,imaxdim,simple,ibitpix,naxis,naxes,
     :   ipcount,igcount,extend,istatus)
        call ft_check(istatus)

        write(*,*) ibitpix,naxis,naxes(1),naxes(2)
        write(*,*) ipcount,igcount
        write(*,*) istatus

        call ft_check(istatus)

* select a range of data        
        nxread=(ixend-ixstart)+1
        nyread=(iyend-iystart)+1

        nx=naxes(1)
        ny=naxes(2)

        nxout=nxread
        nyout=nyread

        igroup=1

* starting pixel in input fits file
*
*
        iy=iystart

        nfpixel=nxread
        nullval=-9999.9
        write(*,*) ' read in the image data ',iystart,iyend,ny,ixstart,nfpixel
        ipixel=1
        istatus=0

        do iy=iystart,iyend

          ifpixel=ixstart+(ny*(iy-1))          

*          write(*,*) ipixel,ifpixel,nfpixel
  
          call ftgpvj(iunit,igroup,ifpixel,nfpixel,nullval,
     :     map(ipixel),anynull,istatus)


          if(istatus .gt. 0) then
            write(*,*) ' io error ',nx,ny,ifpixel,istatus
            call ft_check(istatus)
          endif

	  if(mod(iy,100).eq.0)
     :     write(*,'(8i8)') iy,ifpixel,nfpixel,ipixel,nx,ny,map(ipixel)


      
          ipixel=ipixel+nx

        enddo

        write(*,*) ' finished reading the image data '


c *** end of read
  200   print *,' '
        print *,' '
	return
  997	stop ' Cannot open input file'
  999	stop ' Error or unexpected eof on read'
	end




C---------------------------------------------------------------------------
        subroutine dmphdr(iunit,movhdu)

C       try to dump the keywords from the header that has a fatal format error

        integer iunit,status,nrec,i,ibuff,tmpend
        parameter (nrec = 10000)
        logical movhdu
        character keybuf*80
        
C       COMMON BLOCK DEFINITIONS:--------------------------------------------
        integer nb,ne
        parameter (nb = 12)
        parameter (ne = 128)
        integer bufnum,bufpnt,reclen,recnum,bytnum
        integer chdu,hdutyp,maxhdu,hdstrt,hdend,nxthdr,dtstrt,compid
        logical wrmode,modify

        common/ft0001/bufnum(199),bufpnt(nb),reclen(199),recnum(nb),
     &  bytnum(nb),wrmode(nb),modify(nb),chdu(nb),hdutyp(nb),maxhdu(nb),
     &  hdstrt(nb,ne),hdend(nb),nxthdr(nb),dtstrt(nb),compid
C       END OF COMMON BLOCK DEFINITIONS-----------------------------------

C       if movhdu is true then trick FITSIO into moving to the next extension
        if (movhdu)then
            ibuff=bufnum(iunit)
            chdu(ibuff)=chdu(ibuff)+1
C           temporarily set end of header to a very large number
            tmpend=hdend(ibuff)
            hdend(ibuff)=2000000000
        end if

        status=0
        call ftgrec(iunit,1,keybuf,status)

        if (status .eq. 0)then
*           call writit('Listing of header containing format error:')
            call writit(' ')
            call writit(keybuf)
        else
            call writit('Could not read header keywords.')
            call writit(' ')
            go to 900
        end if

        do 10 i=2,nrec
            call ftgrec(iunit,i,keybuf,status)
            if (status .eq. 0)call writit(keybuf)
            if (status .gt. 0 .or. keybuf(1:8) .eq. 'END     ')then
                call writit(' ')
                go to 900 
            end if
10      continue
        call writit(' ')
        call writit('*** Terminated header listing after '//
     &              '10000 keywords. ***')

900     continue
        if (movhdu)then
            chdu(ibuff)=chdu(ibuff)-1
C           reset end of headerr
            hdend(ibuff)=tmpend
        end if
        end 


        subroutine writit(string)
C       print out message to user or to output file
        character*(*) string

        logical tofile
        common /out/tofile

        if (tofile)then
             write(17,1000)string
1000         format(a)
        else
C  XXXX uncomment the appropriate output statement, depending on the version
C           fcecho is used in the FTOOLS version of this program
C           call fcecho(string)

C  XXXX     a write statement is used in the standalone version of this program
C           Must use PRINT on VAX/VMS, otherwise 1st character is lost
C           Must use WRITE on DECstation, otherwise extra space is inserted

            write(*,1000)string
C            print *,string
        end if
        end


      subroutine median(xbuf,npt,nfilt)
      real*4 xbuf(npt),ybuf(8704),array(512)
      integer*2 point(512)
c *** MEDIAN  performs median filtering on array xbuf
      if(nfilt.gt.511)stop ' too large a filter'
      if(npt.gt.8192)stop ' too many points in data array'
      if((nfilt/2)*2.eq.nfilt)nfilt=nfilt+1
      nfo2p1=nfilt/2+1
c *** set first and last edges equal 
      il=nfilt/2
      ilow=max0(3,nfilt/4)
      ilow=(ilow/2)*2+1
      do 100 i=1,ilow
  100 array(i)=xbuf(i)
      call sortm(array,point,ilow)
      xmns=array(ilow/2+1)
      do 150 i=1,ilow
  150 array(i)=xbuf(npt+1-i)
      call sortm(array,point,ilow)
      xmnf=array(ilow/2+1)
c *** reflect edges before filtering
      do 200 i=1,il
      ybuf(i)=2.0*xmns-xbuf(il+ilow+1-i)
  200 ybuf(npt+i+il)=2.0*xmnf-xbuf(npt-i-ilow+1)
      do 250 i=1,npt
  250 ybuf(i+il)=xbuf(i)
c *** do median filtering on rest
      do 260 i=1,nfilt
      array(i)=ybuf(i)
  260 point(i)=i
      call sortm(array,point,nfilt)
      xbuf(1)=array(nfo2p1)
      jl=nfilt+1
      jh=nfilt+npt-1
      do 400 j=jl,jh
      do 300 i=1,nfilt
      if(point(i).eq.1)goto 290
      point(i)=point(i)-1
      goto 300
  290 point(i)=nfilt
      array(i)=ybuf(j)
      l=i
  300 continue
      call qsort(array,point,l,nfilt)
  400 xbuf(j-jl+2)=array(nfo2p1)
      return
      end

      subroutine sortm(ia,ib,n)
      real*4 ia(n)
      integer*2 ib(n),iu
      real*4 it
      int=2
   10 int=2*int 
      if(int.lt.n)goto 10
      int=min0(n,(3*int)/4-1)
   20 int=int/2
      ifin=n-int
      do 70 ii=1,ifin
      i=ii
      j=i+int
      if(ia(i).le.ia(j))goto 70
      it=ia(j)
      iu=ib(j)
   40 ia(j)=ia(i)
      ib(j)=ib(i)
      j=i
      i=i-int
      if(i.le.0)goto 60
      if(ia(i).gt.it)goto 40
   60 ia(j)=it
      ib(j)=iu
   70 continue
      if(int.gt.1)goto 20
      return
      end

      subroutine qsort(x,point,l,nfilt)
      real*4 x(nfilt)
      integer*2 it,point(nfilt)
      test=x(l)
      do 100 i=1,nfilt
      if(i.eq.l)goto 100
      if(test.gt.x(i))goto 100
      j=i
      goto 200
  100 continue
      j=nfilt+1
  200 if(j-1.eq.l)return
      if(j-l)300,500,400
  300 temp=x(l)
      it=point(l)
      npt=l-j
      do 350 i=1,npt
      ii=l-i
      x(ii+1)=x(ii)
  350 point(ii+1)=point(ii)
      x(j)=temp
      point(j)=it
      return
  400 temp=x(l)
      it=point(l)
      j=j-1
      npt=j-l
      if(npt.eq.0)goto 475
      do 450 i=1,npt
      ii=l+i
      x(ii-1)=x(ii)
  450 point(ii-1)=point(ii)
  475 x(j)=temp
      point(j)=it
  500 return
      end




      subroutine linear(xbuf,npt,nfilt)
      real*4 xbuf(npt),ybuf(8704)
c *** LINEAR  performs boxcar filtering on array xbuf
      if(nfilt.gt.511)stop ' too large a filter'
      if(npt.gt.8192)stop ' too many points in data array'
      if((nfilt/2)*2.eq.nfilt)nfilt=nfilt+1
c *** set first and last edges equal 
      il=nfilt/2
      ilow=max0(3,nfilt/4)
      ilow=(ilow/2)*2+1
      sum=0.0
      do 100 i=1,ilow
  100 sum=sum+xbuf(i)
      xmns=sum/float(ilow)
      sum=0.0
      do 150 i=1,ilow
  150 sum=sum+xbuf(npt+1-i)
      xmnf=sum/float(ilow)
c *** reflect edges before filtering
      do 200 i=1,il
      ybuf(i)=2.0*xmns-xbuf(il+ilow+1-i)
  200 ybuf(npt+i+il)=2.0*xmnf-xbuf(npt-i-ilow+1)
      do 250 i=1,npt
  250 ybuf(i+il)=xbuf(i)
c *** do linear filtering on rest
      fnfilt=float(nfilt)
      sum=0.0
      do 300 i=1,nfilt
  300 sum=sum+ybuf(i)
      xbuf(1)=sum/fnfilt
      do 400 i=2,npt
      sum=sum-ybuf(i-1)
      sum=sum+ybuf(i+nfilt-1)
  400 xbuf(i)=sum/fnfilt
      return
      end


      subroutine pgintrom(nx,ny)
c      character*80 device
      common /pgt/ itype
c *** PGINTROM  sets up PGPLOT device
      itype=0
      ido=0
      call posei4('Do you want to alter default line width ? [N]',ido)
      if(ido.eq.1)then
        call geti4('Line width (1?)',ilw)
      endif
      call pgbegin(7,'?',nx,ny)
      if(ido.eq.1)call pgslw(ilw)
c *** set itype to -1 for no plot, 0 for TEK plot and 4 for Laser printer
c      call grinqdev(device)
c      ipos=index(device,'/TE')
c      if(ipos.ne.0)itype=0
c      ipos=index(device,'/NU')
c      if(ipos.ne.0)itype=-1
c      ipos=index(device,'/CA')
c      if(ipos.ne.0)itype=4      
c      ipos=index(device,'/BC')
c      if(ipos.ne.0)itype=4      
c *** line width
c      if(itype.gt.0)then
c        call geti4('Line width (1?)',ilw)
c	call pgslw(ilw)
c      endif
      return
      end


      subroutine fwrbufi
     : (iuniti,infile,iunito,outfile,imap,nxout,nyout,istatus)

c+
c write out floating point r*4 fits image using
c the fitsio library
c
c-
	integer*4 imap(*)

        integer nxout,nyout
        integer naxes(4)

        real*4 nullval
        character infile*(*),outfile*132

        character card*80

        byte header(2880)

        logical prhdr,verdat,movhdu,simple,extend,anynull

	lt=6
  	lr=5
   
        iunito=2

*      call getstr('Assign output file : ',outfile)

C     Delete the file if it already exists, so we can then recreate it
      call deletefile(outfile,istatus)


C     open the input FITS file, with readonly access
      ireadwrite=0
      call ftopen(iuniti,infile,ireadwrite,iblocksize,istatus)
      call ft_check(istatus)

C     create the new empty FITS file with the standard block size
      oblocksize=1
      call ftinit(iunito,outfile,iblocksize,istatus)
      call ft_check(istatus)

c
      call ftghsp(iuniti,nkeysexist,nkeysadd,istatus)
      write(*,*) ' number of header records : nkeysexist,nkeysadd : ',
     : nkeysexist,nkeysadd,iuniti,iunito

      do ikey=1,nkeysexist
*         write(*,*) ikey, iuniti,iunito,istatus
         call ftgrec(iuniti,ikey,card,istatus)
         call ftprec(iunito,card,istatus)
      enddo

      write(*,*) 'keywords written out: istatus : ',istatus

      call ft_check(istatus)
      if(istatus .ne. 0) write(*,*) 'keywords written out: istatus : ',istatus

C     copy the primary array from the input file to the output file
      morekeys=0

      igroup=1
      ifpixel=1
      nfpixel=nxout*nyout

      write(*,*) 'write the data array: istatus : ',istatus,nfpixel
      call ftpprj(iunito,igroup,ifpixel,nfpixel,
     :     imap,istatus)

      write(*,*) 'data array written out: istatus : ',istatus

      call ft_check(istatus)

      if(istatus .ne. 0) write(*,*) 'data array written out: istatus : ',istatus


C     close the FITS file and free the unit numbers
      call ftclos(iuniti, istatus)
      if(istatus .ne. 0) write(*,*) 'input unit closed: istatus : ',istatus
      call ftclos(iunito, istatus)
      if(istatus .ne. 0) write(*,*) 'output unit closed: istatus : ',istatus



C     check for any error, and if so print out error messages
      if (istatus .gt. 0) call printerror(istatus)

      write(*,*) 'exiting fwrbufi '

      end


      subroutine fwrbufr(iunit,infile,map,nxout,nyout)
c+
c write out floating point r*4 fits image using
c the fitsio library
c
c-
	real*4 map(*)

        integer nxout,nyout
        integer naxes(4)

        real*4 nullval
        character infile*(*),outfile*132

        byte header(2880)

        logical prhdr,verdat,movhdu,simple,extend,anynull

	lt=6
  	lr=5
   
        iunito=2

      call getstr('Assign output file : ',outfile)

C     Delete the file if it already exists, so we can then recreate it
      call deletefile(outfile,istatus)


C     open the input FITS file, with readonly access
      ireadwrite=0
      call ftopen(iunit,infile,ireadwrite,iblocksize,istatus)

C     create the new empty FITS file with the standard block size
      oblocksize=1
      call ftinit(iunito,outfile,iblocksize,istatus)

C     copy the primary array from the input file to the output file
      morekeys=0
      call ftcopy(iunit,iunito,morekeys,istatus)


C     close the FITS file and free the unit numbers
      call ftclos(iunit, istatus)
      call ftclos(iunito, istatus)


C     check for any error, and if so print out error messages
      if (istatus .gt. 0)call printerror(istatus)

      end




      subroutine cookbook

C     this is just a simple main program that calls all the example subroutines

      call writeimage
      call writeascii
      call writebintable
      call copyhdu
      call selectrows
      call readheader
      call readimage
      call readtable

      end

      subroutine writeimage

C     Create a FITS primary array containing a 2-D image

      integer status,unit,blocksize,bitpix,naxis,naxes(2)
      integer i,j,group,fpixel,nelements,array(300,200)
      character filename*80
      logical simple,extend

 1    status=0
C     Name of the FITS file to be created:
      filename='ATESTFILEZ.FITS'

C     Delete the file if it already exists, so we can then recreate it
 2    call deletefile(filename,status)

C     Get an unused Logical Unit Number to use to open the FITS file
 3    call ftgiou(unit,status)

C     create the new empty FITS file
      blocksize=1
 4    call ftinit(unit,filename,blocksize,status)

C     initialize parameters about the FITS image (300 x 200 16-bit integers)
      simple=.true.
      bitpix=16
      naxis=2
      naxes(1)=300
      naxes(2)=200
      extend=.true.

C     write the required header keywords
 5    call ftphpr(unit,simple,bitpix,naxis,naxes,0,1,extend,status)

C     initialize the values in the image with a linear ramp function
      do j=1,naxes(2)
          do i=1,naxes(1)
              array(i,j)=i+j
          end do
      end do

C     write the array to the FITS file
      group=1
      fpixel=1
      nelements=naxes(1)*naxes(2)
 6    call ftpprj(unit,group,fpixel,nelements,array,status)

C     write another optional keyword to the header
 7    call ftpkyj(unit,'EXPOSURE',1500,'Total Exposure Time',status)

C     close the file and free the unit number
 8    call ftclos(unit, status)
      call ftfiou(unit, status)

C     check for any error, and if so print out error messages
 9    if (status .gt. 0)call printerror(status)
      end
      subroutine writeascii

C     Create an ASCII table containing 3 columns and 6 rows

      integer status,unit,readwrite,blocksize,tfields,nrows,rowlen
      integer nspace,tbcol(3),diameter(6), colnum,frow,felem
      real density(6)
      character filename*40,extname*16
      character*16 ttype(3),tform(3),tunit(3),name(6)
      data ttype/'Name','Diameter','Density'/
      data tform/'A8','I6','F4.2'/
      data tunit/' ','km','g/cm'/
      data name/'Mercury','Venus','Earth','Mars','Jupiter','Saturn'/
      data diameter/4880,12112,12742,6800,143000,121000/
      data density/5.1,5.3,5.52,3.94,1.33,0.69/

 1    status=0
C     Name of the FITS file to append the ASCII table to:
      filename='ATESTFILEZ.FITS'

C     Get an unused Logical Unit Number to use to open the FITS file
 2    call ftgiou(unit,status)

C     open the FITS file, with write access
 3    readwrite=1
      call ftopen(unit,filename,readwrite,blocksize,status)

C     append a new empty extension onto the end of the primary array
 4    call ftcrhd(unit,status)

C     define parameters for the ASCII table (see the above data statements)
      tfields=3
      nrows=6
      extname='PLANETS_ASCII'
      
C     calculate the starting position of each column, and the total row length
      nspace=1
 5    call ftgabc(tfields,tform,nspace,rowlen,tbcol,status)

C     write the required header parameters for the ASCII table
 6    call ftphtb(unit,rowlen,nrows,tfields,ttype,tbcol,tform,tunit,
     &            extname,status)

C     write names to the first column, diameters to 2nd col., and density to 3rd
      frow=1
      felem=1
      colnum=1
 7    call ftpcls(unit,colnum,frow,felem,nrows,name,status)
      colnum=2
      call ftpclj(unit,colnum,frow,felem,nrows,diameter,status)  
      colnum=3
      call ftpcle(unit,colnum,frow,felem,nrows,density,status)  

C     close the FITS file and free the unit number
 8    call ftclos(unit, status)
      call ftfiou(unit, status)

C     check for any error, and if so print out error messages
 9    if (status .gt. 0)call printerror(status)
      end
      subroutine writebintable

C     Create a binary table containing 3 columns and 6 rows

      integer status,unit,readwrite,blocksize,hdutype,tfields,nrows
      integer varidat,diameter(6), colnum,frow,felem
      real density(6)
      character filename*40,extname*16
      character*16 ttype(3),tform(3),tunit(3),name(6)
      data ttype/'Name','Diameter','Density'/
      data tform/'8A','1J','1E'/
      data tunit/' ','km','g/cm'/
      data name/'Mars','Jupiter','Saturn','Uranus','Neptune','Pluto'/
      data diameter/6800,143000,121000,47000,45000,6000/
      data density/3.94,1.33,0.69,1.56,2.27,1.0/

 1    status=0
C     Name of the FITS file to append the ASCII table to:
      filename='ATESTFILEZ.FITS'

C     Get an unused Logical Unit Number to use to open the FITS file
 2    call ftgiou(unit,status)

C     open the FITS file, with write access
 3    readwrite=1
      call ftopen(unit,filename,readwrite,blocksize,status)

C     move to the last (2nd) HDU in the file
 4    call ftmahd(unit,2,hdutype,status)

C     append/create a new empty HDU onto the end of the file and move to it
 5    call ftcrhd(unit,status)

C     define parameters for the binary table (see the above data statements)
      tfields=3
      nrows=6
      extname='PLANETS_BINARY'
      varidat=0
      
C     write the required header parameters for the binary table
 6    call ftphbn(unit,nrows,tfields,ttype,tform,tunit,
     &            extname,varidat,status)

C     write names to the first column, diameters to 2nd col., and density to 3rd
      frow=1
      felem=1
      colnum=1
 7    call ftpcls(unit,colnum,frow,felem,nrows,name,status)
      colnum=2
      call ftpclj(unit,colnum,frow,felem,nrows,diameter,status)  
      colnum=3
      call ftpcle(unit,colnum,frow,felem,nrows,density,status)  

C     close the FITS file and free the unit number
 8    call ftclos(unit, status)
      call ftfiou(unit, status)

C     check for any error, and if so print out error messages
 9    if (status .gt. 0)call printerror(status)
      end

      subroutine copyhdu

C     copy the 1st and 3rd HDUs from the input file to a new FITS file

      integer status,inunit,outunit,readwrite,blocksize,morekeys,hdutype
      character infilename*40,outfilename*40

 1    status=0
C     Name of the FITS files:
      infilename='ATESTFILEZ.FITS'
      outfilename='BTESTFILEZ.FITS'

C     Delete the file if it already exists, so we can then recreate it
 2    call deletefile(outfilename,status)

C     Get  unused Logical Unit Numbers to use to open the FITS files
 3    call ftgiou(inunit,status)
      call ftgiou(outunit,status)

C     open the input FITS file, with readonly access
      readwrite=0
 4    call ftopen(inunit,infilename,readwrite,blocksize,status)

C     create the new empty FITS file with the standard block size
      blocksize=1
 5    call ftinit(outunit,outfilename,blocksize,status)

C     copy the primary array from the input file to the output file
      morekeys=0
 6    call ftcopy(inunit,outunit,morekeys,status)

C     append/create a new empty extension on the end of the output file
 7    call ftcrhd(outunit,status)

C     skip to the 3rd extension in the input file
 8    call ftmahd(inunit,3,hdutype,status)

C     copy this extension from the input file to the output file
 9    call ftcopy(inunit,outunit,morekeys,status)  

C     close the FITS file and free the unit numbers
 10   call ftclos(inunit, status)
      call ftclos(outunit, status)
 11   call ftfiou(-1, status)

C     check for any error, and if so print out error messages
 12   if (status .gt. 0)call printerror(status)
      end

      subroutine selectrows

C     select rows from an input table and copy them to the output table

      integer status,inunit,outunit,readwrite,blocksize,hdutype
      integer nkeys,nspace,naxes(2),nfound,colnum,frow,felem
      integer noutrows,irow,temp(100),i
      real nullval,density(6)
      character infilename*40,outfilename*40,record*80
      logical exact,anynulls

 1    status=0
C     Names of the FITS files:
      infilename='ATESTFILEZ.FITS'
      outfilename='BTESTFILEZ.FITS'

C     Get  unused Logical Unit Numbers to use to open the FITS files
 2    call ftgiou(inunit,status)
      call ftgiou(outunit,status)

C     open the FITS files, with the appropriate read/write access
      readwrite=0
 3    call ftopen(inunit,infilename,readwrite,blocksize,status)
      readwrite=1
      call ftopen(outunit,outfilename,readwrite,blocksize,status)

C     move to the 3rd HDU in the input file (a binary table in this case)
 4    call ftmahd(inunit,3,hdutype,status)

C     move to the last extension in the output file
 5    do while (status .eq. 0)
          call ftmrhd(outunit,1,hdutype,status)
      end do

      if (status .eq. 107)then
C         this is normal; it just means we hit the end of file
          status=0
 6        call ftcmsg
      end if

C     create a new empty extension in the output file
 7    call ftcrhd(outunit,status)

C     find the number of keywords in the input table header
 8    call ftghsp(inunit,nkeys,nspace,status)

C     copy all the keywords from the input to the output extension
 9    do i=1,nkeys
          call ftgrec(inunit,i,record,status)
          call ftprec(outunit,record,status)
      end do

C     force FITSIO to read the output file keywords to define the data structure
 10   call ftrdef(outunit,status)
C     get the width of the table (in bytes) and the number of rows
 11   call ftgknj(inunit,'NAXIS',1,2,naxes,nfound,status)

C     find which column contains the DENSITY values
      exact=.false.
 12   call ftgcno(inunit,exact,'DENSITY',colnum,status)

C     read the DENSITY column values
      frow=1
      felem=1
      nullval=-99.
 13   call ftgcve(inunit,colnum,frow,felem,naxes(2),nullval,
     &            density,anynulls,status)

C     If the density is less than 3.0, copy the row to the output table
      noutrows=0
 14   do irow=1,naxes(2)
          if (density(irow) .lt. 3.0)then
              noutrows=noutrows+1
 15           call ftgtbb(inunit,irow,1,naxes(1),temp,status)
              call ftptbb(outunit,noutrows,1,naxes(1),temp,status)
          end if
      end do

C     update the NAXIS2 keyword with the correct no. of rows in the output file
 16   call ftmkyj(outunit,'NAXIS2',noutrows,'&',status)

C     close the FITS file and free the unit numbers
 17   call ftclos(inunit, status)
      call ftclos(outunit, status)
      call ftfiou(-1, status)

C     check for any error, and if so print out error messages
 18   if (status .gt. 0)call printerror(status)
      end
      subroutine readheader

C     Print out all the header keywords in all extensions of a FITS file

      integer status,unit,readwrite,blocksize,nkeys,nspace,hdutype,i
      character filename*80,record*80

 1    status=0

C     Get an unused Logical Unit Number to use to open the FITS file
 2    call ftgiou(unit,status)

C     name of FITS file 
      filename='ATESTFILEZ.FITS'

C     open the FITS file, with read-only access
      readwrite=0
 3    call ftopen(unit,filename,readwrite,blocksize,status)

100   continue

C     Determine the number of keywords in the header
 4    call ftghsp(unit,nkeys,nspace,status)

C     Read each 80-character keyword record, and print it out
      do i = 1, nkeys
 5        call ftgrec(unit,i,record,status)
          print *,record
      end do

C     Print out and END record, and a blank line to mark the end of the header
      if (status .eq. 0)then
          print *,'END'
          print *,' '
      end if

C     try moving to the next extension in the FITS file, if it exists
 6    call ftmrhd(unit,1,hdutype,status)

      if (status .eq. 0)then
C         success, so loop back and print out keywords in this extension
 7        go to 100

      else if (status .eq. 107)then
C         hit end of file, so quit
 8        print *,'***** END OF FILE *****'
          status=0
          call ftcmsg
      end if

C     close the file, free the unit number, and exit
 9    call ftclos(unit, status)
      call ftfiou(unit, status)

C     check for any error, and if so print out error messages
 10   if (status .gt. 0)call printerror(status)
      end
      subroutine readimage

C     Read a FITS image and determine the minimum and maximum pixel value

      integer status,unit,readwrite,blocksize,naxes(2),nfound
      integer group,firstpix,nbuffer,npixels,i
      real datamin,datamax,nullval,buffer(100)
      logical anynull
      character filename*80

 1    status=0

C     Get an unused Logical Unit Number to use to open the FITS file
 2    call ftgiou(unit,status)

C     open the FITS file previously created by WRITEIMAGE
      filename='ATESTFILEZ.FITS'
      readwrite=0
 3    call ftopen(unit,filename,readwrite,blocksize,status)

C     determine the size of the image
 4    call ftgknj(unit,'NAXIS',1,2,naxes,nfound,status)

C     check that it found both NAXIS1 and NAXIS2 keywords
 5    if (nfound .ne. 2)then
          print *,'READIMAGE failed to read the NAXISn keywords.'
          return
       end if

C     initialize variables
      npixels=naxes(1)*naxes(2)
      group=1
      firstpix=1
      nullval=-999
      datamin=1.0E30
      datamax=-1.0E30

      do while (npixels .gt. 0)
C         read up to 100 pixels at a time 
          nbuffer=min(100,npixels)
      
 6        call ftgpve(unit,group,firstpix,nbuffer,nullval,
     &            buffer,anynull,status)

C         find the min and max values
          do i=1,nbuffer
              datamin=min(datamin,buffer(i))
              datamax=max(datamax,buffer(i))
          end do

C         increment pointers and loop back to read the next group of pixels
          npixels=npixels-nbuffer
          firstpix=firstpix+nbuffer
      end do

C     print out the min and max values
      print *,'Min and max values in the image are:',datamin,datamax

C     close the file and free the unit number
 7    call ftclos(unit, status)
      call ftfiou(unit, status)

C     check for any error, and if so print out error messages
 8    if (status .gt. 0)call printerror(status)
      end
      subroutine readtable

C     read and print data values from an ASCII or binary table

      integer status,unit,readwrite,blocksize,hdutype,ntable
      integer felem,nelems,nullj,diameter,nfound,irow,colnum
      real nulle,density
      character filename*40,nullstr*1,name*8,ttype(3)*10
      logical anynull

 1    status=0

C     Get an unused Logical Unit Number to use to open the FITS file
 2    call ftgiou(unit,status)

C     open the FITS file previously created by WRITEIMAGE
      filename='ATESTFILEZ.FITS'
      readwrite=0
 3    call ftopen(unit,filename,readwrite,blocksize,status)

C     loop twice, first reading the ASCII table, then the binary table
 4    do ntable=1,2

C         move to the next extension
 5        call ftmrhd(unit,1,hdutype,status)

          print *,' '
          if (hdutype .eq. 1)then
              print *,'Extension ',ntable,' is an ASCII table.'
          else if (hdutype .eq. 2)then
              print *,'Extension ',ntable,' is a binary table.'
          end if

C         read the TTYPEn keywords, which give the names of the columns
 6        call ftgkns(unit,'TTYPE',1,3,ttype,nfound,status)
          write(*,2000)ttype
2000      format(8x,3a10)

C         read the data, one row at a time, and print them out
          felem=1
          nelems=1
          nullstr=' '
          nullj=0
          nulle=0.
          do irow=1,6
              colnum=1
 7            call ftgcvs(unit,colnum,irow,felem,nelems,nullstr,name,
     &                    anynull,status)
              colnum=2
 8            call ftgcvj(unit,colnum,irow,felem,nelems,nullj,diameter,
     &                    anynull,status)
              colnum=3
 9            call ftgcve(unit,colnum,irow,felem,nelems,nulle,density,
     &                    anynull,status)
              write(*,2001)irow,name,diameter,density
2001          format(i4,a10,i10,f10.2)
          end do
      end do

C     close the file and free the unit number
 10   call ftclos(unit, status)
      call ftfiou(unit, status)

C     check for any error, and if so print out error messages
 11   if (status .gt. 0)call printerror(status)
      end

      subroutine printerror(status)

C     Print out the FITSIO error messages to the user

      integer status
      character errtext*30,errmessage*80

C     check if status is OK (no error); if so, simply return
      if (status .le. 0)return

C     get the text string which describes the error
 1    call ftgerr(status,errtext)
      print *,'FITSIO Error Status =',status,': ',errtext

C     read and print out all the error messages on the FITSIO stack
 2    call ftgmsg(errmessage)
      do while (errmessage .ne. ' ')
          print *,errmessage
          call ftgmsg(errmessage)
      end do
      end
      subroutine deletefile(filename,status)

C     A simple little routine to delete a FITS file

      integer status,unit,blocksize
      character*(*) filename

C     simply return if status is greater than zero
      if (status .gt. 0)return

C     Get an unused Logical Unit Number to use to open the FITS file
 1    call ftgiou(unit,status)

C     try to open the file, to see if it exists
 2    call ftopen(unit,filename,1,blocksize,status)

      if (status .eq. 0)then
C         file was opened;  so now delete it 
 3        call ftdelt(unit,status)
      else if (status .eq. 103)then
C         file doesn't exist, so just reset status to zero and clear errors
          status=0
 4        call ftcmsg
      else
C         there was some other error opening the file; delete the file anyway
          status=0
 5        call ftcmsg
          call ftdelt(unit,status)
      end if

C     free the unit number for later reuse
 6    call ftfiou(unit, status)
      end









