      real*4 map(2048*2048),bmap(2048*2048)
      real*4 gridx(2048),gridy(2048),coord(2048),reflev(2048)
      real*4 back(128,128),work(4096)
      byte header(2880),buf
c *** DRIFT  does driftscan-type filtering on array map usual coordinate
c ***        system ie. y -->  and x |
c ***                                V
c ***   NB.  Now includes option for dealing with varying backgrounds
      lr=5
      lt=6
      buf=13
c *** clear correction arrays
      do i=1,2048
      gridx(i)=1.0
      gridy(i)=1.0
      coord(i)=i-0.5
c      reflev(i)=1.0
      reflev(i)=0.0
      enddo
c *** get data in disk fits format
      call rdbuf(header,map,nxout,nyout)
      npt=nyout
      nrec=nxout
      ifilt=1
      ifiltx=1
      call posei4
     1 ('Do you want to filter in both directions ? [Y]',ifilt)
      if(ifilt.eq.0)call posei4
     1 ('column direction only ? [Y] otherwise row direction',ifiltx)
      iback=1
      call posei4('Deal with background variations ? [Y]',iback) 
      isizx=64
      isizxo2=isizx/2
      fsizx=1.0/float(isizx)
      isizy=64
      isizyo2=isizy/2
      fsizy=1.0/float(isizy)
      fsizsq=fsizx*fsizy
c
c *** estimate overall backgrounds
c
      if(iback.eq.1)then
        iklim=(nrec-1)/isizx+1
        jklim=(npt-1)/isizy+1
        do i=1,iklim
        do j=1,jklim
        ilow=(i-1)*isizx+1
        ihih=min(nrec,i*isizx)
        jlow=(j-1)*isizy+1
        jhih=min(npt,j*isizy)
        npix=0
        do ii=ilow,ihih
        iii=(ii-1)*npt
        do jj=jlow,jhih
        npix=npix+1
        work(npix)=map(iii+jj)
        enddo
        enddo
        call sort1(work,npix)
        back(i,j)=work(npix/2)
        enddo
        enddo
c *** pad edge values if necessary
        if(iklim*isizx-nrec.gt.isizxo2)then
	  do j=1,jklim
  	  back(iklim,j)=back(iklim-1,j)
          enddo
        endif
        if(jklim*isizy-npt.gt.isizyo2)then
	  do i=1,iklim
  	  back(i,jklim)=back(i,jklim-1)
          enddo
        endif
c *** filter the backgrounds
        call bfilt(back,iklim,jklim,5)
c
c *** find average sky value
c
        sky=0.0
        nsky=0
        do i=1,iklim
        do j=1,jklim
        nsky=nsky+1
        sky=sky+back(i,j)
        enddo
        enddo
        sky=sky/float(nsky)
c
c *** interpolate backgrounds and subtract from map
c
        do i=1,nrec
        ii=(i-1)*npt
        write(lt,'(i8,a,$)') i,buf
        do j=1,npt
        call binterp(back,iklim,jklim,i,j,res,isizx,isizxo2,fsizx,
     1               isizy,isizyo2,fsizy,fsizsq)
c *** set sky to average sky value
        temp=map(ii+j)-res+sky
        bmap(ii+j)=map(ii+j)-temp
        map(ii+j)=temp
        enddo
        enddo
      endif
c *** find corrections for columns
      print *,'Filtering now'
      if(ifilt.eq.1.or.ifiltx.eq.1)then
        sum=0.0   
        do k=1,npt
        write(lt,'(i8,a,$)') k,buf
        do j=1,nrec
        jj=(j-1)*npt
        work(j)=map(jj+k)
        enddo
        call sort1(work,nrec)
        gridy(k)=work(nrec/2)
        sum=sum+gridy(k)
        enddo
c *** to keep same arithmetic mean - could alternatively use geometric
        sum=sum/float(npt)
        cmin=1.0e6
        cmax=-1.0e6
        do k=1,npt
c        gridy(k)=sum/gridy(k)
        gridy(k)=sum-gridy(k)
        cmin=min(cmin,gridy(k))
        cmax=max(cmax,gridy(k))
        enddo
      endif
      print *,' '
c *** find corrections for rows
      if(ifilt.eq.1.or.ifiltx.eq.0)then
        sum=0.0
        do k=1,nrec
        write(lt,'(i8,a,$)') k,buf
        kk=(k-1)*npt
        do j=1,npt
        work(j)=map(kk+j)
        enddo
        call sort1(work,npt)
        gridx(k)=work(npt/2)
        sum=sum+gridx(k)
        enddo
c *** to keep same arithmetic mean - could alternatively use geometric
        sum=sum/float(nrec)
        do k=1,npt
c        gridx(k)=sum/gridx(k)
        gridx(k)=sum-gridx(k)
        cmin=min(cmin,gridx(k))
        cmax=max(cmax,gridx(k))
        enddo
      endif
      print *,' '
c *** lets have some plots
      call pgintrom(1,2)
      call pgenv(0.0,float(npt),cmin,cmax,0,0)
      call pglabel('Column number','Correction',' ')
      call pgsls(2)
      call pgline(npt,coord,reflev)
      call pgsls(1)
      call pgline(npt,coord,gridy)
      call pgenv(0.0,float(nrec),cmin,cmax,0,0)
      call pglabel('Row number','Correction',' ')
      call pgsls(2)
      call pgline(nrec,coord,reflev)
      call pgsls(1)
      call pgline(nrec,coord,gridx)
      call pgextro
c *** now apply the corrections
      do k=1,nrec
      kk=(k-1)*npt
      do j=1,npt
c      temp=map(kk+j)*gridx(k)*gridy(j)
      temp=map(kk+j)+gridx(k)+gridy(j)
c *** and put background variations back on if necessary
      if(iback.eq.1)temp=temp+bmap(kk+j)
      map(kk+j)=temp
      enddo
      enddo
c *** write output array in -32 bit disk fits format
      call wtbuf(header,map,nxout,nyout)
      stop
      end

      subroutine sort1(ia,n)
      real*4 ia(n),it
      int=2
   10 int=2*int
      if(int.lt.n)goto 10
      int=min0(n,(3*int)/4-1)
   20 int=int/2
      ifin=n-int
      do 70 ii=1,ifin
      i=ii
      j=i+int
      if(ia(i).le.ia(j))goto 70
      it=ia(j)
   40 ia(j)=ia(i)
      j=i
      i=i-int
      if(i.le.0)goto 60
      if(ia(i).gt.it)goto 40
   60 ia(j)=it
   70 continue
      if(int.gt.1)goto 20
      return
      end

      subroutine binterp(array,iklim,jklim,i,j,res,isizx,isizxo2,
     1                   fsizx,isizy,isizyo2,fsizy,fsizsq)
      real*4 array(128,128)
c *** BINTERP  does bilinear interpolation on array
      ipos=(i-1)/isizx+1
      jpos=(j-1)/isizy+1
      res=array(ipos,jpos)
c *** find 4 adjacent points
      idel=i-isizx*ipos+isizxo2
      jdel=j-isizy*jpos+isizyo2
      inear=ipos-1
      if(idel.gt.0)inear=ipos+1
      jnear=jpos-1
      if(jdel.gt.0)jnear=jpos+1
      idel=iabs(idel)
      jdel=iabs(jdel)
c *** do bilinear sum
      if(inear.lt.1.or.inear.gt.iklim)goto 100
      if(jnear.lt.1.or.jnear.gt.jklim)goto 200
      tempi=(isizy-jdel)*array(ipos,jpos)+jdel*array(ipos,jnear)
      tempj=(isizy-jdel)*array(inear,jpos)+jdel*array(inear,jnear)
      res=(tempi*(isizx-idel)+tempj*idel)*fsizsq
      return
  100 if(jnear.lt.1.or.jnear.gt.jklim)return
      res=(array(ipos,jpos)*(isizy-jdel)+array(ipos,jnear)*jdel)*fsizy
      return
  200 res=(array(ipos,jpos)*(isizx-idel)+array(inear,jpos)*idel)*fsizx
      return
      end

      subroutine bfilt(xbuf,nrec,npt,ifilt)
      real*4 xbuf(128,128),ybuf(128)
c *** BFILT does bilinear median and linear filtering on background values
      do k=1,npt
      do j=1,nrec
      ybuf(j)=xbuf(k,j)
      enddo
      call median(ybuf,nrec,ifilt)
      do j=1,nrec
      xbuf(k,j)=ybuf(j)
      enddo
      enddo
c *** and along rows
      do k=1,nrec
      do j=1,npt
      ybuf(j)=xbuf(j,k)
      enddo
      call median(ybuf,npt,ifilt)
      do j=1,npt
      xbuf(j,k)=ybuf(j)
      enddo
      enddo
c *** now repeat with linear filters down columns
      do k=1,npt
      do j=1,nrec
      ybuf(j)=xbuf(k,j)
      enddo
      call linear(ybuf,nrec,3)
      do j=1,nrec
      xbuf(k,j)=ybuf(j)
      enddo
      enddo
c *** and along rows
      do k=1,nrec
      do j=1,npt
      ybuf(j)=xbuf(j,k)
      enddo
      call linear(ybuf,npt,3)
      do j=1,npt
      xbuf(j,k)=ybuf(j)
      enddo
      enddo
      return
      end

	subroutine rdbuf(jeader,map,nxout,nyout)
	real*4 map(*)
        integer*2 ibuf(14400)
        integer*4 jbuf(7200)
        real*4 rbuf(7200)
        character*80 line,cards(36),title
        byte header(2880),work(28800),jeader(2880),buf
        equivalence (header(1),cards(1))
	equivalence (work(1),ibuf(1))
        equivalence (work(1),jbuf(1))
        equivalence (work(1),rbuf(1))
       	common /fil/ istart,istop,nword,ixl,ixh
        common /rdf/ tpa,tpd,aa,bb,cc,dd,ee,ff,ira
c *** RDBUF reads in fits files and picks out required region
c ***       jeader is the FITS header returned to the calling routine
c ***       map is the 2-D array of i*2 data stored as a 1-D array 
c ***       nxout is the size of the axis most slowly varying in this array
c ***       nyout is the size of the axis most radiply varying.
 
	lt=6
  	lr=5
        buf=13
        pi=4.0*atan(1.0)
 5      write(lt,5000)
 5000	format(/'Assign input file'/'*',$)
	read(lr,5500)title
 5500	format(a80)
        open(unit=1,name=title,status='old',form='unformatted',
     1       access='direct',fileopt="buffer=2880",recl=2880,err=5)
c *** NB recl is in bytes on SUN
        call filinf(ibuf,1,ny,nx)
   	iq=1
        ii=0
	do while (ii.le.14400-ny)
          read(1'iq,err=10) (ibuf(i+ii),i=1,ny)
          iq=iq+1
          ii=ii+ny
        enddo
   10   nbyte=2*ii
        do i=1,2880
        header(i)=work(i)
        enddo
c
c *** borrowed from DFITSR
c
      do i=1,36
      ii=(i-1)*80
      do k=1,80
c *** put in blank for null 
      if(header(ii+k).eq.0)header(ii+k)=32
      jeader(ii+k)=header(ii+k)
      enddo
      line=cards(i)
      enddo
c *** check for 
      line=cards(2)
      read(line(11:80),*,err=85,end=85)nobits
      inob=1
      if(nobits.lt.0)inob=-1
      nobits=iabs(nobits)
      mpt=1440
      if(nobits.eq.32)mpt=720
      line=cards(3)
      read(line(11:80),*,err=85,end=85)noaxes
      line=cards(4)
      read(line(11:80),*,err=85,end=85)nword
      line=cards(5)
      read(line(11:80),*,err=85,end=85)nrec
      if(noaxes.eq.1)nrec=1
 2000 format(i5)
      if(nrec.ne.0.and.nword.ne.0)goto 90
   85 call geti4('No. of words per record',nword)
      call geti4('No. of records',nrec)
   90 continue
      write(lt,1500) nword,nrec
 1500 format(/'FITS header information:',/,
     1 '                          No. of words per record =',i8,/,
     2 '                          No. of records in file  =',i8/)
      iend=0
      bscale=1.0
      bzero=0.0
      ibscale=0
      ibzero=0
      ira=0
      isl=1
      ish=2880
   94 continue
      do 99 i=1,36
c *** check for BSCALE or BZERO
      line=cards(i)
      if(line(1:6).eq.'BSCALE')then
	read(line(11:80),*,err=95,end=95) bscale
	if(bscale.ne.1.0)ibscale=1
      endif
   95 if(line(1:5).eq.'BZERO')then
	read(line(11:80),*,err=96,end=96) bzero
	if(bzero.ne.0.0)ibzero=1
      endif
c *** try and write only the useful header info
   96 if(line(8:8).eq.'='.or.line(9:9).eq.'='.or.line(10:10).eq.'=')
     1  write(lt,1550) line
 1550 format(1x,a80)
      if(line(1:6).eq.'OBJECT'.or.line(1:7).eq.'COMMENT')
     1   write(lt,1550) line
c *** check for END
      if(line(1:3).eq.'END')iend=1
   99 continue
      if(iend.ne.1)then
	isl=isl+2880
	ish=ish+2880
	if(ish.gt.nbyte)stop ' too many header records'	
	do i=isl,ish
	header(i-isl+1)=work(i)
	enddo
	goto 94
      endif
c *** finished header
      ilose=0
      if(nobits.eq.16)then
	call posei4('Is the data 16 bit unsigned integer ? [N]',ilose)
      endif
      ivax=0
      if(nobits.eq.16)then
	call posei4('Is the data VAX integer*2 format ? [N]',ivax)
      endif
      if(nobits.eq.16.and.ibscale.eq.1.and.ibzero.eq.1)then
        iapp=0
        call posei4('Do you wany to apply Bscale and Bzero ? [N]',iapp)
        if(iapp.eq.0)then
          bscale=1.0
          bzero=0.0
        endif
      endif
c ***
        istart=1
	istop=nrec
	ixl=1
	ixh=nword
	nxout=istop-istart+1
	nyout=ixh-ixl+1
	npix=nxout*nyout
	if(npix.gt.2048*2048)stop ' Too many pixels for buffer'
c *** reset iq pointer to start of data
	iq=iq-(nbyte-ish)/2880
c *** initialise map pointer and pixel positioner
	ipix=(((istart-1)*nword+ixl-1)/mpt)*mpt
 	ii=0
c *** now find first and last records to read
        iqfirst=iq+((istart-1)*nword+ixl-1)/mpt
        iqlast=iq+((istop-1)*nword+ixh-1)/mpt+1
c *** and read them
        print *,' '
        print *,'Reading file'
	do iq=iqfirst,iqlast
	read(1'iq,err=200) (ibuf(i),i=1,ny)
        if(jmod(k,32).eq.0)write(lt,8000) iq,buf
 8000	format(i8,a,$)
	if(ivax.eq.1)call swbyte(ibuf,mpt)
	do i=1,mpt
 	ii=ii+1
	if(ii.gt.npix)goto 200
	if(nobits.eq.32)then
	  if(inob.eq.1)t=bscale*jbuf(i)+bzero
 	  if(inob.eq.-1)t=bscale*rbuf(i)+bzero
	  map(ii)=t  
	else
c *** signed 16 bit
	  if(ilose.eq.0)then
	    it=nint(bscale*float(ibuf(i))+bzero)
	    it=max(-32768,it)
	    map(ii)=min(32767,it)
	  else
c *** unsigned 16 bit lose lsb
	    it=nint(bscale*float(ibuf(i))+bzero)
	    if(it.lt.0)then
	      map(ii)=(65536+it)/2
	    else
	      map(ii)=it/2
	    endif
	  endif
	endif
   	enddo
  	enddo
c *** end of read
  200   print *,' '
        print *,' '
	return
  997	stop ' Cannot open input file'
  999	stop ' Error or unexpected eof on read'
	end

      subroutine swbyte(ibuf,ilen)
      integer*2 ibuf(ilen),ir
      byte is(2),it
      equivalence (ir,is(1))
c *** swaps bytes for integer*2
      do 100 i=1,ilen
      ir=ibuf(i)
      it=is(1)
      is(1)=is(2)
      is(2)=it
  100 ibuf(i)=ir
      return
      end

	subroutine wtbuf(jeader,map,nxout,nyout)
	real*4 map(*),ibuf(720)
        character*9 label1,label2,label3,label4,label5,label6
        character*80 line,cards(36),title
        byte header(2880),jeader(2880),buf
        equivalence (header(1),label1),(header(81),label2),
     1  (header(161),label3),(header(241),label4),
     2  (header(321),label5),(header(401),label6)
        equivalence (header(1),cards(1))
c *** WTBUF writes out images in disk FITS -32 bit (ie. real*4) format
c ***       jeader is the notional header supplied by the calling routine
c ***       map is the 2-D array of i*2 data stored as a 1-D array 
c ***       nxout is the size of the axis most slowly varying in this array
c ***       nyout is the size of the axis most radiply varying.
	lt=6
	lr=5
        buf=13
	do i=1,2880
	header(i)=jeader(i)
        enddo
    5   write(lt,5000)
 5000	format(/'Assign output file'/'*',$)
	read(lr,5500) title
 5500	format(a80)
	open(unit=21,name=title,status='new',access='direct',
     1       recl=2880,err=5)
	iqo=1
	npix=nxout*nyout
c *** FITS header - put in new array size if necessary and make sure 16 bit
c ***      and END keyword present
	iend=0
	do i=1,36
        line=cards(i)
	if(line(1:6).eq.'END   ')iend=1
	if(line(1:6).eq.'NBITS'.or.line(1:6).eq.'BITPIX')then
	  line(28:28)='-'
	  line(29:29)='3'
	  line(30:30)='2'
	  if(line(1:6).eq.'NBITS')line(1:6)='BITPIX'
	endif
	if(line(1:6).eq.'NAXIS1')then	
	  read(line(11:80),*,err=85)ny
	  if(ny.ne.nyout)then
	    write(line(11:30),*,err=85)nyout
	  endif
	endif
	if(line(1:6).eq.'NAXIS2')then
	  read(line(11:80),*,err=85)nx
	  if(nx.ne.nxout)then
	    write(line(11:30),*,err=85)nxout
	  endif
	endif
        if(line(1:6).eq.'BSCALE')then
	  bscale=1.0
	  write(line(11:30),1111) bscale
 1111	  format(e15.5)
        endif
     	if(line(1:5).eq.'BZERO')then
     	  bzero=0.0
	  write(line(11:30),1111) bzero
        endif
	if(i.eq.36.and.iend.eq.0)then
	  do j=1,80
	  line(j:j)=' '
	  enddo
	  line(1:3)='END'
	endif
 	cards(i)=line
        enddo
c *** write out new header
   85	write(21'iqo,err=999) header
        iqo=iqo+1
	irec=1
	ii=0
	print *,' '
	do i=1,npix
	ii=ii+1
	ibuf(ii)=map(i)
	if(ii.eq.720)then
	  ii=0
	  write(21'iqo,err=999) ibuf
          iqo=iqo+1
	  irec=irec+1
	  iblock=(2880*irec)/512
	  if(mod(irec,64).eq.0)write(lt,8000) iblock,buf
 8000	  format(i8,a,$)
	endif
	enddo
c *** write out last bit
        print *,' '
        print *,' '
	if(ii.ne.0)then
	  write(21'iqo,err=999) ibuf
          iqo=iqo+1
	endif
	close (unit=21)
	return
  997 	stop ' Cannot open output file'
  998	stop ' Cannot close output file'
  999	stop ' Error on disk output'
	end


