# IRAF script -- csubsky
#  function: to subtract the sky
#	
# programmer: sjchan (january 1997, oct1997)
#   history:  jan97   --  created: irsubsky.cl
#             oct97   --  modified: cirsubsky.cl
#             23jan98 --  renamed to csubsky.cl
#             5april98 -- scale the sky frame with objmed/skymed
#                           
#

procedure csubsky(frame_in,file_sky)

string	frame_in   {"",prompt="(@List or *.fits) Input images",mode="ql"}
string  file_sky  {"",prompt="Name of the irsky frame",mode="ql"}
struct  *fskylist, *fobjlist, *olist

begin
        string  ftmpi          #i list of input images string
        string  fsky           #i name of the irsky frame
        string  framein        #i the input image
        string  frameout       #o the output sky-subtracted image
        string  ifile,ofile    #the final version of input and output
        string  csubskylog    #o the logfile
        string   ind           #i indicator (ind=S)
        string  fmsky          # temporary file (containing skymedian value)
        string  fmobj          # temporay file (containing objmedian value)
        string  nfsky          # temporay sky-scaled image
        int     icount         # dummy counter
        real    skymean        # median of the input sky image
        real    objmean        # median of the input object+sky image
        real    scale          # scaling factor (objmean/skymean)
        real    ts1            # dummy variable (sky median)
        real    to1            # dummy variable (obj median)
   

        #  Get the rest of the parameter

          ftmpi=frame_in      
          fsky=file_sky

          csubskylog="csubsky.log"
          ind="S"    # dummy definition
          ifile="csdummy1"
          ofile="csdummy2"
          icount=0
          scale=1.0
     
        #  Check the existence of the logfile
           if (access(csubskylog))
             delete(csubskylog, ver-, >& "dev$null")
           if (access(ifile))
             delete(ifile, ver-, >& "dev$null")
           if (access(ofile))
             delete(ofile, ver-, >& "dev$null")
		
        #  Find out the suitable input option

           _finout(ftmpi, ind, ifile, ofile)

        #  Make name for temporary files

           fmsky=mktemp("fmsky")
           fmobj=mktemp("fmobj")

        #  Find out the mean of the sky frame

           imstatistic(fsky, fields="midpt", lower=INDEF, 
             upper=INDEF, binwidth=0.0001, format=no, > fmsky)

        #  Find out the mean of the obj+sky frame

           imstatistic("@"//ifile, fields="image,midpt",
              lower=INDEF, upper=INDEF,binwidth=0.0001, format=no, >> fmobj)

        #  Get the scaling factors to suit each obj+sky frame

           fskylist = fmsky
           fobjlist = fmobj
           olist = ofile
 
          while (fscan(fskylist, ts1) !=EOF)
          {
            print("", >> csubskylog)
            print("sky image: ", fsky, >> csubskylog)
            skymean = ts1
            print("median sky = ",skymean, >> csubskylog)
            while( (fscan(fobjlist, framein, to1) !=EOF) && 
                   (fscan(olist, frameout) !=EOF) )
             {
               if (access(frameout))
                 imdelete(frameout, ver-, >& "dev$null")

               icount +=1
               objmean = to1
               print("",>> csubskylog)
               print(framein//" is being processed ...")
               print(framein//" is being processed ...", >> csubskylog)

               if (skymean != 0.0)
                   scale = objmean/skymean
               else
                 scale = 1.0

               print("median obj+sky = ",objmean, 
                     "scale (objmed/skymed) = ",scale, >> csubskylog)
               print("",>> csubskylog)

               nfsky=mktemp("nfsky")

            # make scaled sky frame
              imarith(operand1=fsky, op="*", operand2=scale,
               result=nfsky, title="", divzero=0., hparams="", 
               pixtype="real", calctype="real", verbose=yes, 
               noact=no, >> csubskylog) 
      
            # subtract the sky

              imarith(operand1=framein, op="-", operand2=nfsky,
                result=frameout, title="", divzero=0., hparams="", 
                pixtype="real", calctype="real", verbose=yes, 
                noact=no, >> csubskylog) 

              imdelete (nfsky, ver-, >& "dev$null")

        # updated the title and the flag in the image header 
 
              _irheadup(frameout,ind)

             }   # the closing bracket from "while obj loop"

          }   # the closing bracket from "while sky loop"

          fskylist = ""; fobjlist = ""   # close the files
          olist = ""
          # Cleaning up

          imdelete(nfsky, ver-, >& "dev$null")
          delete(ifile//","//ofile, ver-, >& "dev$null")
          delete(fmsky//","//fmobj, ver-, >& "dev$null")

	  print ("CSUBSKY done.")   

end

