# IRAF script -- cmkrrrcimg
#	
#   function:  to produce RC-RRR images from
#               case 1: non-RC-RRR images, calling crrrimg.cl 
#               case 2: RC-RRR images from pixcel, calling crrr2rrrc 
#                         in order to change the filename to make the 
#                         package understand them (default)
#                 both have noise-correction option
#
# programmer: sjchan 
#
#    status:   case1: need data to test crrrimg
#
#    history:  2April98: created
#        
#

procedure cmkrrrcimg(rrrfin, tfold, tquad, rrrfout, reset, stripe, ansort, pixty, calty)

string	rrrfin  {"",prompt="(@List/*.fits or .imh) of Input RRR images from PC",mode="ql"}
int     tfold  {min=1, prompt="total number of folds for a fixed-pos obs",mode="ql"}
int     tquad  {16, prompt="total number of quadrants", mode="ql"}
string  rrrfout  {"rrrc_inputname", prompt="List of lists of output RC-RRR images", mode="ql"}
bool    reset {yes, prompt="Reset have been corrected by Pixcel?", mode="ql"}
string  stripe   {"NO", prompt="Destriping correction option (MB/B/R/C/NO)"}
bool    ansort   {yes, prompt="Sort the input list?"}
string  pixty  {"real", prompt="pixtype of output images", mode="ql"}
string  calty {"real", prompt="calctype for IMARITH operation", mode="ql"}



begin

        string  rrrfin1   #i input file list of lists
        int     tfold1    #i total number of folds for a fixed-pos obs
        int     tquad1    #i total number of quadrants
        string  rrrfout1  #o list of lists of output RC-RRR images
        bool    reset1    #i Reset have been corrected by Pixcel
        string  stripe1   #i Destriping correction option (B/R/C/NO)
        bool    ansort1    # sort the input list
        string  pixty1     # pixtype of output images
        string  calty1     # calctype of output images
        string  templog   # temporary logfile (crrr2rrrc.log or crrrimg.log)
        string  cmkrrrcimglog # logfile of cmkrrrcimg


      

      #  Get the rest of the parameters

        rrrfin1  = rrrfin
        tfold1   = tfold
        tquad1   = tquad
        rrrfout1 = rrrfout
        reset1   = reset
        stripe1  = stripe
        ansort1  = ansort
        pixty1   = pixty
        calty1   = calty
        cmkrrrcimglog = "cmkrrrcimg.log"
        if (reset1)
           templog = "crrr2rrrc.log"
        else
           templog = "crrrimg.log"
        

   # Check existence of output files

      if (access(cmkrrrcimglog))
            delete(cmkrrrcimglog, ver-, >& "dev$null")
      if (access(rrrfout1))
            delete(rrrfout1, ver-, >& "dev$null")

   # choose the suitable option to make suitable RC-RRR images

      if (reset1)
         {
           print("")
           print("Rset correction has been performed by Pixcel")
           crrr2rrrc (rrrfin1, tfold1, tquad1, rrrfout1, ansort1, stripe1)
           print("")
         } # this brace is from if block (reset)
      else
         {
           print("")
           print("Reset corrections will be performed")
           crrrimg(rrrfin1, tfold1, pixty1, calty1, ansort1)
               # should be:   crrrimg("@"//rrrfin1, tfold1, tquad1, rrrfout1, 
                                #pixty1, calty1, ansort1, stripe1)
           
           print("")
         } # this brace is from if-else block (reset), i.e. (!reset option)


      unlearn type
      type (templog, >> cmkrrrcimglog)


          print("   << ========= CMKRRRCIMG DONE =========== >>")
          beep; beep; beep

end

