# IRAF script -- cmkobj.cl
# funtion: to make a combined object frame 
#          (interal coadding or general coaddeing)
#	
# programmer: sjchan (january, March, May 1997)
#              Modified: March 1997 -- add offset option
#                  Usage: if use offset option in imcombine, user need to 
#                         enter the offset file name.
#                         default : offset="none"!!!
#                        May 1997 -- add n_end == "0" option (general combine)
#                        15apr98 -- temporary turn off to get "nfolds" to get
#                                    from the header until the meaning of
#                                    "nfolds" is clear
#                        11aug98 -- add an option to use pset
#		21april99 -- mhoenig: changed script so that no longer
#			      does an imcombine when only 1 fold - faster!
#

procedure cmkobj(frame_in,frame_out, n_start, n_end, oset, useropt)

string	frame_in   {"",prompt="(@List of/ *.fits) Input images",mode="ql"}
string  frame_out  {"",prompt="Output image (combined)",mode="ql"}
string  n_start    {"1", prompt="The start fold number for combination", mode="ql"}
string  n_end      {"0",prompt="The end fold number for combination",mode="ql"}
string  oset       {"none",prompt="The offset file name if you use the offset option", mode="ql"}
bool    useropt    {no, prompt="User option to input IMCOMBINE parameters", mode="ql"}
pset    mkobjpar {prompt="Imcombine parameters to make coadded images"}


struct  *filist

begin
        string  frameout         # Output combined image
        string  ftmpi            # List of input image
        string  frametemp        # input image
        string  ftemp            # dummy variable	
        string  fintemp          # final list of input for "imcombine"
        string  ifile, ofile     # final version of input and output
        string  comblog          # logfile
        string  indc             # indicator
        string  nstart           # the start of the fold
        string  nend             # the end of the fold
        bool    useropt1             # user chance to choose IMCOMBINE paras
        int     nl, nh           # value of nlow and nhigh for imcombine
        int     icount1, icount2 # the 1st number and the last number 
                                 # in the fold
        int     ic               # counter (dummy variable)
        int     icount           # counter: count the number of objects in 
                                  # the list
        string  offile           # dummy variable for offset file
        string  offtemp          # final version of offset file
        string  fold            # curent fold num for the given input in string
        int     ifold           # current fold number for the given input
        string  sfold       # current fold number for the given input (string)
        int     fold1, fold2     # dummy variables
        string  ss1              # dummy variable
        string  s2
        int     i

       # IMCOMINBE parameters (user choose)
         string p_sigma, p_plfile, p_combine, p_reject, p_offsets, p_masktyp
         string p_scale, p_weight, p_statsec, p_expname, p_zero
         string p_rdnoise, p_gain
         real p_maskval, p_blank, p_lthresh, p_hthresh
         real p_lsigma, p_hsigma, p_pclip, p_sigscale
	 int  p_nlow, p_nhigh, p_nkeep, p_grow


        #  Get the rest of the parameter

        ftmpi=frame_in
        frameout=frame_out
        nstart = n_start
        nend = n_end
        offile=oset
        useropt1 =  useropt
        comblog="cmkobj.log"
        ind="C"       # dummy definition
        icount1= int(nstart)
        icount2 = int(nend)
        icount = 0; ic = 0
        ifile="dummy1"
        ofile="dummy2"
        offtemp="dummy3"
        nh=0
        nl=0
        fold = "1"

        #IMCOMBINE parameters

        p_sigma  = mkobjpar.o_sigma
        p_plfile = mkobjpar.o_plfile
        p_combine = mkobjpar.o_combine
        p_reject = mkobjpar.o_reject
        p_masktyp = mkobjpar.o_masktyp
        p_maskval = mkobjpar.o_maskval
        p_blank = mkobjpar.o_blank
        p_scale = mkobjpar.o_scale
        p_zero = mkobjpar.o_zero
        p_weight = mkobjpar.o_weight
        p_statsec = mkobjpar.o_statsec
        p_expname = mkobjpar.o_expname
        p_lthresh = mkobjpar.o_lthresh
        p_hthresh = mkobjpar.o_hthresh
        p_nlow = mkobjpar.o_nlow
        p_nhigh = mkobjpar.o_nhigh
        p_nkeep = mkobjpar.o_nkeep
        p_lsigma = mkobjpar.o_lsigma
        p_hsigma = mkobjpar.o_hsigma
        p_rdnoise = mkobjpar.o_rdnoise
        p_gain = mkobjpar.o_gain
        p_sigscale = mkobjpar.o_sigscale
        p_pclip = mkobjpar.o_pclip
        p_grow = mkobjpar.o_grow

		
        #  Check the existence of the logfile
           if (access(comblog))
             delete(comblog, ver-, >& "dev$null")
           if (access(ifile))
             delete(ifile, ver-, >& "dev$null")
           if (access(ofile))
             delete(ofile, ver-, >& "dev$null")
           if (access(offtemp))
             delete(offtemp, ver-, >& "dev$null")
           if (access(frameout))
             imdelete(frameout, ver-, >& "dev$null")

        #  Find out the suitable input option

           _finout(ftmpi, indc, ifile, ofile)
          
        # Make name for temproary files

          fintemp=mktemp("fseli")

        # Read the file 'ifile' choosing the right files
       
        i = 0
        filist = ""; filist = ifile
        while (fscan(filist,frametemp) !=EOF)
         {
           i += 1
          # check whether BPM is in the header
           if (i == 1)
              {
                imgets(frametemp, param = "BPM", >& "dev$null")
                s2 = imgets.value
              }           
           if (nend == "0") 
             { # For general (full) combination
                icount += 1
                print(frametemp, >> fintemp)
             }
           else
             {# For selected fold combination:
               ic += 1
              #  Find out the fold number from the header
              #  imgets(frametemp,para="nfolds")
              # sfold = imgets.value
              # ss1 = substr(sfold, 1, 1)
              # if ((sfold == "") || (sfold == "0") || (ss1 == "/"))
              #   {  # can't find the foldvalue in the header
              #      # to locate the fold number from the filename
              #     print("")
              #      print("   Cannot find the fold number from the header!!")
              #     print("       Try filename")

                   _locate(frametemp,"_") # locate the last "_" in the string
                   fold1 = _locate.value
                   _locate(frametemp, "p") # locate the last "p" in the string
                   fold2 = _locate.value
                   fold = substr(frametemp, fold1+1, fold2-1)
                   if ((fold1 > 0) && (fold2 > 0))
                      ifold = int(fold)
                   else
                     {
                       print("Can't find total number of folds in filename!")
                       print(" Using nend as total fold number.")
                       ifold = icount2  # use icount2 as total fold number
                      }

               # }
               #  else
               #   ifold = int(imgets.value)
     
                 if ((ifold >= icount1) && (ifold <= icount2))
                   {
                    icount += 1
                     print(frametemp, >> fintemp)
                   }
              } #this brace is from the if (nend == "0")else fold(fold combine)

          }  # this brace is from the while block
          filist = "" #close the file

          # print ("icount = ", icount)

        # Make a suitable offset file which is consistence with the 
        # selected frames

        if (offile != "none")  # use offset option
          if (nend != "0") # For series combination
            _offsetfin(offile, offtemp, icount1, icount2, icount)
          else
            copy(offile, offtemp, ver-) # for general combination
        else
           offtemp=offile   # for non-offset combination

    
        if (icount > 20) 
         {
           nh=5
           nl=10
         }
        if ( (icount > 15) && (icount <=20) )
         {
             nh= 4
             nl= 7
         }
        if ( (icount > 10) && (icount <=15) )
         {
             nh= 2
             nl= 4
         }
        if ( (icount > 4) && (icount <=10) )
         {   nh = 1
             nl = 2
         }
        if ( (icount > 2) && (icount <= 4) )
         {
             nh = 0
             nl = 1
         }

       if (nstart>=nend)
       		{
		print ("Just 1 fold! Only renaming image.")
		imcopy ("@"//fintemp, frameout, ver+, >> comblog)
		}
       
       else if (!useropt1)
          {
            unlearn imcombine
            if (s2 != "0") #keyword BPM in the header
              imcombine.masktype = "goodvalue"
            else
              imcombine.masktype = "none"     

            imcombine("@"//fintemp,frameout,combine="average", reject="minmax",
            project=no, outtype="real", offset=offtemp, 
            maskvalue=0, blank=0, scale="median", zero="none", weight="none",
            expname="", statsec="", nlow=nl, nhigh=nh, logfile=comblog)
          }
        else
          {
            imcombine("@"//fintemp, frameout, sigma=p_sigma, plfile=p_plfile, 
              combine=p_combine,reject=p_reject, project=no, outtype = "real",
              offsets="none", masktype=p_masktyp, maskvalue=p_maskval, 
              blank=p_blank, scale=p_scale, zero=p_zero, weight=p_weight, 
              statsec=p_statsec, expname=p_expname, lthresh=p_lthresh, 
              hthresh=p_hthresh, nlow=p_nlow, nhigh=p_nhigh, nkeep=p_nkeep, 
              mclip+, lsigma=p_lsigma, hsigma=p_hsigma, rdnoise=p_rdnoise, 
              gain=p_gain, sigscale=p_sigscale, pclip=p_pclip, grow=p_grow, 
              logfile=comblog)
          } #this brace is from if-else block (useropt1 == yes)

        delete (fintemp//","//ofile//","//ifile, ver-, >& "dev$null")
        if (offile != "none")
           delete (offtemp, ver-, >& "dev$null")
        filist=""

	print ("CMKOBJ done.")

end




