# IRAF script -- cmkdark.cl
#
#   to combine the dark frames
#     imcombine: rejection algorithm - sigclip
#	
# programmer: sjchan 
#       history: (july 97, oct97) -- created
#                 2july98 -- modified (to add an option to make a
#                              nomalized dark.
#                            _checkfit was turned off (.fits will be checked
#                              anymore
#                10aug98 -- to support to use badpix masks
#                11aug98 -- add an option to use pset
#

procedure cmkdark(frame_in,frame_out, scalfac, n_start, useropt)

string	frame_in   {"",prompt="(@List of / *.fits) Input images",mode="ql"}
string  frame_out  {"",prompt="Output image (combined frame)",mode="ql"}
bool    scalfac    {yes, prompt="Make a nomalized dark frame", mode="ql"}
int     n_start    {1 , prompt="The start #th fold for combination", mode="ql"}
bool    useropt    {no, prompt="User option to input IMCOMBINE parameters", mode="ql"}
pset    mkdarkpar {prompt="Imcombine parameters to make dark images"}

string  check      {prompt="check exposure time in the header"}

struct  *filist

begin
        string  ftmpi      #i list of input images
        string  frameout   #o output image name
        bool    scalfac1   #i prompt to make a normalized dark
        int     nstart     #i the start fold-th for combination
        bool    useropt1   # user option to inut IMCOMBIN parameters
        string  framein    #i input image name
        string  fintemp    #i temporary file containing final verion of inputs
        string  ifile      #i final verison of the input list
        string  cdarklog   #o logfile
        int     leni       # dummy variable (total length of input list string)
        int     icount, ic # counters
        int     nh,nl      # nhigh, nlow for imcombine
        string  sscale     # scaling factor (exptime) from header in string
        real    scale      # scaling factor (real)
        string  tsdark     # temporary individual nomalized dark
        string  s2

       # IMCOMINBE parameters (user choose)
         string p_sigma, p_plfile, p_combine, p_reject, p_offsets, p_masktyp
         string p_scale, p_weight, p_statsec, p_expname, p_zero
         string p_rdnoise, p_gain
         real p_maskval, p_blank, p_lthresh, p_hthresh
         real p_lsigma, p_hsigma, p_pclip, p_sigscale
	 int  p_nlow, p_nhigh, p_nkeep, p_grow

        #  Get the rest of the parameter

        ftmpi=frame_in
        frameout=frame_out
        nstart = n_start
        scalfac1 = scalfac
        useropt1 = useropt 
        cdarklog="cmkdark.log"
        icount=0
        leni=0
        ic = 0
        tsdark = "tsdark.fits"  #dummy definition
        check = "G"

        #IMCOMBINE parameters

        p_sigma  = mkdarkpar.d_sigma
        p_plfile = mkdarkpar.d_plfile
        p_combine = mkdarkpar.d_combine
        p_reject = mkdarkpar.d_reject
        p_masktyp = mkdarkpar.d_masktyp
        p_maskval = mkdarkpar.d_maskval
        p_blank = mkdarkpar.d_blank
        p_scale = mkdarkpar.d_scale
        p_zero = mkdarkpar.d_zero
        p_weight = mkdarkpar.d_weight
        p_statsec = mkdarkpar.d_statsec
        p_expname = mkdarkpar.d_expname
        p_lthresh = mkdarkpar.d_lthresh
        p_hthresh = mkdarkpar.d_hthresh
        p_nlow = mkdarkpar.d_nlow
        p_nhigh = mkdarkpar.d_nhigh
        p_nkeep = mkdarkpar.d_nkeep
        p_lsigma = mkdarkpar.d_lsigma
        p_hsigma = mkdarkpar.d_hsigma
        p_rdnoise = mkdarkpar.d_rdnoise
        p_gain = mkdarkpar.d_gain
        p_sigscale = mkdarkpar.d_sigscale
        p_pclip = mkdarkpar.d_pclip
        p_grow = mkdarkpar.d_grow
		
        #  Check the existence of the logfile

           if (access(cdarklog))
               delete(cdarklog, ver-, >& "dev$null")
           if (access(frameout))
               imdelete(frameout, ver-, >& "dev$null")

        #  Find out the suitable input option

        leni=strlen(ftmpi)

        if (stridx(ftmpi, "@") == 1)
           ifile = substr(ftmpi, 2, leni)
        else
         {
           ifile = mktemp("fin")
           sections(ftmpi, option="fullname", > ifile)
         }

        # Make name for temproary files

          fintemp=mktemp("fseli")

        # Read the file 'ifile' containing the names of imagefiles

        filist = ""; filist = ifile #open the file
        while (fscan(filist,framein) !=EOF)
         {
          ic += 1
  
          # check whether BPM is in the header
            if (ic == 1)
              {
                imgets(framein, param = "BPM", >& "dev$null")
                s2 = imgets.value
              }
            
          if (ic >= nstart)
            {
              icount += 1
          # get the exposure time from image header
             if (scalfac1)
               {
                 imgets(framein, param="exptime")
                 sscale = imgets.value
                 if ( (sscale == "") || (sscale == "0") || (sscale == "/") )
                   {
                     print("")
                     print("     Bad exptime keyword in the header")
                     print("Using hedit to put exptime into the header")
                     check = "B"
                     filist = "" # close the file
                     bye
                   }
                 else
                    scale = real(sscale)

              } #this brace is from if-block (scalfac1 == yes)
             else 
               scale = 1.0

         #nomalized the darks
             if (scale <= 0.0)
                 scale = 1.0

          # make a temporary name for individual nomalized dark
             tsdark = "z"//framein
             
          # check the existence of the file (tsdark)
             if (access(tsdark))
                delete(tsdark, ver-, >& "dev$null")

             unlearn imarith
             imarith(operand1=framein, op="/", operand2=scale,
                result=tsdark, title="", divzero=0., hparams="", 
                pixtype="real", calctype="real", verbose=yes, 
                noact=no, >> cdarklog)

            print (tsdark, >> fintemp)

           } # this brace is from if-block (ic >= nstart)

        } #this brace is from while-block (filist, framein) 
          filist = "" #close the file

      print ("icount =", icount)

      if (!useropt1)
        {
      unlearn imcombine
      if (s2 != "0") #keyword BPM in the header
              imcombine.masktype = "goodvalue"
       else
              imcombine.masktype = "none"

      if (icount >= 4)     # weight zero = median
        imcombine("@"//fintemp, frameout, combine="average", reject="sigclip",
          project=no, outtype="real", offset="none",
          maskvalue=0, blank=0, scale="none", zero="median", weight="none",
          expname="", statsec="", mclip+, logfile=cdarklog)
       else      # weight zero = none
         imcombine("@"//fintemp, frameout, combine="average", reject="sigclip",
          project=no, outtype="real", offset="none", 
          maskvalue=0, blank=0, scale="none", zero="none", weight="none",
          expname="", statsec="", mclip+, logfile=cdarklog)

          } #this brace is from if-block (useropt == no)
        else
          {
            imcombine("@"//fintemp, frameout, sigma=p_sigma, plfile=p_plfile, 
              combine=p_combine,reject=p_reject, project=no, outtype = "real",
              offsets="none", masktype=p_masktyp, maskvalue=p_maskval, 
              blank=p_blank, scale=p_scale, zero=p_zero, weight=p_weight, 
              statsec=p_statsec, expname=p_expname, lthresh=p_lthresh, 
              hthresh=p_hthresh, nlow=p_nlow, nhigh=p_nhigh, nkeep=p_nkeep, 
              mclip+, lsigma=p_lsigma, hsigma=p_hsigma, rdnoise=p_rdnoise, 
              gain=p_gain, sigscale=p_sigscale, pclip=p_pclip, grow=p_grow, 
              logfile=cdarklog)
          } #this brace is from if-block (userop == yes)

        # Cleaning up 
        delete("@"//fintemp, ver-, >& "dev$null")
        delete (fintemp,ver-, >& "dev$null")

        if (stridx(ftmpi, "@") != 1) 
           delete (ifile, ver-, >& "dev$null")

        print("    <<======= cmkdark DONE ======>>")
        #beep; beep; beep

end
