# IRAF script -- chiptrans.cl
#
#   function: to transpose the chip-images into right orientation
#              (North -- UP)
#
#
# programmer: sjchan, mhoenig
#
#  history: 11feb98 -- created
#           12mar98 -- add update header information (using _irheadup)
#           07may98 -- added INT transpose option (mhoenig)
#           23mar99 -- just discovered that sjchan's version was in fact rotating
#                      *all* the chips for the WHT orientation, then rotating them
#                      all by 180 deg. again if INT - this is a ridiculous waste
#                      of I/O, so replacing it with my version (ie. this one)
#	  28april99 - mhoenig: added indc="QTR" option (ie. transposed single
#		       quadrants), without which the list files weren't being
#		       found (see comments in _finout).
#
#     chiptrans <-- _finout
#               <-- _irheadup

procedure chiptrans(imglist, telescope)

string	imglist   {"",prompt="(@List of/ *.fits) Input images",mode="ql"}
string  telescope {"WHT", prompt="Telescopes to be used (WHT/INT)", mode="ql"}

struct *filist, *folist

begin
        string  imglist1       #i list of input images
        string  tele1          #i telscopes to be used
        string  framein        #o input frame
        string  frameout       #o output frame
        string  ifile, ofile   #io list of final input and output list
        string  chiptranslog      #o logfile
        string  indc           #  indicator
        string  schip          #i chip number in string
        int     icc            #  dummy counter
        int     naxis          # length of axis 
        string  sec[3]         # the tranpose section information

        #  Get the rest of the parameter

	imglist1 = imglist
        tele1 = telescope
        chiptranslog = "chiptrans.log"
        indc="TR"       # option for transpose
	if (substr(cndrproc.quadnos, 1, 1)=="q") indc="QTR"  # transpose; quadrants only

        sec[1] = "[-*,-*]"  # chip1 - wht
        sec[2] = "[*,-*]"   # chip2 - wht
        sec[3] = "[-*,*]"   # chip4 - wht
        ifile=mktemp("ifl")
        ofile=mktemp("ofl")

       if (access(chiptranslog))
             delete(chiptranslog, ver-, >& "dev$null")

        #  Find out the suitable input option

        _finout(imglist1, indc, ifile, ofile)

	print("Telescope: ", tele1, >> chiptranslog)
        print("", >> chiptranslog)   
        cache imgets   # need this action due to a bug in imgets
      # Read the input list and output list
        icc = 0
        filist = ""; folist = ""    # make sure the files are closed
        filist = ifile; folist = ofile    # open the files
	
        while((fscan(filist,framein) !=EOF) && (fscan(folist,frameout) !=EOF))
          {
             icc += 1
             if (icc == 1)
               {
                imgets(framein, param ="i_naxis1")
                 naxis = int(imgets.value)
                 if (naxis == 0)
                    naxis = 1024
               }
             if (access(frameout))
                imdelete(frameout, ver-, >& "dev$null")
  
          # get chip information from the header
             imgets(framein, param="chip")
             schip = imgets.value
             if ( (schip == "") || (schip == "0") || (schip == "/") )
               {
                print("CHIPNO value is bad in the header! Trying filename ...")

                  _locchipno(framein)
                   schip = _locchipno.schipno
                  if (schip == "0") 
                    {
                      print("Please check your input data again.")
                       bye    # exit the program
                    }
                }   # this brace is from if else block (search chipno from 
                     # filename           
             print("", >> chiptranslog)
	     print ("Transposing chip "//schip//" ...")
             print ("chip number: ", schip, >> chiptranslog)

             # do the transpose - check first whether WHT or INT. 
             # NB. all these if statements might not be the pinnacle of elegant
             # programming, but they certainly result in a much faster program
             # (cf. my comments at top)

             if (tele1 == "WHT")
               {
                 if (schip == "1")
                   imcopy (framein//sec[2], frameout, ver+, >> chiptranslog)
                 if (schip == "2")
                   {
                     print("imtranspose ",framein//sec[2], " ---> ",frameout, 
                       >> chiptranslog)
                     imtranspose(framein//sec[2], frameout, len_blk=naxis)
                   }
                 if (schip == "3")
                   imcopy(framein, frameout, ver+, >> chiptranslog)
                 if (schip == "4")
                   {
                     print("imtranspose ",framein//sec[3], " ---> ",frameout, 
                       >> chiptranslog)
                     imtranspose(framein//sec[3], frameout, len_blk=naxis)
                   }
               }  # this brace is from tele1 == "WHT"

             if (tele1 == "INT")
               {
                 if (schip == "3")
                   imcopy (framein//sec[1], frameout, ver+, >> chiptranslog)
                 if (schip == "4")
                   {
                     print("imtranspose ",framein//sec[2], " ---> ",frameout, 
                       >> chiptranslog)
                     imtranspose(framein//sec[2], frameout, len_blk=naxis)
                   }
                 if (schip == "1")
                   imcopy(framein, frameout, ver+, >> chiptranslog)
                 if (schip == "2")
                   {
                     print("imtranspose ",framein//sec[3], " ---> ",frameout, 
                       >> chiptranslog)
                     imtranspose(framein//sec[3], frameout, len_blk=naxis)
                   }
               }  # this brace is from tele1 == "INT"

       #    Update header information
            if (substr(cndrproc.quadnos, 1, 1)=="q") indc="TR"  # change back again
	    _irheadup(frameout, indc)

          } # this brace is from while block(filist, framein),(folist,frameout)

       #  cleaning up
          delete(ifile, ver-, >& "dev$null")
          delete(ofile, ver-, >& "dev$null")

             print("CHIPTRANS done.")

end

