# IRAF script -- _rcmedian
#                
#    function: to make R/C median filter 
#	
#    stage: 
# programmer: sjchan 
#             26jan98: created
#           
##

procedure _rcmedian(frame_in, naxis, file_out, frame_out)

string frame_in   {"", prompt="Input frame", mode="ql"}
int     naxis     {512, prompt="Size of input frame", mode="ql"}
string file_out   {"", prompt="Output file of R/C median", mode="ql"}
string frame_out  {"", prompt="Output frame of R/C median", mode="ql"}
string flag       {"G",prompt="indicator for wtextimage"}

struct *flist

begin

     string framein        # input frame
     int    naxis1         # size of the input frame
     string fileout        # final output file of R/C median 
     string frameout       # final output image of R/C median
     string tfl            # initial version output file of R/C median 
     string tframe2        # initial version output image of R/C median
     string expcal         # the expression in IMEXPR
     real   rcmed          # the R/C median
     real   summed         # the sum of the R/C median
     real   mrcmed         # the mean of the R/C median
     real   frcmed         # the final version of the R/C median
     int    nrc            # the size of the text file
     string snrc           # the size of the text file in string
     string ss1            # dummy variable, line number counter
     int    iss1           # dummy variable, line number counter in integer
     string fflag          # flag to indicate the length of the file
     real   x1, x2         # dummy variables (never use)

     # Get the rest of the parameter
     framein    = frame_in
     naxis1     = naxis
     fileout     = file_out
     frameout   = frame_out
     expcal = "median(a)" 
     tframe2 = "tframe2.fits"
     tfl = "tfl.txt"
     fflag = "G"

     # check the existence files
     if (access(tframe2)) 
           imdelete(tframe2, ver-, >& "dev$null")
     if (access(tfl))
           delete(tfl, ver-, >& "dev$null")
     if (access(fileout))
           delete(fileout, ver-, >& "dev$null")
     if (access(frameout))
           imdelete(frameout, ver-, >& "dev$null")

     unlearn imexpr
     imexpr(expcal, tframe2, framein, outtype = "ref",
         refim = "auto", verbose=no) #  a - framein, output - tframe2

     # Write the row median image(1 x nrc) into a text file 
     #    (only need the third column)
     #wtextimage (tframe2, tfl, header=no, pixels=yes, 
     # format="", maxlinelen=mline) #--the format of the list is not consistent
     # use LISTPIXELS instead

       unlearn listpixels
       listpixels(tframe2, > tfl) 

     #  Checking the number of the file
     count(tfl) | scan(ss1)
     iss1 = int(ss1)
       if (iss1 < naxis1)
         {
           print("check tfl.txt, the number of line in the file is only ",iss1)
           fflag = "B"
           goto lab
         }
     # Calculate the mean of the row median
       nrc = 0; summed = 0.0
       flist = ""; flist = tfl; rcmed = 0.0   # open the file
         x1 =0.0; x2=0.0
       while(fscan(flist, x1, x2, rcmed) !=EOF)
         {
           nrc += 1
           summed += rcmed
         } # this brace is from while block (flist, rowmed)
       flist = "" # close the file
             nrc = naxis1

        mrcmed = summed/nrc
        #print("mrcmed = ", mrcmed)
        
      # Calculate the final version of the row median and store in a file
         flist = tfl # open the file
         while(fscan(flist, x1, x2, rcmed) !=EOF)
           {
             if (rcmed == 0.0)
                rcmed = 1.0

             frcmed = mrcmed/rcmed
             print(frcmed, >> fileout)
           }
         flist = ""  # close the file

      # Obtain the final verion of the row median image (nrc x 1)
        snrc = str(nrc)
        rtextimage (fileout, frameout, otype="real", header=no, pixels=yes, nskip=0, dim=snrc)
      

     # Cleaning up
           #imdelete(tframe2, ver-, >& "dev$null")
           #delete(tfl, ver-, >& "dev$null")

       lab:
        flag = fflag
end



