# IRAF script -- _mkdposlist.cl
#	
#   this is a sub file management task which is a HIDDEN task.
#    user cannot use it in the front end.
#   function: to make a list of an given quad-images of all dithering positions
#
# programmer: sjchan (dec 97)
#        
#

procedure _mkdposlist(root_name, quad_no, dither_no, file_out)

string root_name {"dd_", prompt="A rootname for lists of input files",mode="ql"}
string quad_no {"1", prompt="Which quadrant number?", mode="ql"}
int  dither_no {9, prompt="Total number of dithering position?", mode="ql"}
string file_out {"temp.out", prompt="Output file name", mode="ql"}

begin

        string  rootname   # rootname for list of input files
        string  quadno     # a given quadrant number
        int     ditherno   # total number of dithering position
        string  fileout   # output file name
        string  ifile     # temporary input file name
        int     icount3    # counter

      #  Get the rest of the parameters

        rootname = root_name
        quadno = quad_no
        ditherno = dither_no
        fileout = file_out


     # Check the existence of files
        if (access(fileout))
          delete (fileout, ver-, >& "dev$null")

       for (icount3 = 1; icount3 <= ditherno; icount3 += 1)
         {
           ifile = rootname//str(icount3)//".in"

           _mkqlist(ifile)       # make quadrant list
           unlearn type 
           type("quad_"//quadno//".in", >> fileout)
         }

end

