# IRAF script -- _findrcfl.cl
#	
#   this is a sub file management task which is a HIDDEN task.
#    user cannot use it in the front end.
#   function:  to divide a list of input files into few (total_folds) sublists
#                 of files which is in a file (inlist)
#              to make few lists of files which is in a file (outlist)
#
# programmer: sjchan 
#      history: 14july98 (created)
#               2-3aug98 -- modified (can select single chip and single 
#                             quadrant with given PIXCEL-tquad = 16; 
#                             also can select filelist without useless files)
#		 april99 -- mhoenig: added masses of fudge-like changes in order
# 		  to handle pre-assmebled frames. Should now work! (16-04-99)
#		28april99 - mhoenig: had to hunt around quite a bit for why
#			     single-quadrant processing wasn't working 
#			     properly. In the end, only changed the following
#			     line:
#			     if (tquad1!=1)  ic5 = 0
#			     (added the if statement)
#

procedure _findrcfl(file_in, tndr, tquad, range1, range2, tfold, fold_list, out_list)

string	file_in   {"",prompt="List of Input images",mode="ql"}
int     tndr  {min=2, prompt="total number of NDR in a given fold", mode="ql"}
int     tquad {16, prompt="Total number quadrants", mode="ql"}
int     range1   {1, prompt="Lower value of output RC pair", mode="ql"}
int     range2   {4, prompt="Upper value of output RC pair", mode="ql"}
int     tfold  {min=1, prompt="total number of folds for a fixed-pos obs",mode="ql"}
string  fold_list {"", prompt="a file containing fold input filenames",mode="ql"}
string  out_list {"", prompt="a file containing final fold output image names", mode="ql"}
string  f_flag   {prompt="indicator to check the number of input files, G/B"}
struct  *filist2


begin
        string  filein      # input file list
        int     tndr1      # total number of NDR in a given fold 
        int     tquad1     # total number of quadrants
        int     rc1        # lower value of output RC pair
        int     rc2        # upper value of output RC pair
        int     tfold1     # total number of folds for a fixed-pos observation
        string  foldlist    # a file containing fold input fileanmes 
        string  outlist     # a file containing fold output filenames
        string  ilist       # list of input files in #th fold
        string  ilisto      # a prefix for ilist file
        string  olist       # list of output files in #th fold 
        string  olisto      # a prefix for olist file
        string  framein2    # input frame (with datapath)
        string  ndrhead    # the prefix of input image per NDR
        string  fflag       # Flag for file-counter (G=o.k, B= imcomplete)
        string  flndr       # lists of input NDR in a given fold
        string  ndrlist1    # list of input images per NDR
        string  ndrin       # prefix for ndrlist1 file
        int     foldseq     # total sequence number in one fold
        int     ndrseq      # total sequence number per NDR (tquad1)
        int     ic, ic2, ic3, ic4# dummy counters
        int     kfold1       # current fold number in a for blcok of tfold
        string  cfold1      # current foldnum in string
        int     iquad       # current quad number in a for block of tquad
        string  srun        #  run number in string
        int     run         #  run number in integer
        int     ndig        #  number of digits in the run number
                             # assuming ndig = 4
        int     calseq      # PIXCEL sequence number calculated from formula
        int     calseq2     # calculated PIXCEL sequence number for comparsion
        int     cquad     # 1-dim quadrant number from header in integer(1..16)
        int     crquad    # 2-dim quadrant number from header in integer(1..4)
        int     ichip       # chip number from header in integer
        int     flseq       # PIXCEL sequence number from filename
        string  sflseq      # PIXCEL sequence number from filename in string
        int     i           # dummy variable
        int     tmpndr[2]   # dummy variable for rc1, rc2
        int     iq          # indicator for quadrant
        int     icc         # indicator for chip
        int     ichipold    # previous chip number for comparsion
        int     crquadold   # previsou quadrant number for comparsion
        int     ic5
        int     tmpquad     # virtual total quadrant number
	
	int startquad, endquad
	int iichip

      #  Get the rest of the parameters

        filein=file_in
        tndr1 = tndr
        tquad1 = tquad
        rc1 = range1
        rc2 = range2
        tfold1=tfold
        foldlist=fold_list
        outlist = out_list
        ilisto = "tmpinfold"
        ndrin = "infold"
        olisto = "outfold"
        fflag = "G"
        ndrhead = "ndr_"
        run = 0
        srun = ""
        ndig = 4
        ichipold = 0; crquadold = 0        
        tmpquad = 16


        cache imgets     # need this action due to a bug in imgets  
      
      # Check existence of output files
        if (access(foldlist))
          delete(foldlist, ver-, >& "dev$null")
        if (access(outlist))
          delete(outlist, ver-, >& "dev$null")

        foldseq = tquad1 * tndr1  # the total seq number in one fold

        if ((cndrproc.preass==1) && (substr(cndrproc.quadnos,1,1)=="a"))
		{
		foldseq = (tquad1/4) * tndr1
		}
        if ((cndrproc.preass==1) && (substr(cndrproc.quadnos,1,1)=="c"))
		{
		foldseq = (tquad1) * tndr1
		}
		
        filist2 = ""; filist2 = filein   #open the input file
   
	iq = 1; icc = 1
        
	while (fscan(filist2,framein2) !=EOF)
          {
	    imgets(framein2, para="chip")
            ichip = int(imgets.value)
	    
	    imgets(framein2, para="quad")
            if (imgets.value != "1 2 3 4")
	    {
	    crquad = int(imgets.value)  
	    }
	    else if (imgets.value == "1 2 3 4")
	    {
	    crquad = 0
	    }
	    
	    if ((ichipold == ichip) && (crquadold == crquad))
              {
		if (substr(cndrproc.quadnos,1,1)!="c") iq += 1   # if given simple quadrants number
		
		if (iq == 2)
                   goto jump1
              }
           
	   if (ichipold == ichip)
              {
                 icc += 1   # if given simple chip number

                 if (icc == 5)
                   goto jump1
              }
           else
              {
                 if (icc == 4)
                   goto jump1                
              }
            ichipold = ichip
	    
            crquadold = crquad

	  } # this brace is from while block 
           filist2 = "" # close the file
	
        jump1:
        iichip=ichip; ichip = 0; crquad = 0 # clear the variables, reuse again

       # make foldlist files
        filist2 = ""; filist2 = filein   #open the input file
        tmpndr[1] = rc1; tmpndr[2] = rc2
	
        ic = 0
        for (kfold1=1; kfold1 <= tfold1; kfold1 += 1) #outer for block of folds
         {  
            ic +=1
            ilist = ilisto//str(ic) # make a dummy fold list input filenames
            if (access(ilist))
               delete(ilist, ver-, >& "dev$null")

       # for block tmpndr[1] = rc1; tmpndr[2] = rc2 i=1,2
          ic5 = 0
          
	  for (i =1; i <= 2; i += 1)
            {
              tmpndr[i] = tmpndr[i] - 1

              if ((cndrproc.preass==1) && (substr(cndrproc.quadnos,1,1)=="c"))
	         {
		 startquad=iichip
		 endquad=iichip
		 }
	      else
	         {
		 startquad=1
		 endquad=tquad1
		 }	 		 
	      
	      for (iquad=startquad; iquad <= endquad; iquad += 1) #inner block of quads
               { 
		  ic5 += 1
		  calseq = (tmpndr[i]*tquad1) + iquad
                  calseq = calseq + foldseq * (kfold1 - 1)
                  
		  ic2 = 0

                  while (fscan(filist2,framein2) !=EOF)
                   {
                     ic2 += 1
         # get the run number of this set of files from the header or
           # from the file name, make a temphead from 1st-char to 
           #  the last "_" in the input filename string

                     if (ic2 == 1)
                       {
                         _locrnonew(framein2)
                         run = int(_locrnonew.srunno)
                         _sdigit(run, ndig)
                         srun = _sdigit.value
                         _locate(framein2, "_")
                         ic3 = _locate.value
                       }  # this brace is from ic2 == 1

            # get the sequence number from filename
                  sflseq = substr(framein2, ic3+1, ic3+3)
                  flseq  = int(sflseq)

            # calculate the right sequence number for comparsion

		imgets(framein2, para="chip")
                ichip = int(imgets.value)
                imgets(framein2, para="quad")
                crquad = int(imgets.value)                                  
                cquad = (ichip - 1)*4 + crquad

		  if (iq > 1)
		     {
		     if (tquad1==1)
		        {
			calseq2 = calseq
			}
		     else calseq2 = calseq + (cquad - 1)
                     }
		  else if (icc == 5)
                     calseq2 = calseq + (ichip - 1) * 4
                  else if (icc == 4)
                     calseq2 = calseq
		  if (cndrproc.preass==1)
		     calseq2 = calseq
		  
                 if (flseq == calseq2)
                    {
		      print(framein2, >> ilist)   # make an input fold list
                      goto jumplab
                    }
                  
		  if ((iq > 1) && (ic5 == 1))
                    goto jumplab2
                  if ((icc == 5) && (ic5 == 4))
                    goto jumplab2

                }  # this brace is from while loop
             print("Sorry, can't find the file with sequence ", calseq)
             print("Please check input files & input RC range")
             print("Exiting ...")
             fflag ="B"
             f_flag = fflag
             bye

             jumplab:
                if ((iq > 1) && (ic5 == 1))
                    goto jumplab2
                if ((icc == 5) && (ic5 == 4))
                    goto jumplab2

            } # this brace is from inner for block (iquad=1, tquad)

             jumplab2:
	     if (tquad1!=1)  ic5 = 0 

         } # this brace is from for block (tmpdir[i] = 1, 2)


           # make a ndr list per fold
            ndrlist1 = "r"//srun//"_"//ndrin//str(ic)
            print (ndrlist1, >> foldlist)

        # make a fold list output filenames
            olist = "r"//srun//"_"//olisto//str(ic) 
            if (access(olist))
               delete(olist, ver-, >& "dev$null")

	    print(olist, >> outlist)

      # Make the final version of input lists and output lists for calculation
         cfold1 = str(ic)   # current foldnum
         if (iq > 1)
            tmpquad = 1
         else if (icc == 5)
            tmpquad = 4
         else if(icc == 4)
            tmpquad = 16

	 if ((cndrproc.preass==1) && (substr(cndrproc.quadnos,1,1)=="a")) 
	    tmpquad = 4
	 if ((cndrproc.preass==1) && (substr(cndrproc.quadnos,1,1)=="c"))
	    tmpquad = 1   
	    
         _mkndrlist(ilist, tndr1, cfold1, tmpquad, rc1, rc2, ndrlist1, olist)
  
#         print(ndrlist1, >> ndrin)


          }  # this brace is from for outer for fold k
          filist2 = ""   # close the file

         delete(ilist, ver-, >& "dev$null")

         f_flag = fflag

end

