# IRAF script -- _cfdrift.cl
#                
#    function: to drive Mike Irwin's and rgm's fdrift (external program)
#	
#    stage: 
# programmer: sjchan 
#              9june98 -- created
#             24june98 -- using pipe clbye instead of cl
#                         changing the default temporary file name
#              6aug98  -- rename to _cfdrift.cl (driver of fdrift)
#

procedure _cfdrift(imgin, imgout)

string imgin     {"", prompt = "Input frame", mode="ql"}
string imgout    {"", prompt = "Output noise-corrected image", mode="ql"}

begin

     string imgin1         # input frame
     string imgout1        # final output noise-corrected image
     string driftinfl      # the temporary input file of drift   
     string fdriftjunk     # the temporary output file containing the output
                           #  printed on the screen (header information)

     # Get the rest of the parameters
     imgin1     = imgin
     imgout1    = imgout
     driftinfl  = "cfdrift.in"
     fdriftjunk = "cfdrift.out"

     # check the existence files
     if (access(imgout1))
           imdelete(imgout1, ver-, >& "dev$null")
     if (access(driftinfl))
           delete(driftinfl, ver-, >& "dev$null")
     if (access(fdriftjunk))
           delete(fdriftjunk, ver-, >& "dev$null")


     # prepare the input file for drift based on different option

     print(imgin1, >> driftinfl) # put the input imagename into the inputfile

     print(imgout1, >> driftinfl)

     # Now, we are ready to run 'fdrift'
       	# fdrift (< "cfdrift.in")
	fdrift (< driftinfl, > fdriftjunk)

end
