# IRAF script -- _cdrift.cl
#                
#    function: to drive mike Irwin's drift.e (external program)
#	
#    stage: 
# programmer: sjchan 
#             9june98 -- created
#             24june98 -- using pipe clbye instead of cl
#                          changing the default temporary file name
#	      23june99 - mhoenig: changed somewhat; mainly the pixtype stuff 
#			(incoming data should always be short) and the input 
#			parameters for drift
#

procedure _cdrift(imgin, index, imgout)

string imgin     {"", prompt = "Input frame", mode="ql"}
string index     {"B", prompt = "Destriping option (R|C|B)", mode="ql"}
string imgout    {"", prompt = "Output noise-corrected image", mode="ql"}
string pixtype   {"real", prompt = "pixtype of output image", mode="ql"}


begin

     string imgin1         # input frame
     string index1         # destriping index (MR/MC/MB)
     string imgout1        # final output noise-corrected image
     string pixtype1       # pixtype of output image (default: real)
     string driftinfl      # the temporary input file of drift   
     string fdriftjunk     # the temporary output file containing the output
                           #  printed on the screen (header information)

     # Get the rest of the parameters
     imgin1     = imgin
     index1     = index
     imgout1    = imgout
     pixtype1   = pixtype
     driftinfl  = "cdrift.in"
     fdriftjunk = "cdrift.out"

     if (index1 == "")
         index1 = "B"	# default 

     if ((pixtype1 != "real")&&(pixtype1 != "short")&&(pixtype1 != "ushort"))
        pixtype1 = "real"

     # check the existence of files
     if (access(imgout1))
           imdelete(imgout1, ver-, >& "dev$null")
     if (access(driftinfl))
           delete(driftinfl, ver-, >& "dev$null")
     if (access(fdriftjunk))
           delete(fdriftjunk, ver-, >& "dev$null")

     # prepare the input file for drift

     print("N", >> driftinfl)  # Linux machine?
     print(imgin1, >> driftinfl)  # put the input imagename into the inputfile

     # if ((pixtype1 == "short") || (pixtype1 == "ushort"))
     #   {  # data is NOT reset-corrected (RAW data)
          print("N", >> driftinfl)  # Is the data 16 bit unsigned integer?
          print("N", >> driftinfl)  # Is the data VAX integer*2 format?
     #  } # this brace is from if block (pixtype1 == integer)


     if (index1 == "B")
        print("Y", >> driftinfl) # Do you want to filter in both directions?
     else if (index1 == "C") 
        {
          print("N", >> driftinfl) # not to filter in both directions
          print("Y", >> driftinfl) # column direction only? [Y] otherwise row
        }
     else if (index1 == "R")
        {
          print("N", >> driftinfl)
          print("N", >> driftinfl)
        }
     else 
        print("Y", >> driftinfl) # wrong indicator -- using default

  
     # answer the rest of the questions
        print("Y", >> driftinfl) # Deal with background variations? [Y]
        print("N", >> driftinfl) # Do you want to alter default line width? [N]
                          #Graphics device/type (? to see list, default /NULL)
        print("/NULL", >> driftinfl) 
        print(imgout1, >> driftinfl)

     # Now, we are ready to run 'drift'
        # drift (< "cdrift.in")
        drift (< driftinfl, > fdriftjunk)

end



