# IRAF script -- cmkrcimg.cl
#	
#   function:  to produceall RC images given from a set adjcent pairs of
#                RC images.
#                 
#
# programmer: sjchan (jan 98)
#        
#

procedure cmkrcimg(rcfl_in, rcfl_out, pix_type, calc_type)

string	rcfl_in   {"@rc_rootname.in",prompt="(@List of lists) of Input RC files",mode="ql"}
string  rcfl_out  {"rc2_rootname.in", prompt="(@List of lists) of Output RC files", mode= "ql"}
string  pix_type {"real", prompt="pixtype of output images", mode="ql"}
string  calc_type {"real", prompt="calctype for IMARITH operation", mode="ql"}

struct  *rilist1 

begin
        string  ftmpi      # input file list
        string  ifile      # a file containing input fold filenames
        string  ofile      # a file containing output fold filenames
        string  flin1      # input file fold list containg RC files
        string  flout1    # output file fold list containing RC files
        string  flout2    # temporary output file fold list 
        string  flout3     # final output file fold list containg RC files
        string  vflin1     # input file fold list in reverse order
        string  vflin2     # temporary file fold list in reverse order
        string  vflin3
        string  cmkrcimglog  # logfile
        int     ic         # dummy counters
        int     ifold       # fold counter
        int     leni       # length of input file list string
        int     ii, jj     # dummy counters
        string  sline      # dummy variable for FIELDS input         
        string  ss1         # dummy variables
        string  pixty1      # pixtype of output images
        string  calcty1     # calcuating type for IMARITH
        int     iss1        # dummy variable ss1 in integer
        string  templog     # temporary logfile

      #  Get the rest of the parameters

        ftmpi = rcfl_in
        ofile = rcfl_out
        pixty1 = pix_type
        calcty1 = calc_type
        cmkrcimglog = "cmkrcimg.log"
        templog = "cmkslope.log"
        vflin2 = "vflin2.in"
        vflin1 = "vflin1.in"
        vflin3 = "vflin3.in"
        flout1 = "flout1.in"
        flout2 = "flout2.in"

      # Make sure the appropriate packages are loaded.
        if (!defpac("tables"))
           tables
        
      #  Find out the suitable input option

        leni=strlen(ftmpi)

        if (stridx(ftmpi, "@") == 1)
          {
           ifile = substr(ftmpi, 2, leni)
          }
        else
         {
           ifile = mktemp("fin")
           sections(ftmpi, option="fullname", > ifile)
         }

     # Check existence of output files

        if (access(ofile))
          delete(ofile, ver-) 
        if (access(cmkrcimglog))
          delete(cmkrcimglog, ver-)

        ifold = 0
        rilist1 = ""
        rilist1 = ifile

        while ( (fscan(rilist1, flin1) !=EOF) )
         {    # flin1 = outfold#   
           ifold += 1

           print ("Fold: ", ifold)
           print("*****************************************", >> cmkrcimglog)
           print("", >> cmkrcimglog)
           print("Fold: ", ifold, >> cmkrcimglog)
           flout3 = "ofold"//ifold    
           print(flout3, >> ofile)

           if (access(flout1))
              delete(flout1, ver-, >& "dev$null")
           if (access(flout2))
              delete(flout2, ver-, >& "dev$null")

        #  Transpose the input fold list and make a set of input files for
        #   for the purpose of different combination

           if (access(vflin1))
              delete(vflin1, ver-, >& "dev$null")

           unlearn type
           type (flin1, >> flout2)

           ttranspose(flin1, vflin1, "v", ver-)
           count(vflin1) | scan(ss1)  #produce ss1 - 1 files
           iss1 = int(ss1) - 1
           for (jj = 1; jj <= iss1; jj += 1)
              {
                if (access(vflin2))
                   delete(vflin2, ver-, >& "dev$null")

                sline= str(jj)//"-"
                unlearn fields

                fields(vflin1, "1", lines=sline, >> vflin2)
                if (access(vflin3))
                   delete(vflin3, ver-, >& "dev$null")

                ttranspose(vflin2, vflin3, "v", ver-)

                unlearn cmkslope
                cmkslope(vflin3, flout1, pixty1, calcty1)
                unlearn type
                type (templog, >> cmkrcimglog)
                type (flout1, >> flout2)
                print("=========================================", >> cmkrcimglog)      
              }  # this brace is from for fold (jj=1 - iss1)

           if (access(flout3))
              delete(flout3, ver-, >& "dev$null")

           unlearn sort
           sort(flout2, column= 1, >> flout3)

         }   # this brace is from while fold (rilist1, flin1)



         # close the files and cleaning up
           rilist1 = ""
           delete(vflin1, ver-, >& "dev$null")
           delete(vflin2, ver-, >& "dev$null")
           delete(flout1, ver-, >& "dev$null")
           delete(flout2, ver-, >& "dev$null")
   
          if (access(ofile))
            {
              print("")
              print("You need to rename ofold* and rc*_?f if you wish to use them later")
              print("")
            }

         if (stridx(ftmpi, "@") != 1)
            delete(ifile, ver-, >& "dev$null")
         

          print("   << ========= CMKRCIMG DONE =========== >>")
          beep; beep; beep

end

