# IRAF script -- _mkndrlist.cl
#	
#   this is a sub file management task which is a HIDDEN task.
#    user cannot use it in the front end.
#   function:  to divide a list of finput iles into few (total_folds) sublists
#                 of files which will be in a file (inlist)
#              to make few lists of files which will be in a file (outlist)
#
# programmer: sjchan (
#        history: jan98 -- created
#                26june98 -- add a function (subtask) in order to seperate
#                             the path name is the list
#        
#

procedure _mkndrlist(file_in, totndr, cfold, ndr_list, out_list, totquad)

string	file_in   {"",prompt="List of Input images",mode="ql"}
int     totndr  {min=1, prompt="Total number of NDR for a fixed-pos obs",mode="ql"}
string  cfold   {"01", prompt="Current fold number (with 0 before 1-9)", mode="ql"}
string  ndr_list {"", prompt="File contain input list per fold", mode="ql"}
string  out_list {"", prompt="File contain output list per fold", mode="ql"}
int     totquad  {16, prompt="Total number of quadrants", mode="ql"}
string  check    {"", prompt="Check file flag (G/B)"}
struct  *filist


begin
        string  filein      # input file list
        int     totndr1     # total number of ndrs for a fixed-pos observation
        string  cfold1      # current fold number
        string  ndrlist    # a file containing ndr input fileanmes per fold
        string  outlist     # a file containing ndr output filenames per fold
        string  ilist       # list of input files in #th ndr
        string  ilisto      # a prefix for ilist file
        string  olist       # list of output files in #th ndr
        string  olistt      # temporary prefix of list of output files in
                            #th ndr
        string  olisto      # a prefix for olist file
        string  framein     # input frame with full path name
        string  framein2    # input frame without full path name
        string  temphead    # the prefix of an image name
        string  temptail    # the subfix(extension) of an image name
        string  sc          # dummy indicator/counter in string
        string  sic, sic2   # dummy counters in string with prefix "0" in (1-9)
        string  foldtail    # dummy variable
        string  check1      # check file flag
        int     icounter    # counter
        int     ndrseq     # total sequence number in one ndr (= tot_quad)
        int     totquad1   # total quadrants
        int     ic, ic2     # dummy counters
        int     len         # the total length of an input filename
        int     lentemp     # the location of the last '_" in the filename
        int     lentemp2    # the location of the last "." in the filename
        int     icp1        # ic + 1 (in integer)
        string  sicp1       # ic + 1 (in string)
        string  sruno       # running number (in string)
        int     locrun      # the run number in integer
        int     ndig        # the number of digit in integer
        string  s1

      #  Get the rest of the parameters

        filein=file_in
        totndr1=totndr
        cfold1 = cfold
        ndrlist=ndr_list
        outlist = out_list
        totquad1 = totquad
        ilisto = "ndr"
        olisto = "rc"
        foldtail="_"//cfold1//"p"
        temphead = ""
        temptail = ""
        sruno = "0000"
        locrun = 0
        ndig = 4

        if (access(ndrlist))
          delete(ndrlist, ver-, >& "dev$null")
        if (access(outlist))
          delete(outlist, ver-, >& "dev$null")

        # find out the total number of input files in the list
        count(filein) | scan(s1)
        icounter = int(s1)

        # find out the total seq number in one ndr
        ndrseq = icounter/totndr1     # total quads 
        if (ndrseq != totquad1) 
          { 
            print("File IMCOMPLETE!!")
            check1 = "B"
            check = check1
            bye
          }
         else
           check1 = "G"

        filist = ""; filist = filein   # open the file
       # make ndrlist files

         ic = 0
         
         for (k=1; k <= icounter; k += ndrseq)
          {  
            ic += 1
            _sdigit(ic, 2)
            sic = _sdigit.value
      
            icp1 = ic+1
            _sdigit(icp1, 2)
            sicp1 = _sdigit.value
            ilist = ilisto//sic//foldtail # make a ndr list input filenames
            olistt = olisto//sicp1//sic//foldtail 
                               # make a ndr list output filenames (fixed name)
                                # fixed substring, temporary only
            olist = olistt

               ic2 = 0
               while (fscan(filist,framein) !=EOF)
                {
                  ic2 += 1
                  if (ic2 == 1)
                    {
                      imgets(framein, param="nrun")
                      sruno = imgets.value
                      if ((sruno == "") || (sruno == "0") || (sruno == "/"))
                        { # try to get the running number from filename
                           _locrunno(framein)
                           locrun = int(_locrunno.value)
                           _sdigit(locrun, ndig)
                           sruno = _sdigit.value
                        }
                 olist="r"//sruno//"_"//olistt #(ndr input list name with nrun)
                  ilist="r"//sruno//"_"//ilist # ndr output list name with nrun

                    if (access(ilist))
                      delete(ilist, ver-, >& "dev$null")
                    if (access(olist))
                       delete(olist, ver-, >& "dev$null")

                    } # this brace is from (if block ic2 == 1)

                  print(framein, >> ilist)   # make an input ndr list

        # add this option on 26june98
        # to seperate the pathname from the full image name with pathname
                   _sepdir(framein)
                   framein2 = _sepdir.fname

        # find out the location of the last "_" in the given filename
                  len = strlen(framein2)
                  _locate(framein2, "_")
                   lentemp = _locate.value

        # make the prehead from char#1 to char#(lentemp)
                     temphead = substr(framein2, 1, lentemp)

        # find out the location of the last "." in the given filename
                   _locate(framein2, ".")
                   lentemp2 = _locate.value
                  if (ic2 == 1)
                        temptail = substr(framein2, lentemp2, len)

        # make an output ndr list

                 
                 print(temphead//olistt//temptail, >> olist)

         
        # check whether a "complete" is finished
                   if (ic2 == ndrseq)
                         break     # leave the ndr to create another file
                }  # this brace is from while ndr

        # collect the input and output list by ndrlist and outlist

              print (ilist, >> ndrlist)

              if (ic < totndr1)
                 print(olist, >> outlist)


          }  # this brace is from for outer ndr i

          filist = ""   # close the file

          check = check1
end

