# IRAF script -- _mkldlist.cl
#	
#   this is a sub file management task which is a HIDDEN task.
#    user cannot use it in the front end.
#   function:  to divide a list of finput iles into few (total_folds) sublists
#                 of files which will be in a file (inlist)
#              to make few lists of files which will be in a file (outlist)
#
# programmer: sjchan 
#   history: jan98   -- created 
#            3feb98  -- make the filename of the list of output files in 
#                        #th fold be unique (with run number) : olist
#        
#

procedure _mkldlist(file_in, tot_ndr, tot_fold, fold_list, out_list, tot_quad)

string	file_in   {"",prompt="List of Input images",mode="ql"}
int     tot_fold  {min=1, prompt="total number of folds for a fixed-pos obs",mode="ql"}
int     tot_ndr  {min=2, prompt="total number of NDR in a given fold", mode="ql"}
string  fold_list {"", prompt="a file containing fold input filenames",mode="ql"}
string  out_list {"", prompt="a file containing final fold output image names", mode="ql"}
int     tot_quad {16, prompt="total number of quadrants", mode="ql"}
string  f_flag   {prompt="indicator to check the number of input files, G/B"}
struct  *filist2


begin
        string  filein      # input file list
        int     totndr      # total number of NDR in a given fold
        int     totfold     # total number of folds for a fixed-pos observation
        string  foldlist    # a file containing fold input fileanmes 
        string  outlist     # a file containing fold output filenames
        string  ilist       # list of input files in #th fold
        string  ilisto      # a prefix for ilist file
        string  olist       # list of output files in #th fold 
        string  olisto      # a prefix for olist file
        string  framein     # input frame
        string  framein2    # input frame (with FITS extension)
        string  ndrhead    # the prefix of input image per NDR
        string  fflag       # Flag for file-counter (G=o.k, B= imcomplete)
        string  flndr       # lists of input NDR in a given fold
        string  ndrlist1    # list of input images per NDR
        string  cfold1      # current foldnum
        string  ndrin       # prefix for ndrlist1 file
        int     icounter    # file counters
        int     icounter2   # file counters
        int     foldseq     # total sequence number in one fold
        int     ndrseq      # total sequence number per NDR (tot_quad)
        int     totquad1    # total quadrands
        int     ic, ic2  # dummy counters
        int     kk          # dummy variable
        string  srun        #  run number in string
        int     run         #  run number in integer
        int     ndig        #  number of digits in the run number
                             # assuming ndig = 4

      #  Get the rest of the parameters

        filein=file_in
        totndr = tot_ndr
        totfold=tot_fold
        foldlist=fold_list
        outlist = out_list
        totquad1 = tot_quad 
        ilisto = "tmpinfold"
        ndrin = "infold"
        olisto = "outfold"
        fflag = "G"
        ndrhead = "ndr_"
        run = 0
        srun = ""
        ndig = 4
         
      # Check existence of output files
        if (access(foldlist))
          delete(foldlist, ver-, >& "dev$null")
        if (access(outlist))
          delete(outlist, ver-, >& "dev$null")

        # find out the total number of input files in the list
        count(filein) | scan(s1)
        icounter = int(s1)

        foldseq = totquad * totndr  # the total seq number in one fold
        icounter2 = foldseq * totfold   # get the total number from inputs

        # check whether these numbers are same
        if (icounter != icounter2)
          {
            print ("Input files IMCOMPLETE")
            fflag = "B"
            f_flag = fflag
            bye 
          } 
   
        filist2 = ""; filist2 = filein   # open the file
       # make foldlist files

         ic = 0
         for (kk=1; kk <= totfold; kk += 1)
          {  
            ic += 1
            ilist = ilisto//str(ic) # make a dummy fold list input filenames

            if (access(ilist))
               delete(ilist, ver-, >& "dev$null")

               ic2 = 0
               while (fscan(filist2,framein2) !=EOF)
                {
                  ic2 += 1
         # get the run number of this set of files from the header or
           # from the file name

                  if (ic2 == 1)
                    {
                       _locrunno(framein2)
                       run = int(_locrunno.value)
                       _sdigit(run, ndig)
                       srun = _sdigit.value
                    }  # this brace is from ic2 == 1

         # check whether the input frame with FITS extension
                  _checkfit(framein2)
                  framein = _checkfit.framext # nov the file with FITS extension
                  print(framein, >> ilist)   # make an input fold list

        # check whether a "complete" is finished
                   if (ic2 == foldseq)
                         break     # leave the loop to create another file
                }  # this brace is from while loop

       # make a ndr list per fold
            ndrlist1 = "r"//srun//"_"//ndrin//str(ic)
            print (ndrlist1, >> foldlist)

        # make a fold list output filenames
            olist = "r"//srun//"_"//olisto//str(ic) 
            if (access(olist))
               delete(olist, ver-, >& "dev$null")

            print(olist, >> outlist)

       # Make the final version of input lists and output lists for calculation
         cfold1 = str(ic)   # current foldnum
         _mkndrlistold(ilist, totndr, cfold1, ndrlist1, olist, totquad1)
  
#         print(ndrlist1, >> ndrin)


          }  # this brace is from for outer for fold k
          filist2 = ""   # close the file
         f_flag = fflag
end

