# IRAF script -- cirslice.cl
#
#    function: to slice a set of infrared image from 3D to 2D
#	
# programmer: sjchan (january 1997, oct 1997)
#

procedure cirslice(frame_in)

string	frame_in   {"",prompt="(List of) Input images",mode="ql"}
struct  *filist

begin
        string  ftmpi             # List of input images
        string  ifile, ofile      # final version of input and output list
        string  slicelog          # logfile
        string  ind               # indicator
        string  hofile, hofile2   # the real output file list from cirslice
        int     leni              # dummy variable
        int     iaxis3            # the length of axis3

        #  Get the rest of the parameter

        ftmpi=frame_in
        iaxis3=3
        slicelog="cirslice.log"
        ind="L"    # dummy definition
        ifile="dummy1"
        ofile="dummy2"
        hofile="slice.out"
        leni=1

        #  Check the existence of the logfile
           if (access(slicelog))
             delete(slicelog, ver-, >& "dev$null")
           if (access(ifile))
             delete(ifile, ver-, >& "dev$null")
           if (access(ofile))
             delete(ofile, ver-, >& "dev$null")

        #  Find out the suitable input option

           _finout(ftmpi, ind, ifile, ofile)

        #  Slice processing

        print("   <<------ slice processing ------>>")
        imslice("@"//ifile, "@"//ofile, slice_dimension=iaxis3,
           verbose=yes, >> slicelog)

        # updated the title in the image header and the noise-cor flag
        #  to the header, make a list of output file names.

#          _irheadup("@"//hofile, ind)

        leni=strlen(ftmpi)
        if (stridx(ftmpi, "@") == 1)
          {
           hofile2="l"//substr(ftmpi, 2, leni)
           rename(hofile,hofile2, field="all")
          }
        else
           hofile2 = ""

        # Clearing up
    
          delete(ofile, ver-, >& "dev$null")
          delete(ifile, ver-, >& "dev$null")

        print("   <<======= cirslice DONE ========>>")
end

