# IRAF script -- ccmkpsky.cl
#
#   function: to make a sky frame using projection=yes in imcombine
#	
# programmer: sjchan (january, Feb, April 1997)
#           Oct 97: call a small file mangement task _profinout.cl 
#

procedure ccmkpsky(frame_in,frame_out, frame_no)

string	frame_in   {"",prompt="(List of) Input images",mode="ql"}
string  frame_out  {"",prompt="Output image (combined sky frame)",mode="ql"}
string  frame_no   {"1",prompt="The starting fold number for projection imcombine"}
struct  *filist

begin
        string  framein       # dummy variable (Input image)
        string  frameout      # output combined sky image
        string  ftmpi         # List of input images
        string  axis3         # length of axis3
        string  ifile, ofile  # final version of input and output 
        string  skylog        # logfile
        string  framest       # starting fold number for projection imcombine
        int     icount        # counter
        int     nh, nl        # nlow and nhigh for rejection=minmax in 
                              # imcombine
        int     nu, nb
        int     iaxis3        # length of axis3


        #  Get the rest of the parameter

        ftmpi=frame_in
        frameout=frame_out
        framest=frame_no
        axis3=""        
        skylog="ccmkpsky.log"
        icount=0
        nh=1
        nl=1
        nu=5
        nb=5
        ifile = "dummy1"
        ofile = "dummy2"
		
        #  Check the existence of the files
           if (access(skylog))
             delete(skylog, ver-, >& "dev$null")
           if (access(ifile))
             delete(ifile, ver-, >& "dev$null")
           if (access(ofile))
             delete(ofile, ver-, >& "dev$null")
           if (access(frameout))
             delete(frameout, ver-, >& "dev$null")

        # Find out the suitable input and output files
       
          _profinout(ftmpi, framest, ifile, ofile)

        filist = ifile   # open the file
        while (fscan(filist,framein) !=EOF)
        {
          imgets(framein, para="i_naxis3")
          axis3=imgets.value
          iaxis3 = int(axis3)
          break
        }
        filist = ""  # close the  file
      
        # count number of input images in the list
        sections("@"//ifile, option = "fullname", >& "dev$null")
        icount = sections.nimages
        print("icount:", icount)  
        print("axis:", iaxis3)

        if (iaxis3 <= 2)
         {
           nu = 0
           nb = 0
          }
        else if ((iaxis3 > 2) && (iaxis3 < 5))
          {
           nu = 1
           nb = 0
          }
        else if ((iaxis3  > 5) && (iaxis3 < 10))
          {
           nu = 2
           nb = 1
          }
        else if (iaxis3 < 20)
          {
           nu = 5
           nb = 3
          }
        else if (iaxis3 < 30)
          {
           nu = 10
           nb = 5
          }
         else
          {
            nu = 10
            nb = 10
          }
         
        imcombine("@"//ifile,"@"//ofile,combine="average", reject="minmax",
          project=yes, outtype="real", offset="none", masktype="none",
          maskvalue=0, blank=0, scale="median", zero="none", weight="none",
          expname="", statsec="", nlow=nb, nhigh=nu, logfile=skylog)

        if (icount > 5)
           nh = 4
        else if (icount > 4)
             nh = 3
        else if (icount > 3)
             nh = 2
        else if (icount > 2)
             nh = 1
        else
        {
            nh = 1
            nl = 0
        }

        if (icount > 1)
         imcombine("@"//ofile, frameout, combine="average", reject="minmax",
          project=no, outtype="real", offset="none", masktype="none",
          maskvalue=0, blank=0, scale="median", zero="none", weight="none",
          expname="", statsec="", nlow=nl, nhigh=nh, logfile=skylog)
        else
         imcopy("@"//ofile, frameout, verbose=yes, >> skylog)

        # Cleaning up 
  
        imdelete ("@"//ofile,ver-, >& "dev$null")
        delete (ifile//","//ofile,ver-, >& "dev$null")

        if (stridx(ftmpi, "@") != 1)
            delete(ifile, ver-, >& "dev$null")

        print("    << ======= ccmkpsky DONE =======>>")


end

